<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

class HookDocument {

    /*
    *   
    */
    function sendNotification($bean, $event, $arguments) {
        
        if ($event != 'before_save') return;
        
        # On récupere le document avant modification et on vérifie qu'il a bien été récupéré
        $obj_document = new Document();
        $obj_document = $obj_document->retrieve( $bean->id );
        if (empty($obj_document->id) && !empty($_REQUEST) && $_REQUEST["return_action"] != 'SubPanelViewer' ) return;
        
        # On vérifie que la variable importable du document est passée de false à true 
        if( ($obj_document->importable == false && $bean->importable == true) || (!empty($_REQUEST) && $_REQUEST["return_action"] == 'SubPanelViewer')){


            # On vérifie l'id et le type du module
            $module_id = !empty($_REQUEST["return_id"]) ? $_REQUEST["return_id"] : $bean->related_doc_id;
            $module_type = !empty($_REQUEST["return_module"]) ? $_REQUEST["return_module"] : $bean->parent_type;

            # Suppression des REQUEST pour les actions en masse
            unset($_REQUEST["return_module"]);
            unset($_REQUEST["return_id"]);

            # On vérifie que le module est bien dans le tableau des modules supportés 
            if ( !in_array($module_type,['OPS_individu','OPS_personne_morale','OPS_dossier']) ) {
                $GLOBALS['log']->fatal( "HookDocument::sendNotification() => module '".$module_type."' non pris en compte" );
                return;
            }

            # On récupére l'id du template à utiliser 
            $template_id = $this->getTemplateNotificationUsager($module_type);

            if ( !isset($template_id) || empty($template_id) ) {
                $GLOBALS['log']->fatal( "HookDocument::sendNotification() =>  Pas te template mail associé à cette action" );
                return;
            }

            # Traitement spécial pour les dossiers on récupere le mail associé à l'individu rattaché au dossier ( Le demandeur )
            if ( $module_type === 'OPS_dossier' ) {
                $obj = new OPS_dossier() ; 
                $obj = $obj->retrieve( $module_id );
                $obj_type = 'OPS_dossier';
                $module_type = 'OPS_individu';
                $module_id = !empty($obj->ops_individu_id) ? $obj->ops_individu_id : "";

                $obj_individu = new OPS_individu();
                $obj_individu = $obj_individu->retrieve( $module_id ); 
                $email = !empty($obj_individu->email1) ? $obj_individu->email1 : ""; 
            }else{
                # On récupére l'email associé au module 
                $obj = new $module_type();
                $obj = $obj->retrieve($module_id);
                $obj_type = $module_type;
                $email = !empty($obj->email1) ? $obj->email1 : ""; 

                if($module_type == "OPS_personne_morale" && empty($email)){
                    $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale',$module_id);
                    $personneMoraleIndividu = $objPersonneMorale->get_linked_beans('ops_personne_morale_ops_personne_morale_individu','OPS_personne_morale_individu', '',0,-1,0,'responsable="1"');
                    $objIndividu = BeanFactory::getBean('OPS_individu',$personneMoraleIndividu[0]->ops_individu_id);
                    $email = !empty($objIndividu->email1) ? $objIndividu->email1 : "";
                    $module_type = 'OPS_individu';
                    $module_id = $objIndividu->id;
                }
            }

            # On initialise le mailer 
            $mailer = new OdeMailer();

            # On initialise l'email 
            $ode_email = new OdeEmail([
                'bean_source_id' => $obj->id,
                'bean_source_name' => $obj_type,
                'bean_historisation_id' => $module_id,
                'bean_historisation_name' => $module_type,
                'email_template_id' => $template_id,
                'dest_to' => $email,
            ]);

            # On déclenche l'envoie
            $mailer->send($ode_email);

        }
        
    }

    protected function getTemplateNotificationUsager( $module_name = ''){

        global $sugar_config;
        
        $template_id = '';
        switch ($module_name) {
            case 'OPS_individu':
                $template_id = !empty($sugar_config['opensocle']['notif_usager_document_individu']) ? $sugar_config['opensocle']['notif_usager_document_individu'] : "";
                break;
            case 'OPS_personne_morale':
                $template_id = !empty($sugar_config['opensocle']['notif_usager_document_profil']) ? $sugar_config['opensocle']['notif_usager_document_profil'] : "";
                break;
            case 'OPS_dossier': 
                $template_id = !empty($sugar_config['opensocle']['notif_usager_document_dossier']) ? $sugar_config['opensocle']['notif_usager_document_dossier'] : "";
                break;
        }
        return $template_id;
    }

    function initBadge($bean,$event,$arguments = null){

        global $app_list_strings;

        if($event != 'process_record') return;

        $couleur = (  $bean->importable == true ) ? "green" : "red";
        $texte = (  $bean->importable == true ) ? "Visible" : "Masqué";

        $bean->status_id = '<span id="visible_'.$bean->id.'" class="badge" style="background: ' . $couleur . ';">'.$app_list_strings['document_status_dom'][$bean->status_id] . " : " .$texte.'</span>';

    }
}