<?php 

$job_strings[] = 'notification_suppression_compte_usager';

/*
 * Tâche planifié qui permet de : 
 * - notifier un usager lorsque que son compte n'est plus utilisé depuis X jours 
 * - supprimer le compte de l'usager lorsque son compte n'est plus utilisé depuis Y jours
 */
function notification_suppression_compte_usager()
{
    /**
     * RECUPERATION DES ELEMENTS DE CONFIG
     */
    global $db;
    $configuratorObj = new Configurator();
    $delaiNotif = $configuratorObj->config['opensocle']['delai_notification_compte_non_utilise'];
    $delaiSuppr = $configuratorObj->config['opensocle']['delai_suppression_compte_non_utilise'];
    $pointDeDepart = $configuratorObj->config['opensocle']['definition_compte_non_utilise'];
    $modeleDeMailNotif = $configuratorObj->config['opensocle']['notif_non_utilisation_compte'];
    $modeleDeMailSuppression = $configuratorObj->config['opensocle']['notif_usager_suppression'];


    $GLOBALS['log']->error(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));
    

    /**
     * CREATION DE FONCTION UTILITAIRE
     */

    # recuperation des individus considéré non utilisé depuis un certain delai
    $getIndividuParDelais = function($delai, $checkNotification) use($pointDeDepart, $db) {
        if($pointDeDepart == 'connexion'){
            $sql = "SELECT DISTINCT ind.id
                    FROM ops_individu ind
                    -- le join ici permet de selectionner la derniere date de connexion de chaque usager
                    JOIN (
                        SELECT r1.ops_individu_id, MAX(his.derniere_connexion) AS last_connexion
                        FROM ops_historique_connexion_ops_individu r1
                        JOIN ops_historique_connexion his ON his.id = r1.ops_historique_connexion_id
                        WHERE r1.deleted = 0 AND his.deleted = 0
                        GROUP BY r1.ops_individu_id
                    ) his_max ON his_max.ops_individu_id = ind.id
                    WHERE ind.deleted = 0 
                    --  derniere date de connexion + delai (j) < aujourdui
                    --  vrai => le delai est depasse
                    --  faux => le delai n'est pas depasse
                    AND DATE_ADD(his_max.last_connexion, INTERVAL $delai DAY) < CURDATE()"
                    . ($checkNotification ? " AND ind.inactif_notification = 0" : "") ; 
        }
        else if($pointDeDepart == 'dossier'){
            /**
             * On prend les individus non supprimés, qui ne sont pas anonyme pour lequels il n'existe pas de dossier 
             * vivant (non cloturé/non supprimé OU en brouillon) sur les X derniers jours
             */
            $sql = "SELECT DISTINCT ind.id
                    FROM ops_individu ind
                    JOIN ops_individu_ops_dossier r1 ON r1.ops_individu_id = ind.id
                    JOIN ops_dossier dos ON dos.id = r1.ops_dossier_id
                    WHERE 
                        ind.deleted = 0
                        AND ind.last_name NOT LIKE 'anonyme'"
                        . ($checkNotification ? " AND ind.inactif_notification = 0" : "") 
                        ." AND NOT EXISTS (
                            -- exclusion des dossier encore en vie dans les x derniers jours
                            SELECT 1 
                            FROM ops_individu_ops_dossier r2
                            JOIN ops_dossier d2 ON d2.id = r2.ops_dossier_id
                            WHERE r2.ops_individu_id = ind.id
                            AND ((d2.cloture = 0 AND d2.deleted = 0) OR d2.name = 'TEMP')  -- Dossier encore vivant
                            AND DATE_ADD(d2.date_modified, INTERVAL $delai DAY) >= CURDATE()   -- dans les x derniers jours
                        );";
        }
        else return false;
        

        return $db->query($sql);
    };

    # notifier un individu
    $actionNotifier = function($idIndividu, $modeleDeMailNotif) {
        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);

        $GLOBALS['log']->error(print_r("# Notification à l'usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));
        
        $mailIndividu = $beanIndividu->email1;

        if(empty($mailIndividu)) {
            $GLOBALS['log']->error(print_r("-> l'usager n'a pas d'adresse mail",true));
            return false;
        }


        
        $mailer = new OdeMailer();

        $ode_email = new OdeEmail([
            'bean_source_id' => $idIndividu,
            'bean_source_name' => "OPS_individu",
            'bean_historisation_id' => $idIndividu,
            'bean_historisation_name' => "OPS_individu",
            'email_template_id' => $modeleDeMailNotif,
            'dest_to' => $mailIndividu,
        ]);

        # On déclenche l'envoie
        $mailSended = $mailer->send($ode_email);

        // l'usager a ete notifie
        if($mailSended){
            $beanIndividu->inactif_notification = 1;
            $beanIndividu->save();
        }


        return true;

    };

    # supprimer un individu
    $actionSupprimer = function($idIndividu) use ($actionNotifier, $modeleDeMailSuppression){
        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);
        $actionNotifier($idIndividu, $modeleDeMailSuppression);
        $GLOBALS['log']->error(print_r("# Suppression du compte usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));
        $beanIndividu->mark_deleted($idIndividu);
    };

    /**
     * FIN DES FONCTIONS UTILITAIRES
     */



    /** 
     * NOTIFICATIONS
     */

    $GLOBALS['log']->error(print_r("## Traitement des notifications",true));


    $individuANotifier = $getIndividuParDelais($delaiNotif, true);


    if(!empty($modeleDeMailNotif)){
        while($row = $db->fetchByAssoc($individuANotifier)){
            $actionNotifier($row['id'], $modeleDeMailNotif);
        }
    }


    else $GLOBALS['log']->error(print_r("# Les notifications aux usagers n'a pas pu être réalisé : aucun modèle de mail de notification n'a été paramétré",true));


    
    $GLOBALS['log']->error(print_r("## Fin traitement des notifications",true));

    /**
     * FIN NOTIFICATIONS
     */


    /**
     * SUPPRESSIONS
     */


    $individuASupprimer = $getIndividuParDelais($delaiSuppr, false);

    $GLOBALS['log']->error(print_r("## Traitement des suppressions",true));
    
    if(!empty($modeleDeMailSuppression)){
        while($row = $db->fetchByAssoc($individuASupprimer)){
            $actionSupprimer($row['id']);
        }
    }
    else $GLOBALS['log']->error(print_r("# La suppression des usager n'a pas pu être réalisé : aucun modèle de mail de notification n'a été paramétré",true));

    /**
     * FIN SUPPRESSIONS
     */


    $GLOBALS['log']->error(print_r("## Fin traitement des suppressions",true));
    $GLOBALS['log']->error(print_r("## FIN DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));
    return true;
}
