<?php
namespace Custom_ODE_API\Controller;

use ODE_API\V8\Controller\BaseController;

use Custom_ODE_API\Service\OpenSubService;
use Custom_ODE_API\Param\DemandesPaiementParams;
use Custom_ODE_API\Param\DossierInfosParams;
use Custom_ODE_API\Param\DossiersParams;

use Exception;
use Slim\Http\Request;
use Slim\Http\Response;

class OpenSubController extends BaseController
{
    /**
     * @var OpenSubService
     */
    private $OpenSubService;

    /**
     * @param OpenSubService $OpenSubService
     */
    public function __construct(OpenSubService $OpenSubService)
    {
        $this->OpenSubService = $OpenSubService;
    }

    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param getDemandesPaiement $params
     *
     * @return Response
     */
    public function getDemandesPaiement(Request $request, Response $response, array $args, DemandesPaiementParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenSubService->getDemandesPaiement($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierGetParams $params
     *
     * @return Response
     */
    public function getDossierInfos(Request $request, Response $response, array $args, DossierInfosParams $params): Response
    {
        try {
            $jsonResponse = $this->OpenSubService->getDossierInfos($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
    
    /**
     * @param Request $request
     * @param Response $response
     * @param array $args
     * @param DossierSetParams $params
     *
     * @return Response
     */
    public function creationDossierPaiement(Request $request, Response $response, array $args, DossiersParams $params)
    {
        try {
            $jsonResponse = $this->OpenSubService->creationDossierPaiement($params, $request);
            return $this->generateResponse($response, $jsonResponse, 200);
        } catch (\Exception $exception) {
            return $this->generateErrorResponse($response, $exception, $exception->getCode());
        }
    }
}
