<?php 

namespace ODE\ActionLot\Action;

if (!defined('sugarEntry')) define('sugarEntry', true);

use ODE\Modal\OdeModal;

Class ModifierReunionAction {

    /**
     * @access public
     * @name getAction()
     * Fonction qui retourne l'action " Modifier réunion "
     * 
     *  @return array       - $action
    */
    public function getAction() {

        return array(
            'module_name' => 'OPS_dossier',
            'action_content' => $this->getActionContent(),
            'action_link' => $this->getActionLink(),
        );

    }

    /**
     * @access public
     * @name getActionOrdre()
     * Fonction qui retourne l'ordre de l'action
     * 
     *  @return array       - $action_ordre
    */
    public function getActionOrdre() {
        return 3;
    }

    /**
     * @access private
     * @name getActionContent()
     * Fonction qui retourne le content de l'action
     * 
     *  @return array       - $action_content
    */
    private function getActionContent() {
        return $this->getActionLink() . $this->getActionHTML();
    }

    /**
     * @access private
     * @name getActionLink()
     * Fonction qui retourne le link de l'action
     * 
     *  @return array       - $action_link
    */
    private function getActionLink() {
        return '<a role="ode-modal-reunion-btn" >Modifier la réunion</a>';
    }
   
    /**
     * @access private
     * @name getActionHTML()
     * Fonction qui retourne l'html de l'action
     * 
     *  @return array       - $action_html
    */
    private function getActionHTML() {
        $modal = new OdeModal('ode_modal_reunion');
        $modal->setTitle('MODIFIER LA REUNION');
        $modal->setCss(['modules/OPS_reunion/css/modifier_reunion.css']);
        $modal->setJS(['modules/OPS_reunion/js/modifier_reunion.js']);
        $modal->setPages(['modules/OPS_reunion/tpls/modifier_reunion.tpl']);
        return $modal->getHtml();
    }

}