<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AffecterSecteurAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Affecter un secteur à un dossier "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'secteur_geographique';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Affecter un secteur à un dossier "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Affecter un secteur à un dossier";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Affecter un secteur à un dossier "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Affecter un secteur à un dossier";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        // EXT 1 = TYPE DE TERRITOIRE
        $objTypeTerritoire = BeanFactory::newbean('OPS_type_territoire');
        $listTypeTerritoire = $objTypeTerritoire->get_full_list(
                                'name'
                            );

        $tabTypeTerritoire = array('' =>  '- aucun -') ;
        foreach ($listTypeTerritoire as $id => $type) 
        {
            if(!empty($type->name))
            {
                $tabTypeTerritoire[$type->id] = $type->name;
            }
        }

        $typeTerritoireListe = get_select_options_with_id($tabTypeTerritoire, $this->action->ext_valeur_1);

        // EXT 2 = CHAMPS ADRESSE
        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list(
                                'libelle'
                            );

        $tabReferentiel = array( '' =>  '- aucun -') ;
        foreach ($listReferentiel as $id => $ref) {
            if( !empty($ref->name) ){
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $referentielListe = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_2);
        
        
        // EXT 3 = LISTE SOUS TERRITOIRE
        $optionSecteurGeographique = '<option value=""></option>';
        foreach ($listTypeTerritoire as $objTypeTerritoire) 
        {
            $territoires = $objTypeTerritoire->get_linked_beans('ops_territoire_ops_type_territoire', 'OPS_territoire', 'name');
            foreach($territoires as $objTerritoire)
            {
                $sousTerritoires = $objTerritoire->get_linked_beans('ops_sous_territoire_ops_territoire', 'OPS_sous_territoire', 'name');
                foreach($sousTerritoires as $objSousTerritoire)
                {
                    $selected = (!empty($this->action->ext_valeur_3) && $this->action->ext_valeur_3 == $objSousTerritoire->id) ? 'selected=selected' : '';
                    $optionSecteurGeographique .= '<option value="' . $objSousTerritoire->id . '" ' . $selected . ' rel="' . $objTypeTerritoire->id . '">' . $objSousTerritoire->name . '</option> '; 
                }
            }
        }
        
        // EXT 4 = IF ADRESSE PROFIL
        $champRadio = '';
        $radioList = ['yes' => 'Oui', 'no' => 'Non'];
        foreach( $radioList as $key => $value ){
            if($key == $this->action->ext_valeur_4 || ( empty($this->action->ext_valeur_4) && $key == 'champs_standards' ) ){
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_4" value="'.$key.'" checked style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }else{
                $champRadio .=  '<input type="radio" id="'.$key.'" name="ext_valeur_4" value="'.$key.'" style="margin-left: 6px;">
                                <label for="'.$key.'">'.$value.'</label>';
            }
        }

        $sourceValeurJson = '';
        $valeurChamptJson = '';

        if(!empty($this->action->ext_valeur_text)){
            $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
            $sourceValeurJson = $extValeurText['source_valeur'];
            $valeurChamptJson = $extValeurText['valeur_champ'];
        }


        //CHAMPS SOURCE
        $referentielListeSource = get_select_options_with_id($tabReferentiel, $sourceValeurJson);

        $selectSource = '<select name="select_source_valeur" id="select_source_valeur" style="width: 75%;">' . $referentielListeSource . '</select>';
        $selectSource = base64_encode($selectSource);

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Type de territoire';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">' . $typeTerritoireListe . '</select>';

        $data['ext_valeur_2']['type']  = 'enum';
        $data['ext_valeur_2']['label'] = 'Adresse du dossier';
        $data['ext_valeur_2']['form']  = '<select name="ext_valeur_2" id="ext_valeur_2" style="width: 75%;">' . $referentielListe . '</select>';

        $data['ext_valeur_3']['type']  = 'enum';
        $data['ext_valeur_3']['label'] = 'Secteur par défaut';
        $data['ext_valeur_3']['form']  = '<select name="ext_valeur_3" id="ext_valeur_3" style="width: 75%;">' . $optionSecteurGeographique . '</select>';
        
        $data['ext_valeur_4']['type']  = 'radio';
        $data['ext_valeur_4']['label'] = 'Adresse du profil';
        $data['ext_valeur_4']['form']  = $champRadio;

        $extValeurText = $this->action->ext_valeur_text;

        $data['hidden'] = "<input type='hidden' id='ext_valeur_text' name='ext_valeur_text' value='$extValeurText'>
        <input type='hidden' id='select_source' name='select_source' value='$selectSource'>
        <input type='hidden' id='valeur_champ' name='valeur_champ' value='$valeurChamptJson'>";

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        // EXT 1 - TYPE DE TERRITOIRE
        $objTypeTerritoire = (!empty($this->action->ext_valeur_1)) ? BeanFactory::getBean('OPS_type_territoire', $this->action->ext_valeur_1) : null;
        $typeTerritoireName = ($objTypeTerritoire !== null && !empty($objTypeTerritoire->name)) ? $objTypeTerritoire->name : "";

        // EXT 2 - CHAMP ADRESSE
        $objReferentiel = (!empty($this->action->ext_valeur_2)) ? BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_2) : null;
        $referentielName = ($objReferentiel !== null && !empty($objReferentiel->libelle)) ? $objReferentiel->libelle : "";

        // EXT 3 - SOUS TERRITOIRE PAR DEFAUT
        $objSousTerritoire = (!empty($this->action->ext_valeur_3)) ? BeanFactory::getBean('OPS_sous_territoire', $this->action->ext_valeur_3) : null;
        $sousTerritoireName = ($objSousTerritoire !== null && !empty($objSousTerritoire->name)) ? $objSousTerritoire->name : "";
        
        // EXT 4 - ADRESSE DU PROFIL
        $radioList = ['yes' => 'Oui', 'no' => 'Non'];
        $adresseProfil = (!empty($this->action->ext_valeur_4) && array_key_exists($this->action->ext_valeur_4, $radioList)) ? $radioList[$this->action->ext_valeur_4] : "";

        $sourceValeurJson = '';
        $valeurChamptJson = '';

        if(!empty($this->action->ext_valeur_text)){
            $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
            $sourceValeurJson = $extValeurText['source_valeur'];
            $valeurChamptJson = $extValeurText['valeur_champ'];
        }

        //CHAMP SOURCE
        $objReferentielSource = (!empty($sourceValeurJson)) ? BeanFactory::getBean('OPS_generateur_referentiel', $sourceValeurJson) : null;
        $referentielNameSource = ($objReferentielSource !== null && !empty($objReferentielSource->libelle)) ? $objReferentielSource->libelle : "";

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Type de territoire';
        $data['ext_valeur_1']['valeur']  = $typeTerritoireName;

        $data['ext_valeur_2']['type']  = 'text';
        $data['ext_valeur_2']['label'] = 'Adresse du dossier';
        $data['ext_valeur_2']['valeur']  = $referentielName;

        $data['ext_valeur_3']['type']  = 'text';
        $data['ext_valeur_3']['label'] = 'Secteur par défaut';
        $data['ext_valeur_3']['valeur']  = $sousTerritoireName;

        $data['ext_valeur_4']['type']  = 'text';
        $data['ext_valeur_4']['label'] = 'Adresse du profil';
        $data['ext_valeur_4']['valeur']  = $adresseProfil;

        $data['hidden'] = "<script type='text/javascript' charset='UTF-8' src='custom/include/Ode/ActionStatut/Js/AffecterSecteurAction.js'></script>
        <input type='hidden' id='select_source' name='select_source' value='$referentielNameSource'>
        <input type='hidden' id='valeur_champ' name='valeur_champ' value='$valeurChamptJson'>
        <script type='text/javascript'>AffecterSecteurAction.start();</script>";

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        global $db;

        if(!empty($this->dossier))
        {
            $objSousTerritoire = BeanFactory::newBean('OPS_sous_territoire');

            // INITIALISATION DU TYPE DE TERRITOIRE (EXT1)
            if(!empty($this->action->ext_valeur_1))
            {
                $objTypeTerritoire = BeanFactory::getBean('OPS_type_territoire', $this->action->ext_valeur_1);
                if(empty($objTypeTerritoire->id))
                {
                    $GLOBALS['log']->fatal('AffecterSecteurAction::execute => Le type de territoire est invalide');
                }
            }

            $extValeurText = array();
            $sourceValeurJson = '';
            $valeurChamptJson = '';
            $execute = true;

            if(!empty($this->action->ext_valeur_text) && json_decode(base64_decode($this->action->ext_valeur_text)) !== null){
                $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
                $sourceValeurJson = $extValeurText['source_valeur'];
                $valeurChamptJson = $extValeurText['valeur_champ']; 

                //Vérification si on a une condition de champ pour le changement de statut
                if(!empty($sourceValeurJson) && !empty($valeurChamptJson)){
                    $objReferentiel =  BeanFactory::getBean('OPS_generateur_referentiel', $sourceValeurJson );
                    if(!empty($objReferentiel)){
                        $referentielName = $objReferentiel->name;
                        $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                        if($objReferentiel->description == 'custom'){
                            $champVerif = $customChamp->{$referentielName};
                        }else{
                            $champVerif = $this->dossier->{$referentielName};
                        }

                        $champValeur = strtolower(trim($valeurChamptJson));
                        $champVerif = strtolower(trim($champVerif));

                        $motif = '/\^' . preg_quote($champValeur, '/') . '\^/';

                        //Si on a une liste multiple
                        if($objReferentiel->type == 'liste'){
                            $params = json_decode( base64_decode($objReferentiel->params),true);
                        }

                        //Check différent si on est dans les = valeur multiple
                        if($objReferentiel->type == "checkboxmulti" || (isset($params) && $params['multiple'] == 1)){
                            $execute = (preg_match($motif, $champVerif))?true:false;
                        }else{
                            $execute = ($champValeur == $champVerif)?true:false;
                        }
                    }
                }
            }

            if($execute){
                // CHAMP ADRESSE (EXT2)
                if(!empty($this->action->ext_valeur_2))
                {
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $this->action->ext_valeur_2);
                    if(!empty($objReferentiel->id))
                    {
                        if($objReferentiel->description == 'basic')
                        {
                            $value = $this->dossier->{$objReferentiel->name};
                        }
                        else if ($objReferentiel->description == 'custom')
                        {
                            $customChamp = json_decode(base64_decode($this->dossier->champs_custom));
                            $value = $customChamp->{$objReferentiel->name};
                        }
                        else
                        {
                            $GLOBALS['log']->fatal('AffecterSecteurAction::execute => La description du champ référentiel n\'est pas pris en compte');
                        }

                        if(!empty($value))
                        {
                            $value = str_replace('&#x3D;', '=', $value); // Le champ adresse peut parfois être mal encodé 
                            // Vérifie si la valeur est encodé en base 64
                            if (base64_encode(base64_decode($value, true)) === $value)
                            {
                                $value = json_decode(base64_decode($value));
                                
                                $objSousTerritoire = $this->getSousTerritoire($objTypeTerritoire->id, $value->numero, $value->rue, $value->postcode, $value->city);
                            }
                            else
                            {
                                $GLOBALS['log']->fatal('AffecterSecteurAction::execute => Le champ "' . $objReferentiel->libelle . ' (' . $objReferentiel->name . ')" n\'est pas encodé');
                            }
                        }
                    }
                }

                // ADRESSE PROFIL (EXT4)
                if(empty($objSousTerritoire->id) && !empty($this->action->ext_valeur_4) && !empty($objTypeTerritoire->id))
                {
                    if($this->action->ext_valeur_4 == 'yes')
                    {
                        if(!empty($this->dossier->ops_personne_morale))
                        {
                            $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale', $this->dossier->ops_personne_morale);
                            if(!empty($objPersonneMorale->id))
                            {
                                $objSousTerritoire = $this->getSousTerritoire($objTypeTerritoire->id, $objPersonneMorale->billing_address_number, $objPersonneMorale->billing_address_street, $objPersonneMorale->billing_address_postalcode, $objPersonneMorale->billing_address_city);
                            }
                        }
                    }
                }
                // ADRESSE PAR DEFAUT (EXT3)
                if(empty($objSousTerritoire->id) && !empty($this->action->ext_valeur_3) && !empty($objTypeTerritoire->id))
                {
                    $objSousTerritoire = $this->getSousTerritoireDefaut($objTypeTerritoire->id, $this->action->ext_valeur_3);
                }   
            }

            if(!empty($objSousTerritoire->id))
            {
                $sousTerritoires = $this->dossier->get_linked_beans('ops_sous_territoire_ops_dossier', 'OPS_sous_territoire', 'name', 0, -1, 0, 'ops_sous_territoire.id = "' . $objSousTerritoire->id . '"');
                
                if(count($sousTerritoires) == 0)
                {
                    $this->dossier->load_relationship('ops_sous_territoire_ops_dossier');
                    $this->dossier->ops_sous_territoire_ops_dossier->add($objSousTerritoire);
                }
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "AffecterSecteurAction";
    }

    public function getSousTerritoire($type_territoire_id, $adresse_numero, $adresse_rue, $adresse_code_postal, $adresse_ville)
    {
        global $db;

        $objSousTerritoire = BeanFactory::newBean('OPS_sous_territoire');
        
        if(!empty($type_territoire_id))
        {
            $search_order = [
                'code_postal' => $adresse_code_postal, 
                'name' => $adresse_ville, 
                'rue' => $adresse_rue, 
            ];

            foreach ($search_order as $contexte => $value)
            {
                $query = $this->build_query($type_territoire_id, $contexte, $value);
    
                $requete = $db->query($query);
    
                $sousTerritoireListe = [];
                while ($row = $db->fetchRow($requete)) 
                {
                    $sousTerritoireListe[] = [
                        'id'           => $row['id'],
                        'name'         => $row['name'],
                        'rue'          => $row['rue'],
                        'numero_debut' => $row['numero_debut'],
                        'numero_fin'   => $row['numero_fin'],
                        'code_postal'  => $row['code_postal'],
                    ];
                }
    
                if(count($sousTerritoireListe) > 0)
                {
                    if(count($sousTerritoireListe) == 1)
                    {
                        $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire', $sousTerritoireListe[0]['id']);
                        break;
                    }
                    else
                    {
                        $sousTerritoireListe = $this->affiner_recherche($sousTerritoireListe, $adresse_numero, $adresse_rue, $adresse_code_postal, $adresse_ville);
                        
                        if($sousTerritoireListe != false && count($sousTerritoireListe) == 1)
                        {
                            $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire', reset($sousTerritoireListe)['id']);
                            break;
                        }
                    }
                }
            }
        }
        else
        {
            $GLOBALS['log']->fatal('AffecterSecteurAction::execute => Le type de territoire n\'est pas initialisé');
        }

        return (isset($objSousTerritoire) && !empty($objSousTerritoire->id) ? $objSousTerritoire : false);
    }

    private function affiner_recherche($sousTerritoireListe, $numero, $rue, $code_postal, $ville)
    {
        $search_order = [
            'code_postal' => $code_postal, 
            'name' => $ville, 
            'rue' => $rue, 
            'numero' => $numero,
        ];

        foreach ($search_order as $contexte => $value)
        {
            if($contexte != 'numero')
            {
                $sousTerritoireListe = array_filter($sousTerritoireListe, function($sousTerritoire) use($contexte, $value) {
                    return $this->filtrerPar($sousTerritoire, $contexte, $value);
                });
            }
            else
            {
                $sousTerritoireListe = array_filter($sousTerritoireListe, function($sousTerritoire) use($value) {
                    return $this->filtrerParNumero($sousTerritoire, $value);
                });
            }

            if(sizeof($sousTerritoireListe) > 0)
            {
                if(sizeof($sousTerritoireListe) == 1)
                {
                    return $sousTerritoireListe;
                }
            }
            else
            {
                return false;
            }
        }

        return $sousTerritoireListe;
    }

    private function filtrerPar($field, $contexte, $contexte_value) 
    {
        return strtolower(trim($field[$contexte])) === strtolower(trim($contexte_value));
    }

    private function filtrerParNumero($field, $numero) 
    {
        if(!empty($field['numero_debut']) && !empty($field['numero_fin']))
        {
            return ($field['numero_debut'] <= $numero && $numero <= $field['numero_fin']);
        }
        else if (!empty($field['numero_debut']))
        {
            return ($field['numero_debut'] <= $numero);
        }
        else if (!empty($field['numero_fin']))
        {
            return ($field['numero_fin'] >= $numero);
        }
        else
        {
            return true;
        }
    }

    private function build_query($type_territoire_id, $contexte, $contexte_value)
    {

        $query = 'SELECT id FROM ops_sous_territoire WHERE 0';
        if(!empty($type_territoire_id) && !empty($contexte) && !empty($contexte_value))
        {
            $query = 'SELECT ops_sous_territoire.id, ops_sous_territoire.name, ops_sous_territoire.rue, ops_sous_territoire.code_postal, ops_sous_territoire.numero_debut, ops_sous_territoire.numero_fin
                    FROM ops_sous_territoire
                    INNER JOIN ops_sous_territoire_ops_territoire ON ops_sous_territoire_ops_territoire.ops_sous_territoire_id = ops_sous_territoire.id AND ops_sous_territoire_ops_territoire.deleted = 0
                    INNER JOIN ops_territoire ON ops_territoire.id = ops_sous_territoire_ops_territoire.ops_territoire_id AND ops_territoire.deleted = 0
                    INNER JOIN ops_territoire_ops_type_territoire ON ops_territoire_ops_type_territoire.ops_territoire_id = ops_territoire.id AND ops_territoire_ops_type_territoire.deleted = 0
                    INNER JOIN ops_type_territoire ON ops_territoire_ops_type_territoire.ops_type_territoire_id = ops_type_territoire.id AND ops_type_territoire.deleted = 0
                    WHERE ops_sous_territoire.deleted = 0 AND ops_type_territoire.id = "' . $type_territoire_id . '" AND ops_sous_territoire.' . $contexte . ' = "' . $contexte_value . '"';
        }
        
        return $query;
    }

    public function getSousTerritoireDefaut($typeTerritoireId, $sousTerritoireId)
    {
        global $db;

        if(!empty($typeTerritoireId))
        {
            $query = 'SELECT ops_sous_territoire.id
                        FROM ops_sous_territoire
                        INNER JOIN ops_sous_territoire_ops_territoire ON ops_sous_territoire_ops_territoire.ops_sous_territoire_id = ops_sous_territoire.id AND ops_sous_territoire_ops_territoire.deleted = 0
                        INNER JOIN ops_territoire ON ops_territoire.id = ops_sous_territoire_ops_territoire.ops_territoire_id AND ops_territoire.deleted = 0
                        INNER JOIN ops_territoire_ops_type_territoire ON ops_territoire_ops_type_territoire.ops_territoire_id = ops_territoire.id AND ops_territoire_ops_type_territoire.deleted = 0
                        INNER JOIN ops_type_territoire ON ops_territoire_ops_type_territoire.ops_type_territoire_id = ops_type_territoire.id AND ops_type_territoire.deleted = 0
                        WHERE ops_type_territoire.id = "' . $typeTerritoireId . '" AND ops_sous_territoire.id = "' . $sousTerritoireId . '"
                        LIMIT 1';

            $requete = $db->query($query);

            while ($row = $db->fetchRow($requete)) 
            {
                $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire', $row['id']);
            }
        }
        else
        {
            $GLOBALS['log']->fatal('AffecterSecteurAction::execute => Le type de territoire n\'est pas initialisé');
        }

        return (isset($objSousTerritoire) && !empty($objSousTerritoire->id) ? $objSousTerritoire : false);
    }
}