<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AssignerDossierThematiqueAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Assigner le dossier en fonction d'une thématique "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Assigner le dossier en fonction d'une thématique "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Assigner le dossier en fonction d'une thématique";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Assigner le dossier en fonction d'une thématique "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Assigner le dossier en fonction d'une thématique";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $liste_agent = $this->get_select_agent_by_profil();

        $liste_thematique  = $app_list_strings['ops_thematique_list'];
        unset($liste_thematique[""]);
        ksort($liste_thematique);
        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_agent)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_thematique)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des agents selon la thématique';
        $data['ext_valeur_1']['type'] = 'enum';

        //$listName = $this->action->ext_valeur_1;
        $listName = 'ops_thematique_list';

        $tabThematiqueUsers = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabThematiqueUsers as $thematiqueUser){
            if("" != str_replace(" ","",$thematiqueUser)){

                $tabThematiqueUser = explode(";",$thematiqueUser);
                $nomThematique = $tabThematiqueUser[0];
                $idUser = $tabThematiqueUser[1];

                if("" != str_replace(" ","", $nomThematique)){
                    if("" != $app_list_strings[$listName][$nomThematique]){
                        $choix='true';
                        $user = BeanFactory::getBean('Users', $idUser);
                        $nomAgent = $user->name;
                        $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:70%;' >" . $app_list_strings[$listName][$nomThematique] . " : </span> <span style ='float:right;'>" . $nomAgent . "</span></p><br>";
                    }
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text)){

            $thematiqueDossier = $this->dossier->thematique;
            $lesThematique = explode("|",$this->action->ext_valeur_text);
            $tabThematique = array();

            foreach ($lesThematique as $key => $value){
                $uneThematique = explode(";", $value);
                $nomThematique = $uneThematique[0];
                $idUser = $uneThematique[1];
                $tabThematique[$nomThematique] = $idUser;
            }

            if(isset($tabThematique[$thematiqueDossier]) && !empty($tabThematique[$thematiqueDossier])){
                $this->dossier->assigned_user_id = $tabThematique[$thematiqueDossier];
                $this->dossier->save(true);
            }else{
                $GLOBALS['log']->fatal("AssignerDossierThematique => La thematique n'est pas paramétré dans action statut ");
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "AssignerDossierThematiqueAction";
    }


    private function get_select_agent_by_profil(){

        global $beanFiles;

        $obj_users = BeanFactory::getBean('Users'); 
        $liste_users = $obj_users->get_full_list();

        $tab_profils_users = array() ; 

        foreach ($liste_users as $key => $users) {

            // On récupère les profils  de l'utilisateur
            $users->load_relationship('SecurityGroups');
            $securitygroups_ids = $users->SecurityGroups->get();
            
            if (!empty($securitygroups_ids)) {

                foreach ($securitygroups_ids as $key => $value) {

                    $securitygroup_bean = BeanFactory::getBean('SecurityGroups',$value);
                    $tab_profils_users[$securitygroup_bean->name][$users->name] = $users->id ; 

                }
            }
            else{
                $tab_profils_users["Sans profil métier"][$users->name] = $users->id ; 

            }

        }

        foreach ($tab_profils_users as $key => $value) {
            ksort($tab_profils_users[$key]);
        }

        ksort( $tab_profils_users );

        return $tab_profils_users;
    }
}
