<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DemanderJustificatifAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Demander un justificatif "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'justificatif';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Demander un justificatif "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Demander un justificatif";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Demander un justificatif "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Demander un justificatif";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $typeDocumentTab = get_bean_select_array(true, 'OPS_type_document', "name", '', "name");
        $typeDocumentList = get_select_options_with_id($typeDocumentTab,$this->action->ext_valeur_1);

        $checked_val_2 = '';
        if($this->action->ext_valeur_2 == 'on' ){
            $checked_val_2 = 'checked';
        }

        $data['ext_valeur_1']['label'] = 'Type';
        $data['ext_valeur_1']['type'] = 'enum';
        $data['ext_valeur_1']['form'] = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">'.$typeDocumentList.'</select>';

        $data['ext_valeur_2']['label'] = 'Obligatoire';
        $data['ext_valeur_2']['type'] = 'bool';
        $data['ext_valeur_2']['form'] = '<input type="hidden"  name="ext_valeur_2" value = "off" >';
        $data['ext_valeur_2']['form'] .= '<input type="checkbox" class="checkbox" value = "on" name="ext_valeur_2" id="ext_valeur_2" '.$checked_val_2.' >';

        $data['ext_valeur_3']['label'] = 'Commentaire';
        $data['ext_valeur_3']['type'] = 'text';
        $data['ext_valeur_3']['form'] = '<textarea id="ext_valeur_3" name="ext_valeur_3" rows="6" cols="80" title="" tabindex="0" style="width: 90%;">'.$this->action->ext_valeur_3.'</textarea>';

        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $checked_val_4 = '';
            if ($this->action->ext_valeur_4 == 'on') {
                $checked_val_4 = 'checked';
            }
            $data['ext_valeur_4']['label'] = 'Visible usager';
            $data['ext_valeur_4']['type'] = 'text';
            $data['ext_valeur_4']['form'] = '<input type="hidden"  name="ext_valeur_4" value = "off" >';
            $data['ext_valeur_4']['form'] .= '<input type="checkbox" class="checkbox" value = "on" name="ext_valeur_4" id="ext_valeur_4" ' . $checked_val_4 . ' >';

            $checked_val_5 = '';
            if ($this->action->ext_valeur_5 == 'on') {
                $checked_val_5 = 'checked';
            }
            $data['ext_valeur_5']['label'] = 'Visible partenaire';
            $data['ext_valeur_5']['type'] = 'bool';
            $data['ext_valeur_5']['form'] = '<input type="hidden"  name="ext_valeur_5" value = "off" >';
            $data['ext_valeur_5']['form'] .= '<input type="checkbox" class="checkbox" value = "on" name="ext_valeur_5" id="ext_valeur_5" ' . $checked_val_5 . ' >';

            $listeCibleOptions = get_select_options_with_id($app_list_strings['ops_partenaires_destinataires_list'], $this->action->ext_valeur_6);
            $data['ext_valeur_6']['label'] = 'Partenaires';
            $data['ext_valeur_6']['type'] = 'text';
            $data['ext_valeur_6']['form'] = '<select name="ext_valeur_6" id="ext_valeur_6" style="width: 75%;">' . $listeCibleOptions . '</select>';
        }

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings;

        $data = [];
        $valeurTypeDocument = '';

        if(!empty($this->action->ext_valeur_1)){
            $objTypeDocument = BeanFactory::getBean('OPS_type_document',$this->action->ext_valeur_1);
            if(!empty($objTypeDocument->name)){
                $valeurTypeDocument = $objTypeDocument->name;
            }
        }

        $checked_val_2 = '';
        if($this->action->ext_valeur_2 == 1 || $this->action->ext_valeur_2 == 'on'){
            $checked_val_2 = 'checked';
        }

        $data['ext_valeur_1']['label'] = 'Type';
        $data['ext_valeur_1']['type'] = 'enum';
        $data['ext_valeur_1']['valeur']  = $valeurTypeDocument;

        $data['ext_valeur_2']['label'] = 'Obligatoire';
        $data['ext_valeur_2']['type'] = 'bool';
        $data['ext_valeur_2']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_2" id="ext_valeur_2" disabled '.$checked_val_2.' >';

        $data['ext_valeur_3']['label'] = 'Commentaire';
        $data['ext_valeur_3']['type'] = 'text';
        $data['ext_valeur_3']['valeur'] = $this->action->ext_valeur_3;

        if (isset($app_list_strings['moduleList']['OPS_avis'])) {
            $checked_val_4 = '';
            if ($this->action->ext_valeur_4 == 'on') {
                $checked_val_4 = 'checked';
            }
            $data['ext_valeur_4']['label'] = 'Visible internet';
            $data['ext_valeur_4']['type'] = 'bool';
            $data['ext_valeur_4']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_5" id="ext_valeur_5" disabled ' . $checked_val_4 . ' >';

            $checked_val_5 = '';
            if ($this->action->ext_valeur_5 == 'on') {
                $checked_val_5 = 'checked';
            }
            $data['ext_valeur_5']['label'] = 'Visible partenaire';
            $data['ext_valeur_5']['type'] = 'bool';
            $data['ext_valeur_5']['valeur'] = '<input type="checkbox" class="checkbox" name="ext_valeur_5" id="ext_valeur_5" disabled ' . $checked_val_5 . ' >';

            $data['ext_valeur_6']['label'] = 'Partenaires';
            $data['ext_valeur_6']['type'] = 'text';
            $data['ext_valeur_6']['valeur'] = $app_list_strings['ops_partenaires_destinataires_list'][$this->action->ext_valeur_6];
        }

        $data['hidden'] = "<script type='text/javascript' charset='UTF-8' src='custom/include/Ode/ActionStatut/Js/DemanderJustificatifAction.js'></script>
        <script type='text/javascript'>DemanderJustificatifAction.start();</script>";

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        global $app_list_strings;
        if(!empty($this->dossier)){

            $objJustificatif = BeanFactory::newBean('OPS_justificatif');
            $objJustificatif->obligatoire = $this->action->ext_valeur_2;
            $objJustificatif->depot = 'complementaire';
            $objJustificatif->statut = 'non_fourni';
            if (isset($app_list_strings['moduleList']['OPS_avis'])) {
                $objJustificatif->visible_internet = $this->action->ext_valeur_4;
                $objJustificatif->visible_partenaire = $this->action->ext_valeur_5;
                $objJustificatif->type_partenaire = $this->action->ext_valeur_6;
            }
            $objJustificatif->description = $this->action->ext_valeur_3;
            $objJustificatif->save();

            $objJustificatif->load_relationship('ops_type_documet_ops_justificatif');
            $objJustificatif->ops_type_document_ops_justificatif->add($this->action->ext_valeur_1);

            $objJustificatif->load_relationship('ops_dossier_ops_justificatif');
            $objJustificatif->ops_dossier_ops_justificatif->add($this->dossier->id);
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "DemanderJustificatifAction";
    }
}
