<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierAdresseDomiciliationAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier adresse de domiciliation "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'profil';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier adresse de domiciliation "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier adresse de domiciliation";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier adresse de domiciliation "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier adresse de domiciliation";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list('libelle');

        $tabReferentiel = array( '' =>  '- aucun -') ;

        foreach ($listReferentiel as $id => $ref) 
        {
            if(!empty($ref->name))
            {
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        $liste_referentiel = get_select_options_with_id($tabReferentiel, $this->action->ext_valeur_3);

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text))
        {
            $objPersonneMorale = BeanFactory::getBean('OPS_personne_morale',$this->dossier->ops_personne_morale);

            if(!empty($objPersonneMorale->id))
            {
                $listeChamps = explode('|',$this->action->ext_valeur_text);
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );
                $objHistoriqueAdresse = BeanFactory::newBean('OPS_historique_adresse');

                $objHistoriqueAdresse->type_adresse = 'domiciliation';

                $adresse_champs = [
                    'billing_address_number'                 => 'billing_address_number', 
                    'billing_address_street'                 => 'billing_address_street', 
                    'billing_address_street_1'      => 'billing_address_complement', 
                    'billing_address_street_2' => 'billing_address_complement_lieu', 
                    'billing_address_city'                   => 'billing_address_city', 
                    'billing_address_postalcode'             => 'billing_address_postalcode', 
                    'adresse_date_validite'                  => 'adresse_date_validite',
                ];

                foreach($adresse_champs as $adresse_champ => $correspondance)
                {
                    $objHistoriqueAdresse->{$adresse_champ} = $objPersonneMorale->{$correspondance};
                }

                foreach ($listeChamps as $champs) 
                {
                    $value = '';
                    $champ = explode(';', $champs);
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                    if(!empty($this->dossier->{$objReferentiel->name}))
                    {
                        $value = $this->dossier->{$objReferentiel->name};
                    }
                    else
                    {
                        $value = $customChamp->{$objReferentiel->name};
                    }

                    if($champ[0] == 'adresse')
                    {
                        $value = html_entity_decode($value,ENT_NOQUOTES);

                        // Vérifie si la valeur est encodé en base 64
                        if (!empty($value) && base64_encode(base64_decode($value, true)) === $value)
                        {
                            $value = json_decode(base64_decode($value));
                            
                            $objPersonneMorale->billing_address_number          = $value->numero;
                            $objPersonneMorale->billing_address_street          = $value->rue;
                            $objPersonneMorale->billing_address_complement      = $value->complement_batiment;
                            $objPersonneMorale->billing_address_complement_lieu = $value->complement_lieu;
                            $objPersonneMorale->billing_address_postalcode      = $value->postcode;
                            $objPersonneMorale->billing_address_city            = $value->city;
                            $objPersonneMorale->billing_coordonnees_x           = $value->coordonnees_x;
                            $objPersonneMorale->billing_coordonnees_y           = $value->coordonnees_y;
                        }
                        else if (empty($value))
                        {
                            $objPersonneMorale->billing_address_number          = '';
                            $objPersonneMorale->billing_address_street          = '';
                            $objPersonneMorale->billing_address_complement      = '';
                            $objPersonneMorale->billing_address_complement_lieu = '';
                            $objPersonneMorale->billing_address_postalcode      = '';
                            $objPersonneMorale->billing_address_city            = '';
                            $objPersonneMorale->billing_coordonnees_x           = '';
                            $objPersonneMorale->billing_coordonnees_y           = '';
                        }
                    }
                    else
                    {
                        $objPersonneMorale->{$champ[0]} = $value;
                    }
                }

                if(empty($objPersonneMorale->adresse_date_validite))
                {
                    $objPersonneMorale->adresse_date_validite = date("Y-m-d");
                }

                $objPersonneMorale->save();

                $objHistoriqueAdresse->date_fin_validite = date('Y-m-d', strtotime('-1 day', strtotime($objPersonneMorale->adresse_date_validite)));
                $objHistoriqueAdresse->ops_personne_morale_id = $this->dossier->ops_personne_morale;

                $objHistoriqueAdresse->save();
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierAdresseDomiciliationAction";
    }

    private function getChamps(){
        return array(
            'adresse' => 'Adresse',
            'adresse_date_validite' => 'Adresse valide à partir de',
        );
    }
}