<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierMedecinAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Profil : modifier un médecin";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier un médecin";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     *
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        global $app_list_strings;

        $data = [];

        $liste_referentiel = get_bean_select_array(false, 'OPS_generateur_referentiel',"libelle", "",'libelle');

        $liste_champ  = $this->getChamps();

        $data['hidden'] = " <input type='hidden'  id='ext_valeur_5' name='ext_valeur_5' value=".base64_encode(json_encode($liste_referentiel)).">
                            <input type='hidden'  id='ext_valeur_3' name='ext_valeur_3' value=".base64_encode(json_encode($liste_champ)).">
                            <input type='hidden'  id='ext_valeur_text' name='ext_valeur_text' value=".$this->action->ext_valeur_text.">";
   
        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     *
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        global $app_list_strings, $beanFiles;
        require_once($beanFiles['User']);

        $data = [];

        $data['ext_valeur_1']['label'] = 'Nom des champs';
        $data['ext_valeur_1']['type'] = 'enum';

        $liste_champ = $this->getChamps();

        $tabReferentielChamps = explode("|", $this->action->ext_valeur_text);

        $choix = 'false';
        foreach($tabReferentielChamps as $ReferentielChamp){
            if("" != str_replace(" ","",$ReferentielChamp)){

                $tabReferentielChamp = explode(";",$ReferentielChamp);
                $nomChamp = $tabReferentielChamp[0];
                $champRefetentiel = $tabReferentielChamp[1];

                if("" != str_replace(" ","", $nomChamp)){
                    $choix='true';
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel',$champRefetentiel);
                    $data['ext_valeur_1']['valeur'] .= "<p><span style='float:left;width:50%;' >" . $liste_champ[$nomChamp] . " : </span> <span style ='float:right;'>" . $objReferentiel->libelle . "</span></p><br>";
                }
            }
        }
        if($choix == 'false'){
            $data['ext_valeur_1']['valeur'] = "<p><span style='float:left;width:70%;' > Aucune assignation n'a été faite </span></p><br>";
        }

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     *
     *  @return void
     */
    public function execute()
    {
        if(!empty($this->dossier) && !empty($this->action->ext_valeur_text) && !empty($this->dossier->beneficiaire_id))
        {
            $objIndividu = BeanFactory::getBean('OPS_individu', $this->dossier->beneficiaire_id);

            if( !empty($objIndividu->type_individu) && $objIndividu->type_individu == 'medecin' )
            {
                $listeChamps = explode('|',$this->action->ext_valeur_text);
                $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                foreach ($listeChamps as $champs) 
                {
                    $champ = explode(';', $champs);
                    $objReferentiel = BeanFactory::getBean('OPS_generateur_referentiel', $champ[1]);

                    // Récupération valeur du champ dans le dossier
                    if(!empty($this->dossier->{$objReferentiel->name}))
                    {
                        $value = $this->dossier->{$objReferentiel->name};
                    }
                    else
                    {
                        $value = $customChamp->{$objReferentiel->name};
                    }

                    // Adresse domiciliation
                    if($champ[0] == 'adresse_domiciliation')
                    {
                        $value = html_entity_decode($value,ENT_NOQUOTES);

                        // Vérifie si la valeur est encodé en base 64
                        if (!empty($value) && base64_encode(base64_decode($value, true)) === $value)
                        {
                            $value = json_decode(base64_decode($value));
                            
                            $objIndividu->primary_address_number              = $value->numero;
                            $objIndividu->primary_address_street              = $value->rue;
                            $objIndividu->primary_address_complement_batiment = $value->complement_batiment;
                            $objIndividu->primary_address_complement_lieu     = $value->complement_lieu;
                            $objIndividu->primary_address_postalcode          = $value->postcode;
                            $objIndividu->primary_address_city                = $value->city;
                        }
                        else if (empty($value))
                        {
                            $objIndividu->primary_address_number              = '';
                            $objIndividu->primary_address_street              = '';
                            $objIndividu->primary_address_complement_batiment = '';
                            $objIndividu->primary_address_complement_lieu     = '';
                            $objIndividu->primary_address_postalcode          = '';
                            $objIndividu->primary_address_city                = '';
                        }
                    }
                    // Autre champs
                    else
                    {
                        $objIndividu->{$champ[0]} = $value;
                    }
                }
            
                $objIndividu->save();

                if( empty($objIndividu->email1) )
                {
                    if ($objIndividu->load_relationship('email_addresses')) 
                    {
                        $relatedBeans = $objIndividu->get_linked_beans('email_addresses', 'email_address');
                        foreach ( $relatedBeans as $relatedBean ) {
                               $objIndividu->email_addresses->delete($objIndividu->id, $relatedBean->id);
                        } 
                    }
                }
            }
        }
    }

    /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne le nom du fichier javascript
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierMedecinAction";
    }

    private function getChamps(){
        return array(
            'salutation' => 'Civilité',
            'last_name' => 'Nom de famille',
            'nom_usage' => 'Nom d\'usage',
            'first_name' => 'Prénom',
            'email1' => 'E-mail',
            'phone_mobile' => 'Tél. portable',
            'phone_home' => 'Tél. fixe',
            'phone_work' => 'Tél. professionnel',
            'phone_other' => 'Autre tél.',
            'accepte_mail' => 'Accepte mails',
            'accepte_sms' => 'Accepte SMS',
            'adresse_domiciliation' => 'Adresse de domiciliation',
        );
    }
}