<?php

namespace ODE\ActionStatut\Action;

use Sugar_Smarty;
use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class ModifierStatutDossierAction
{
    private $action;
    private $dossier;

    /**
     * Constructeur de la classe OdeActionStatut
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($action, $dossier)
    {
        $this->action = $action;
        $this->dossier = $dossier;
    }

    /**
     * @access public
     * @name getGroup()
     * Fonction qui retourne le groupe de l'action " Modifier le statut/étape d'un dossier "
     *
     *
     *  @return string       - $group
     */
    public function getGroup()
    {
        return 'instruction';
    }

    /**
     * @access public
     * @name getTitle()
     * Fonction qui retourne le titre de l'action " Modifier le statut/étape d'un dossier "
     * 
     *  @return string       - $title
     */
    public function getTitle()
    {
        return "Modifier le statut/étape d'un dossier";
    }

    /**
     * @access public
     * @name getAide()
     * Fonction qui retourne l'aide de l'action " Modifier le statut/étape d'un dossier "
     * 
     *  @return string       - $title
     */
    public function getAide()
    {
        return "Modifier le statut/étape d'un dossier";
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getForm()
    {
        $data = $this->getDataEdition();
        $edit_tpl    = "modules/OPS_action_statut/tpls/EditParams.tpl";
        $form_return = new Sugar_Smarty();
        $form_return->assign("array_form", $data);
        return $form_return->fetch($edit_tpl);
    }

    /**
     * @access public
     * @name getDataEdition()
     * Fonction qui retourne les données de la vue édition
     * 
     *  @return array       - $data
     */
    public function getDataEdition()
    {
        $data = [];

        $etape_liste = '<option value=""></option>';
        $statut_liste = '<option value=""></option>';

        $objEtape = BeanFactory::getBean('OPS_etape');
        $listEtape = $objEtape->get_full_list();

        $objReferentiel = BeanFactory::newbean('OPS_generateur_referentiel');
        $listReferentiel = $objReferentiel->get_full_list(
                                'libelle'
                                );
        $tabReferentiel = array( '' =>  '- aucun -') ;
        foreach ($listReferentiel as $id => $ref) {

            if( !empty($ref->name) ){
                $tabReferentiel[$ref->id] = $ref->libelle . " (". $ref->name . ")" ;
            }
        }

        foreach ($listEtape as $etape) {

            $etape->load_relationship('ops_guide_instruction_ops_etape');
            $guide = $etape->ops_guide_instruction_ops_etape->get();

            $selectedEtape = ($etape->id == $this->action->ext_valeur_1)?'selected':'';
            $etape_liste .= '<option id="'.$etape->id.'" value="'.$etape->id.'" data-guide="'.$guide[0].'"'.$selectedEtape.'>'.$etape->name.'</option>';

            $etape->load_relationship('ops_etape_ops_statut');
            $listeStatut = $etape->ops_etape_ops_statut->get();

            foreach ($listeStatut as $statut) {

                $objStatut = BeanFactory::getBean('OPS_statut', $statut);
                $selectedStatut = ($objStatut->id == $this->action->ext_valeur_3)?'selected':'';
                $statut_liste .= '<option id="'.$objStatut->id.'" value="'.$objStatut->id.'" data-etape="'.$etape->id.'"'.$selectedStatut.'>'.$objStatut->name.'</option>';
            }        
        }

        $sourceValeurJson = '';
        $valeurChamptJson = '';

        if(!empty($this->action->ext_valeur_text)){
            $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
            $sourceValeurJson = $extValeurText['source_valeur'];
            $valeurChamptJson = $extValeurText['valeur_champ'];
        }


        //CHAMPS SOURCE
        $referentielListeSource = get_select_options_with_id($tabReferentiel, $sourceValeurJson);

        $selectSource = '<select name="select_source_valeur" id="select_source_valeur" style="width: 75%;">' . $referentielListeSource . '</select>';
        $selectSource = base64_encode($selectSource);

        $data['ext_valeur_1']['type']  = 'enum';
        $data['ext_valeur_1']['label'] = 'Etape';
        $data['ext_valeur_1']['form']  = '<select name="ext_valeur_1" id="ext_valeur_1" style="width: 75%;">' . $etape_liste . '</select>';

        $data['ext_valeur_2']['type'] = 'text';
        $data['ext_valeur_2']['label'] = 'Commentaire';
        $data['ext_valeur_2']['form'] = '<input type="text" name="ext_valeur_2" id="ext_valeur_2" value="'.$this->action->ext_valeur_2.'">';

        $data['ext_valeur_3']['type']  = 'enum';
        $data['ext_valeur_3']['label'] = 'Statut';
        $data['ext_valeur_3']['form']  = '<select name="ext_valeur_3" id="ext_valeur_3" style="width: 75%;">' . $statut_liste . '</select>';

        $extValeurText = $this->action->ext_valeur_text;

        $data['hidden'] = "<input type='hidden' id='ext_valeur_text' name='ext_valeur_text' value='$extValeurText'>
        <input type='hidden' id='select_source' name='select_source' value='$selectSource'>
        <input type='hidden' id='valeur_champ' name='valeur_champ' value='$valeurChamptJson'>";

        return $data;
    }

    /**
     * @access public
     * @name getDataDetail()
     * Fonction qui retourne les données de la vue détail
     * 
     *  @return array       - $data
     */
    public function getDataDetail()
    {
        $data = [];

        $obj_etape = (!empty($this->action->ext_valeur_1)) ? BeanFactory::getBean('OPS_etape', $this->action->ext_valeur_1) : null;
        $etape_name = ($obj_etape !== null && !empty($obj_etape->name)) ? $obj_etape->name : "";

        $obj_statut = (!empty($this->action->ext_valeur_3)) ? BeanFactory::getBean('OPS_statut', $this->action->ext_valeur_3) : null;
        $statut_name = ($obj_statut !== null && !empty($obj_statut->name)) ? $obj_statut->name : "";

        $sourceValeurJson = '';
        $valeurChamptJson = '';

        if(!empty($this->action->ext_valeur_text)){
            $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
            $sourceValeurJson = $extValeurText['source_valeur'];
            $valeurChamptJson = $extValeurText['valeur_champ'];
        }

        //CHAMP SOURCE
        $objReferentielSource = (!empty($sourceValeurJson)) ? BeanFactory::getBean('OPS_generateur_referentiel', $sourceValeurJson) : null;
        $referentielNameSource = ($objReferentielSource !== null && !empty($objReferentielSource->libelle)) ? $objReferentielSource->libelle : "";

        $data['ext_valeur_1']['type']  = 'text';
        $data['ext_valeur_1']['label'] = 'Etape';
        $data['ext_valeur_1']['valeur']  = $etape_name;

        $data['ext_valeur_2']['type'] = 'text';
        $data['ext_valeur_2']['label'] = 'Commentaire';
        $data['ext_valeur_2']['valeur'] = $this->action->ext_valeur_2;

        $data['ext_valeur_3']['type']  = 'text';
        $data['ext_valeur_3']['label'] = 'Statut';
        $data['ext_valeur_3']['valeur']  = $statut_name;

        $data['hidden'] = "<script type='text/javascript' charset='UTF-8' src='custom/include/Ode/ActionStatut/Js/ModifierStatutDossierAction.js'></script>
        <input type='hidden' id='select_source' name='select_source' value='$referentielNameSource'>
        <input type='hidden' id='valeur_champ' name='valeur_champ' value='$valeurChamptJson'>
        <script type='text/javascript'>ModifierStatutDossierAction.start();</script>";

        return $data;
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui déclenche l'action statut
     * 
     *  @return void    
     */
    public function execute()
    {
        if(!empty($this->dossier)){
            if(!empty($this->action->ext_valeur_3)){

                $execute = true;

                $extValeurText = array();
                $sourceValeurJson = '';
                $valeurChamptJson = ''; 
    
                if(!empty($this->action->ext_valeur_text) && json_decode(base64_decode($this->action->ext_valeur_text)) !== null){
                    $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
                    $sourceValeurJson = $extValeurText['source_valeur'];
                    $valeurChamptJson = $extValeurText['valeur_champ']; 
                }

                //Vérification si on a une condition de champ pour le changement de statut
                if(!empty($this->action->ext_valeur_4) && !empty($sourceValeurJson) && !empty($valeurChamptJson)){

                    $extValeurText = json_decode(base64_decode($this->action->ext_valeur_text),true);
                    $sourceValeurJson = $extValeurText['source_valeur'];
                    $valeurChamptJson = $extValeurText['valeur_champ'];

                    $objReferentiel =  BeanFactory::getBean('OPS_generateur_referentiel', $sourceValeurJson );

                    if(!empty($objReferentiel)){
                        $referentielName = $objReferentiel->name;
                        $customChamp = json_decode( base64_decode( $this->dossier->champs_custom) );

                        if($objReferentiel->description == 'custom'){
                            $champVerif = $customChamp->{$referentielName};
                        }else{
                            $champVerif = $this->dossier->{$referentielName};
                        }

                        $champValeur = strtolower(trim($valeurChamptJson));
                        $champVerif = strtolower(trim($champVerif));


                        //Si on a une liste multiple
                        if($objReferentiel->type == 'liste'){
                            $params = json_decode( base64_decode($objReferentiel->params),true);
                        }

                        //Check différent si on est dans les = valeur multiple
                        if($objReferentiel->type == "checkboxmulti" || (isset($params) && $params['multiple'] == 1)){
                            $motif = '/\^' . preg_quote($champValeur, '/') . '\^/';
                            $execute = (preg_match($motif, $champVerif))?true:false;
                        }else{
                            $champVerif = str_replace( "^", "", $champVerif ) ;  
                            $execute = ($champValeur == $champVerif)?true:false;
                        }
                    }
                }

                if($execute){
                    $this->dossier->updateStatut($this->action->ext_valeur_3,null,'');
                }

            }else{
                $GLOBALS['log']->fatal("ModifierStatutDossierAction => Le statut est vide ");
            }
        }
    }

     /**
     * @access public
     * @name getScriptName()
     * Fonction qui retourne l'aide de l'action " Déclencher un Flux "
     *
     *  @return string       - $title
     */
    public function getScriptName()
    {
        return "ModifierStatutDossierAction";
    }
}
