<?php

namespace ODE\Calendar;

use BeanFactory;

use Sugar_Smarty;

/**
 * Class OdeCalendar
 *
 * @package ODE\Calendar
 */
class OdeCalendar
{
    /** @var bool|object */
    protected $bean = false;

    private $calendar_path;
    private $calendar_namespace;
    private $calendars;

    /**
     * ReplaceVariable constructor.
     * @param object $bean : Bean SuiteCRM
     */
    public function __construct($module, $id)
    {
        global $app_list_strings;

        $bean = BeanFactory::getBean($module, $id);
        if(!empty($bean->id))
        {
            $this->bean = $bean;
        }
        else
        {
            $GLOBALS['log']->fatal('OdeCalendar::__construct => Récupération du Bean impossible');
        }

        $this->calendar_path = "custom/include/Ode/Calendar/Calendar/";
        $this->calendar_namespace = 'ODE\\Calendar\\Calendar\\';
        $this->calendars = $this->getCalendars();
    }

    /**
     * @access private
     * @name getCalendars()
     * Fonction qui retourne la liste des calendriers configurés sur le serveur 
     * 
     * 
     *  @return array       - $calendars
     */
    private function getCalendars()
    {
        $calendars = [];
        if (is_dir($this->calendar_path)) 
        {
            $files = array_diff(scandir($this->calendar_path), ['.', '..']);
            foreach ($files as $file_name) 
            {
                if( end( explode('.', $file_name) ) == 'php')
                {
                    $class_name = $this->calendar_namespace . str_replace('.php', '', $file_name);
                    $calendars[strtolower(str_replace('Calendar.php', '', $file_name))] = new $class_name($this->bean);
                }
            }
        } 
        else 
        {
            $GLOBALS['log']->fatal(" OdeCalendar :: getCalendars => Erreur initialisation des replaces variables, action_path (" . $this->calendar_path . ") introuvable");
        }
    
        return $calendars;
    }

    public function display()
    {

        global $sugar_config; 

        $current_template = "custom/include/Ode/Calendar/tpl/calendar.tpl";
        
        $smarty = new Sugar_Smarty();

        $smarty->assign('record', $this->bean->id);
        
        $smarty->assign('module', $this->bean->module_name);

        // Heure de paramétré 
        $cal_min_heure = $sugar_config['opensocle']['cal_min_heure'];
        $cal_max_heure = $sugar_config['opensocle']['cal_max_heure'];

        $smarty->assign('CAL_MIN_HEURE', $cal_min_heure);
        $smarty->assign('CAL_MAX_HEURE', $cal_max_heure);

        if($this->bean->module_name == 'OPS_individu')
        {
            $smarty->assign('name', $this->bean->first_name . ' ' . $this->bean->last_name);
        }
        else if($this->bean->module_name == 'OPS_personne_morale')
        {
            $smarty->assign('name', $this->bean->name);
        }

        $smarty->display($current_template);
    }

    public function getEvents()
    {
        $events = [];
        foreach($this->calendars as $calendar)
        {
            if(method_exists($calendar, 'getEvents'))
            {
                $calendar_event = $calendar->getEvents();

                if(!empty($calendar_event) && is_array($calendar_event))
                {
                    $events = array_merge($events, $calendar_event);
                }
            }
        }

        return $events;
    }
}
