<?php

namespace ODE\Fonctions\Liste;

use BeanFactory;
use DateTime;

if (!defined('sugarEntry')) define('sugarEntry', true);

class CalculAge
{
    /**
     * @access public
     * @name getFonction()
     * Fonction qui retourne la fonction
     * 
     *  @return array       - $fonction
     */
    public function getFonction()
    {
        return array(
            'fonction_id' => 'CalculAge',
            'fonction_name' => 'Âge du demandeur/Bénéficiaire',
        );
    }

    /**
     * @access public
     * @name execute()
     * Fonction qui permet l'exécution de la fonction
     */
    public function execute($params = [])
    {

        
        if (!empty($params)) {
            if(empty($params['dossier']) && empty($params['champs']['extended']['demandeur'])){
                $individuId = (!empty($params['donnees']['beneficiaire_id']))?$params['donnees']['beneficiaire_id']:$params['donnees']['demandeur']['id'];
            }else if(!empty($params['champs']['extended']['demandeur']) && empty($params['dossier']->beneficiaire_id)){
                $individuId = (!empty($params['champs']['extended']['beneficiaire_id'])) ? $params['champs']['extended']['beneficiaire_id'] : $params['champs']['extended']['demandeur'];
            } else {
                $individuId = (is_array($params['dossier']->ops_individu_id) && !empty($params['dossier']->ops_individu_id['id_hc'])) ? $params['dossier']->ops_individu_id['id_hc'] : $params['dossier']->ops_individu_id;
                $individuId = (!empty($params['dossier']->beneficiaire_id)) ? $params['dossier']->beneficiaire_id : $individuId;
            }

            $nomTechniqueChamp = str_replace("$", "",trim($params['parametre_fonction']));

            $dateDeNaissance = $params['champs']['basic'][$nomTechniqueChamp] ?? ($params['champs']['custom'][$nomTechniqueChamp] ?? false);

            if(!empty($dateDeNaissance) && $dateDeNaissance != false){
                return $this->calculAgeParDateNaissance($dateDeNaissance);
            }

            if (!empty($individuId) && is_string($individuId)) {
                $objIndividu = BeanFactory::getBean('OPS_individu', $individuId);

                if (!empty($objIndividu) && !empty($objIndividu->date_naissance)) {
                    return $this->calculAgeParDateNaissance($objIndividu->date_naissance);
                }
            }
        }
        return "";
    }


    private function calculAgeParDateNaissance($dateNaissance){
        try {
            // Essayer de convertir la date automatiquement
            $dateNaissanceFormat = new DateTime($dateNaissance);
    
            // Calculer la différence avec la date actuelle
            $aujourdHui = new DateTime();
            $intervalle = $dateNaissanceFormat->diff($aujourdHui);
    

            if (!empty($intervalle->y)) {
                return $intervalle->y;
            }
            return 0;
        } catch (Exception $e) {
            return 0;
        }
    }
}
