var FormulaireSection = (function($,Champ) {

    return {

        /**
         * Fonction qui initialise le formulaire "formulaire-section.tpl" avant le display par le routeur
         * 
         * @param {string} section_type Le type de section : text, date, relation ... etc
         * @param {string} section_id L'id du section 
         * @return {void} 
         */
         display: function( section_type, section_id ){
    
            const self = this;

            /*******  Propriétés  ********/ 

            // Initialisation les tabs de navigation 
            this.initTabs();

            // Initialisation du sous titre du formulaire ( Type de section )
            $("#g-section-form-sous-title").text( 'Section' );

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( section_id !== undefined && section_id !== null && !section_id.isEmpty() ) ? false : true;

            // On récupere les données du section si il s'agit d'une modification sinon un object vide
            var data = {}
            data.libelle = ($('#'+section_id).text())?$('#'+section_id).text():$('#'+section_id).next().text();
            data.conditions = $('#'+section_id).attr('data-conditions');
            // Initialisation du titre du formulaire
            ( creation ) ? $("#g-section-form-title").text("Nouvelle section") : $("#g-section-form-title").text(data.libelle) ;

            // On stocke les differents parametres du section dans les input hidden du formulaire
            ( creation ) ? $("#g-section-form-id").val("") : $("#g-section-form-id").val( section_id );
            $("#g-section-form-conditions").val( data.conditions );

            // On initilise le onClick sur le bouton " Edition de liste"
            this.setClickEditListe();

            // On cache le formulaire de modification des listes
            $("#g-section-form-formulaire").show();
            $("#g-section-form-liste").hide();
            
            /***********   Conditions   ***********/ 

            // On initialise la route du bouton "+" ( ajouter une condition ) avec l'id du section si il s'agit d'une modification
            ( creation ) ? $("#g-section-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=`) : $("#g-section-form-condition-add-btn").attr("data-route",`/formulaire-condition?id=${section_id}`);
            
            // On récupere les conditions du section au format object 
            var field_conditions = ( !data.conditions.isEmpty() ) ? JSON.parse( data.conditions.b64ToUtf8() ) : { verified: "all",  visible: 1, modifiable: 1, conditions: [], type_profil:[] };
            OdeLog.log( OdeLog.asAlert("field_conditions"), field_conditions );

            // On initialise la liste des conditions
            this.setListeConditions( field_conditions );
     
            // On initilise la valeur du selection de vérification " Toutes les conditions ou une seule condition "
            $(`#g-section-form-condition-verified option[value="${field_conditions.verified}"]`).prop('selected', true);
            OdeLog.log( OdeLog.asAlert("field_conditions.verified"), field_conditions.verified );
            // On initilise la valeur des boutons radio pour la visibilité
            ( field_conditions.visible === 1 ) ? $('#g-section-form-condition-visible-oui').prop('checked', true) : $('#g-section-form-condition-visible-non').prop('checked', true);

            // On initilise la valeur des boutons radio pour la modification
            ( field_conditions.modifiable === 1 ) ? $('#g-section-form-condition-modifiable-oui').prop('checked', true) : $('#g-section-form-condition-modifiable-non').prop('checked', true);

            // On initialise le click sur le bouton " Ajouter une condition "
            this.setClickAddConditionBtn();

            // On affiche la liste des conditions et on cache le formulaire 
            $("#g-section-form-condition-liste").show();
            $("#g-section-form-condition-formulaire").hide();

            // On initilise le bouton " Sauvegarde " du formulaire 
            this.setSaveFormulaireBtn();

        },

        /** 
         * Fonction qui initialise le click sur les tabs "Propriétés" et "Conditions"
         * 
         * @return {void} 
        */
        initTabs: function() { 
            $('.g-section-tabs-nav a').off().on('click', function (event) {
                event.preventDefault();
                $('.g-section-tab-active').removeClass('g-section-tab-active');
                $(this).parent().addClass('g-section-tab-active');
                if ( $(this).attr('href') === "#g-section-form" ) {
                    $("#g-section-form").show();
                    $("#g-section-condition-form").hide();
                } else {
                    $("#g-section-form").hide();
                    $("#g-section-condition-form").show();
                }
            });
            $('.g-section-tabs-nav a:first').trigger('click');
        }, 

        /**
         * Fonction qui initialise la sauvegarde du formulaire
         * 
         * @return {void} 
        */
        setSaveFormulaireBtn: function() { 
            const self = this;
            $( "#g-section-save-btn" ).click(function() {
                // On récupere l'id et les data du section
                var section_id = self.getSectionId();
                var section_data = self.getSectionData(section_id);
                // Vérification des sections du formulaire
                var is_valid = self.isValidFormulaire(section_id,section_data);
                if ( is_valid ) {
                    // Si l'id est vide => il s'agit d'une création sinon modification
                    ( section_id.isEmpty() ) ? self.createSection(section_data) : self.updateSection(section_id,section_data);
                }
            });
        },

        /**
         * Fonction qui retourne l'id du section sauvegardé dans l'input hidden
         * 
         * @return {string} 
        */
        getSectionId: function(){ return ( $("#g-section-form-id").val() !== undefined ) ? $("#g-section-form-id").val() : ""; },

        /**
         * Fonction qui retourne les données du formulaire en format object 
         * 
         * @return {object} 
        */
        getSectionData: function(section_id){
             
            const self = this;
            var data = {};

            data["id"] =  $("#g-section-form-id").val();
            data["conditions"] = JSON.stringify( this.getSectionConditions() ).utf8ToB64();

            OdeLog.log( OdeLog.asSuccess("data"), data);

            return data;
     
        },

        /**
         * Fonction qui vérifie si 
         *          Le section nom n'est pas vide et n'existe pas dans la liste des sections
         *          Le section libelle n'est pas vide
         * 
         * @param {string}  section_id     L'id du section 
         * @param {object}  section_data   Les données du section
         * @return {boolean} 
        */
        isValidFormulaire: function(section_id,section_data){
            var valid = true;
            Object.keys(section_data).forEach(function (section_name) {
                var section_value = section_data[section_name];
                switch(section_name){
                    case 'nom':
                        if ( Section.isSectionExist(section_value) && section_id.isEmpty() ){
                            valid = false;
                            Section.displayVerification( $("#form-field-nom") , "warning", `Le section ${section_value} existe déjà dans le référentiel` )
                        } else {
                            if ( section_value.isEmpty() ){
                                valid = false;
                                Section.displayVerification( $("#form-field-nom") , "error", "Le nom est obligatoire" )
                            } else {
                                Section.displayVerification( $("#form-field-nom") , "success", "" )
                            }
                        }
                        break;
                    case 'libelle':
                        if ( section_value.isEmpty() ){
                            valid = false;
                            Section.displayVerification( $("#form-field-libelle") , "error", "Le libellé est obligatoire" )
                        } else {
                            Section.displayVerification( $("#form-field-libelle") , "success", "" )
                        }
                        break;
                    case 'attache':
                        if ( section_value.isEmpty() ){
                            valid = false;
                            Section.displayVerification( $("#form-field-attache-file") , "error", "Le type est obligatoire" )
                        } else {
                            Section.displayVerification( $("#form-field-attache-file") , "success", "" )
                        }
                        break;
                    default:
                        $("[role=section-formulaire]").each(function() {
                            if( $(this).attr("data-name") === section_name ){
                                Section.displayVerification( $(this) , "success" , "");
                            }
                        });
                        break;
                }
            });
     
            return valid;
        },

        /**
         * Fonction qui crée le section dans le module OPS_generateur_referentiel 
         * 
         * @param {object}  data   Les données du section
         * @return {void} 
        */
        createSection: function(data){
            loading = function(){
                OdeLoadingHelper.addSpinnerMenu();
            };
            callBack = function(){
                setTimeout(function(){ OdeLoadingHelper.removeSpinnerMenu(); }, 1500);
                if ( typeof this.result === "string" ){
                    OdeAlertHelper.set($(`#g-section-form-message`), "error", "La ressource demandée n'existe pas");
                }  else {

                    // On ajoute le section à la liste des sections et on réinitilise l'event draggable des sections
                    var section_html = Section.getHtml(this.result);
                    $("#list-section-container").append($(section_html));
                    Section.setDraggable();

                    // On réinitialise l'event sur le role navigation pour activer l'edition du section
                    Router.setClickRoutes();

                    // On redirige vers liste et on scroll tout en bas 
                    Router.navigate("/");
                    setTimeout(function(){ $("#g-menu").animate({scrollTop: 9999}, 1000) }, 500);
                }
            };
            Section.create(data, loading, callBack);
        },

        /**
         * Fonction qui met à jour le section en local  
         * 
         * @param {string}      id      L'id du section 
         * @param {object}      data    Les données du section
         * @return {void} 
        */
        updateSection: function(id,data){
            OdeLoadingHelper.addSpinnerMenu();
            Section.update(id , data);

            //Flag modification
            Champ.flagModification(data.id);
        },

        /**
         * Fonction qui ajoute l'attribut "multiple" au params des sections de type liste 
         * 
         * @param {string}      value      La valeur "1" ou "0"
         * @return {void} 
        */
        setMultipleValue: function( value ){
            var params = this.getSectionParams();
            params.multiple = ( value === 1 ) ? 1 : 0 ;
            $("#g-section-form-params").val( JSON.stringify(params).utf8ToB64() )
        },

        // Retourne un array des conditions du section
        getSectionConditions: function () {
            var conditions = { verified: "all",  visible: 1, modifiable: 1, type_profil:"", conditions: [] }; 
            var conditions_encoded = $("#g-section-form-conditions").val();
            var type_profil = '';
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                conditions = JSON.parse(conditions_encoded.b64ToUtf8());  
            }
            conditions.verified = $("#g-section-form-condition-verified option:selected").val();
            conditions.visible = ( $('#g-section-form-condition-visible-oui').prop('checked') === true ) ? 1 : 0 ;
            conditions.modifiable = ( $('#g-section-form-condition-modifiable-oui').prop('checked') === true ) ? 1 : 0 ;
            OdeLog.log( OdeLog.asWarning("conditions"), conditions );
            return conditions;
        },

        /**
         * Fonction qui retourne la valeur de l'attribut "multiple" des sections de type liste 
         * 
         * @return {string} 
        */
        getMultipleValue: function(){
            var params = this.getSectionParams();
            return ( Object.getLength(params) > 0 && params.hasOwnProperty("multiple") && params.multiple === 1 ) ? 1 : 0;
        },

        /**
         * Fonction qui retourne les params du section format object
         * 
         * @return {object} 
        */
        getSectionParams: function ( type = null){
            var params_retour = { liste: {}, multiple: 0 };
            var params = $("#g-section-form-params").val();
            if ( params !== undefined && !params.isEmpty() ){
                var params_decoded = JSON.parse( params.b64ToUtf8() );
                if ( Object.getLength(params_decoded) > 0 ){
                    if ( params_decoded.hasOwnProperty("liste_name") ){
                        params_retour.liste = this.getListeNative(params_decoded.liste_name);
                    }
                    if ( params_decoded.hasOwnProperty("liste_attache") && type == 'attache'){
                        params_retour.liste = JSON.parse( $("#type_document").val().b64ToUtf8());
                    }
                    if ( params_decoded.hasOwnProperty("liste_mime") &&  type == 'mime'){
                        params_retour.liste = this.getListeNative(params_decoded.liste_mime);
                    }
                    if ( params_decoded.hasOwnProperty("liste_avis_impot") &&  type == 'api_particulier'){
                        params_retour.liste = this.getListeNative(params_decoded.liste_avis_impot);
                    }

                    if ( params_decoded.hasOwnProperty("multiple") && params_decoded.multiple === 1 ) {
                        params_retour.multiple = 1;
                    }
                    if ( params_decoded.hasOwnProperty("liste") && Object.getLength(params_decoded.liste) > 0 ){
                        params_retour.liste = params_decoded.liste;
                    }
                }
            }
            return params_retour;
        },

        /**
         * Fonction qui retourne les données de la liste ( Les listes app_string de SuiteCRM )
         * 
         * @return {object} 
        */
        getListeNative: function ( liste_name ){
            var liste = {};
            var liste_suiteCRM = JSON.parse( $("#suitecrm_listes").val().b64ToUtf8() );
            if ( Object.getLength(liste_suiteCRM) > 0 && liste_suiteCRM.hasOwnProperty(liste_name) ){
                liste = liste_suiteCRM[liste_name];
            }
            return liste;
        },

        /**
         * Fonction qui initialise le click sur le bouton " Ajouter une condition "
         * 
         * @return {void} 
         */
        setClickAddConditionBtn: function(){ 
            const self = this;
            $("#g-section-form-condition-add-btn").off().click(function(){ 
                self.initFormCondition(null,null,null);
                $("#g-section-form-condition-liste").hide();
                $("#g-section-form-condition-formulaire").show();
            });

            $("#g-section-form-condition-type-profil-add-btn").off().click(function(){
                open_popup("OPS_type_personne",600,400,"",true,false,
                {"call_back_function":"FormulaireSection.getConditionTypeProfil","form_name":"generer","field_to_name_array":{"id":"id","name":"type_profil"}},"single",true);
            });
        },

        getConditionTypeProfil: function(typeProfil){
            var conditions_encoded = $("#g-section-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                conditions = JSON.parse(conditions_encoded.b64ToUtf8());
            }else{
                conditions = FormulaireOnglet.getConditions();
            }
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if(conditions.type_profil.length > 0){
                var check = false;
                $.each(conditions.type_profil, function(key, tab) {
                    $.each(tab, function(id, value) {
                        if(conditions.type_profil[key][id] == typeProfil.name_to_value_array.type_profil && id == typeProfil.name_to_value_array.id ){
                            conditions.type_profil[key][id] = typeProfil.name_to_value_array.type_profil;
                            check = true; 
                            return false;
                        } 
                    });
                    if(check) return false;
                });
                if(!check) conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }else{
                conditions.type_profil.push({[typeProfil.name_to_value_array.id]: typeProfil.name_to_value_array.type_profil});
            }
            FormulaireSection.setListeConditions(conditions);
            $("#g-section-form-conditions").val(JSON.stringify(conditions).utf8ToB64() );
        },

        /**
         * Fonction qui initialise le formulaire d'ajout et de modification des conditions 
         * 
         * @param {string} section 
         * @param {string} operator 
         * @param {string} value 
         * @return {void} 
        */
        initFormCondition: function( section, operator, value){

            
            if ( section === undefined || section === null ) section = "";
            if ( operator === undefined || operator === null ) operator = "";
            if ( value === undefined || value === null ) value = "";

            // On récupere la liste des sections de la vue courante 
            var sections = this.getSectionVueCourante();

            // Initialisation du select section
            var sections_options = this.getSectionOptionHtml( sections );
            $("#g-section-form-condition-section").empty();
            $("#g-section-form-condition-section").append( sections_options );

            // Initialisation du select section
            var operateurs_options = this.getOperateurOptionHtml();
            $("#g-section-form-condition-operateur").empty();
            $("#g-section-form-condition-operateur").append( operateurs_options );

            // On initilise le formulaire avec les valeurs
            $(`#g-section-form-condition-section option[value="${section}"]`).prop("selected", "selected");
            $(`#g-section-form-condition-operateur option[value="${operator}"]`).prop("selected", "selected");
            $("#g-section-form-condition-value").val(value);

            $("#g-section-form-condition-section-old").val(section), 
            $("#g-section-form-condition-operateur-old").val(operator),
            $("#g-section-form-condition-value-old").val(value),

            // On initialise le click sur le bouton " Fermer formulaire "
            this.setClickBackListeBtn();

            // On vérifie si il s'agit d'une création ou d'une modification
            var creation = ( section.isEmpty() && operator.isEmpty() && value.isEmpty() ) ? true : false;
            ( creation ) ? $("#g-section-form-condition-add-btn").show() : $("#form-g-section-form-condition-btn").hide();
            ( creation ) ? $("#g-section-form-condition-update-btn").hide() : $("#g-section-form-condition-update-btn").show();
            ( creation ) ? $("#g-section-form-condition-save-btn").val("Ajouter") : $("#g-section-form-condition-save-btn").val("Modifier");
            
            // On initialise le click sur le bouton " Ajouter " / " Modifier "
            this.setSaveCondition();
       
        },

        getOperateurOptionHtml: function(){
            var options_html = '<option></option>';
            options_html    += '<option value="=">[ = ] est égal </option>';
            options_html    += '<option value=">">[ > ] est supérieur strict</option>';
            options_html    += '<option value=">=">[ >= ] est supérieur égal </option>';
            options_html    += '<option value="<">[ < ] est inférieur strict</option>';
            options_html    += '<option value="<=">[ <= ] est inférieur égal </option>';
            return options_html;
        }, 

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
         setSaveCondition: function(){ 

            const self = this;

            Champ.hideVerification( $("#g-section-form-condition-section") );
            Champ.hideVerification( $("#g-section-form-condition-operateur") );

            $("#g-section-form-condition-save-btn").off().click(function(){ 

                var valid = true;
                // On récupere les valeurs du formulaire ( la condition )
                var condition = {
                    champ: $("#g-section-form-condition-section option:selected").val(), 
                    operator: $("#g-section-form-condition-operateur option:selected").val(),
                    value: $("#g-section-form-condition-value").val(),
                };

                // On vérifie le parametre section si il est valide
               
                if ( condition.champ.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-section-form-condition-section") , "error", "Le section est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-section-form-condition-section") );
                }
    
                // On vérifie le parametre operator si il est valide
                if ( condition.operator.isEmpty() ){
                    valid = false;
                    Champ.displayVerification( $("#g-section-form-condition-operateur") , "error", "L'opérateur est obligatoire" )
                } else {
                    Champ.hideVerification( $("#g-section-form-condition-operateur") );
                }

                // Si la condition est valide 
                if ( valid === true ) {

                    // On récupere les données de la condition à éditer 
                    var old_condition = {
                        champ: $("#g-section-form-condition-section-old").val(), 
                        operator: $("#g-section-form-condition-operateur-old").val(),
                        value: $("#g-section-form-condition-value-old").val(),
                    };

                    // vérifie si il s'agit de création ou d'une modification
                    if ( old_condition.champ.isEmpty() && old_condition.operator.isEmpty() ){
                        self.addCondition( condition );
                    }else{
                        self.updateCondition( old_condition, condition );
                    }
                    
                }
            });
        },

        // Retourne un array, la liste des sections dans le réferentiel
        getSectionVueCourante: function(){
            var liste = [];
            $('[role="vue"]').each(function() {
                if ( $(this).css("display") !== "none" ) {
                    var vue_sections = $(this).find($('[role="list-champ"]'));
                    vue_sections.each(function() {
                        liste.push({ nom: $(this).attr("data-nom"), libelle: $(this).attr("data-libelle") });
                    });
                }
            });
            return liste;
        },

        // Retourne les options du select "Liste des sections" avec le nom comme value et libellé en text
        getSectionOptionHtml: function( sections ){
            var sections_html = "<option></option>";
            if ( Object.getLength(sections) > 0 ) {
                sections.forEach(function(item) {
                    sections_html += `<option value="${item.nom}">${item.libelle} (${item.nom})</option>`;
                }); 
            }
            return sections_html;
        },

        /**
         * Fonction qui 
         * 
         * @return {void} 
        */
        setClickBackListeBtn: function(){ 
            $("#g-section-form-condition-back-liste").off().click(function(){ 
                $("#g-section-form-condition-liste").show();
                $("#g-section-form-condition-formulaire").hide();
            });
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucune condition" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElement: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucune condition </li>';
        },

        /**
         * Fonction qui retourne une ligne avec le message "Aucun type de profil" en format html  
         * 
         * @return {string} 
         */
        getEmptyListElementTypeProfil: function(){
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun type de profil </li>';
        },


        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
         */
         setClickDeleteConditionBtn: function(){ 
            const self = this;
            $("[role=delete-condition]").each(function() {
                $(this).click(function(){ 
                    // On supprime la condition des parametres du section
                    var deleted = self.deleteCondition({
                        champ: $( this ).attr( "data-champ" ),
                        operator: $( this ).attr( "data-operator" ),
                        value: $( this ).attr( "data-value" ),
                    });
                    if ( deleted ) {
                        var data = self.getConditions();
                        self.setListeConditions( data );
                        OdeAlertHelper.set( $(`#g-section-form-message`) , "success",`Condition supprimée`);
                    }
                });
            });

            $("[role=delete-condition-type-profil]").each(function() {
                $(this).click(function(){ 
                    var data = FormulaireSection.getConditions();
                    var check = false;
                    var idCheck = $(this).attr('data-type-profil');
                    $.each(data.type_profil, function(key, tab) {
                        $.each(tab, function(id, value) {
                            if(id == idCheck ){
                                data.type_profil.splice(key,1);
                                check = true; 
                                return false;
                            } 
                        });
                        if(check) return false;
                    });
                    $("#g-section-form-conditions").val(JSON.stringify(data).utf8ToB64());
                    FormulaireSection.setListeConditions( data );
                });
            });
        },

        /**
         * Fonction qui initialise le click sur le bouton " Supprimer une condition "
         * 
         * @return {void} 
         */
        setClickUpdateConditionBtn: function(){ 
            const self = this;
            $("[role=update-condition]").each(function() {
                $(this).click(function(){
                    self.initFormCondition($(this).attr("data-champ"), $(this).attr("data-operator"), $(this).attr("data-value"));
                    $("#g-section-form-condition-liste").hide();
                    $("#g-section-form-condition-formulaire").show();
                });
            });
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du section
         * @return {string} conditions_html Les conditions du section en format HTML
         */
        getListElement: function( conditions ){
            var conditions_html = "";
            conditions.forEach(function(condition) {

                conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                conditions_html +=      `<div class="row">`;
                conditions_html +=          `<div class="col-md-9">`;
                conditions_html +=              `<p> <strong>Si</strong> ${condition.champ} <strong> ${condition.operator} </strong> ${condition.value} </p>`;
                conditions_html +=          `</div>`;
                conditions_html +=          `<div class="col-md-3">`;
                conditions_html +=              `<button role="delete-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Supprimer la condition" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=              `<button role="update-condition" data-champ="${condition.champ}" data-operator="${condition.operator}" data-value="${condition.value}" title="Modifier la condition" class="badge" style="background-color:#28a745;padding: 5px 6px;border: none;">`;
                conditions_html +=                  `<i class="fas fa-edit"></i>`;
                conditions_html +=              `</button>`;
                conditions_html +=          `</div>`;
                conditions_html +=      `</div>`;
                conditions_html += `</li>`;
            });
            return conditions_html;
        },

        /**
         * Fonction retourne les conditions au format HTML
         * 
         * @param {object} conditions Les conditions du champ
         * @return {string} conditions_html Les conditions du champ en format HTML
         */
        getListElementTypeProfil: function( type_profil ){
            var conditions_html = "";
            type_profil.forEach(function(tab, key) {
                $.each(tab, function(id, value) {

                    conditions_html += `<li class="list-group-item d-flex justify-content-between align-items-center">`;
                    conditions_html +=      `<div class="row">`;
                    conditions_html +=          `<div class="col-md-9">`;
                    conditions_html +=              `<p> ${value} </p>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=          `<div class="col-md-3">`;
                    conditions_html +=              `<button role="delete-condition-type-profil" data-type-profil="${id}" title="Supprimer le type de profil" class="badge" style=" background-color: #dc3545; padding: 5px 6px;border: none;">`;
                    conditions_html +=                  `<i class="fas fa-trash-alt"></i>`;
                    conditions_html +=              `</button>`;
                    conditions_html +=          `</div>`;
                    conditions_html +=      `</div>`;
                    conditions_html += `</li>`;
                });
            });
            return conditions_html;
        },

        /**
         * Fonction qui initialise le click sur le bouton " Editer une liste "
         * 
         * @return {void} 
         */
        setClickEditListe: function(){ 
            const self = this;
            $("#g-section-form-edit-liste-btn").off().click(function(){ 
                self.initFormListe();
                $("#g-section-form-liste").show();
                $("#g-section-form-formulaire").hide();
            });
        },

        /**
         * Fonction qui initialise le formulaire de modification de la liste
         * 
         * @return {void} 
        */
        initFormListe: function(){
            
            const self = this;

            OdeLog.log( OdeLog.asAlert("initFormListe"), "Initialisation " );

            // On initialise le click sur le bouton " Ajouter une ligne dans la liste "
            this.setClickAddLigneListe();
            
            // On initilise le click sur le btn " Fermer editeur liste " 
            this.setClickCloseListe();

            // On initilise le click sur le btn " Modifer la liste " 
            this.setClickUpdateListe();

            // On récupere la liste du section
            var params = this.getSectionParams();
            var liste = ( params.hasOwnProperty("liste") ) ? params["liste"] : {};

            $("#g-section-form-liste-liste").empty();
            if ( Object.getLength(liste) > 0 ) {
                var lignes = "";
                liste.forEach(function(option_libelle,option_value) {
                    if ( !option_value.isEmpty() ){
                        lignes += self.getLigneListe( option_value, option_libelle );
                    }
                });
                $("#g-section-form-liste-liste").append($(lignes));
                this.initDeleteLigneListe();
            } else {
                var ligne_vide = this.getEmptyLigneListe();
                $("#g-section-form-liste-liste").append($(ligne_vide))
            }

        },

        /**
         * Fonction qui initialise le click sur le bouton " Fermer L'éditeur de liste "
         * 
         * @return {void} 
        */
        setClickCloseListe: function(){
            $("#g-section-form-liste-close").off().click(function(){ 
                $("#g-section-form-liste").hide();
                $("#g-section-form-formulaire").show();
            });
        },

        getLigneListe: function( cle, value ){

            var _cle = ( cle !== null && cle !== undefined ) ? cle : "";
            var _value = ( value !== null && value !== undefined ) ? value : "";

            var ligne =`<li class="list-group-item d-flex justify-content-between align-items-center">`;
            ligne    +=     `<div role="formulaire-liste-ligne" class="row">`;
            ligne    +=         `<div class="col-md-4">`;
            ligne    +=             `<input role="formulaire-liste-cle" type="text" placeholder="Clé" value="${_cle}" style="width: 100%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-7">`;
            ligne    +=             `<input role="formulaire-liste-value" type="text" placeholder="Value" value="${_value}"style="width: 95%;" >`;
            ligne    +=         `</div>`;
            ligne    +=         `<div class="col-md-1">`;
            ligne    +=             `<button role="formulaire-liste-delete" title="Supprimer la ligne" class="badge" style=" float: right;margin-top: 4px;background-color: #dc3545; padding: 5px 6px;border: none;">`;
            ligne    +=                 `<i class="fas fa-trash-alt"></i>`;
            ligne    +=             `</button>`;
            ligne    +=         `</div>`;
            ligne    +=     `</div>`;
            ligne    += `</li>`;   

            return ligne;    

        },
        
       /**
         * Fonction qui initialise le "add" ligne dans liste
         * 
         * @return {void} 
        */
        setClickAddLigneListe: function(){
           
            const self = this;
            $("#g-section-form-liste-add-btn").off().click(function(){ 
                
                let ligne = self.getLigneListe( null, null);
                 
                if ( $(`#g-section-form-liste-liste`).find($("[role=formulaire-liste-ligne]")).length > 0 ){
                    $(`#g-section-form-liste-liste`).append($(ligne));
                } else {
                    $(`#g-section-form-liste-liste`).empty();
                    $(`#g-section-form-liste-liste`).append($(ligne));
                }
               /* */
                self.initDeleteLigneListe();
                  
            });
          
        },

        getEmptyLigneListe: function() {
            return '<li class="list-group-item d-flex justify-content-between align-items-center"> Aucun élement </li>';
        },
 
        initDeleteLigneListe: function(){
            $("[role=formulaire-liste-delete]").each(function() {
                $(this).off().click(function(){ 
                    $(this).parent().parent().parent().remove();
                });
            });
        },

        /**
         * Fonction qui initialise l'event click sur le bouton "Modifier liste"
         * 
         * @return {void} 
        */
        setClickUpdateListe: function(){
            const self = this;
            $("#g-section-form-liste-update-btn").off().click(function(){ 
                var elements = {};
                var lignes = $(`#g-section-form-liste-liste`).find($("[role=formulaire-liste-ligne]"));
                if ( lignes !== undefined && lignes.length > 0 ){
                    lignes.each(function() {
                        var input_cle = $(this).find($("[role=formulaire-liste-cle]"));
                        var input_value = $(this).find($("[role=formulaire-liste-value]"));
                        if ( input_cle !== undefined && input_value !== undefined ){
                            if ( !input_cle.val().isEmpty() ){
                                elements[input_cle.val()] = input_value.val();
                            }
                        }
                    });
                }
                self.setListe(elements);
                self.setSectionListe();
                var default_value = self.getSectionDefaut();
                self.setSectionDefaut( default_value );
                OdeAlertHelper.set( $(`#g-section-form-message`), "success",`La liste a bien été modifiée`);
                $("#g-section-form-liste-close").click();
                
            });
        },
        /**
         * Fonction qui initialise le formulaire "formulaire-section.tpl" avant le display par le routeur
         * 
         * @param {string} section_type Le type de section : text, date, relation ... etc
         * @param {string} section_id L'id du section 
         * @return {void} 
         */





        /**
         * Fonction qui supprime 
         * 
         * @return {void} 
         */

        setDataField: function( field, field_name, field_value ){
          
            var field_tag = field.get(0).tagName;
            var field_type = field.attr("type");
            var params = ($("#g-section-form-params").val() !== "")?JSON.parse( atob( $("#g-section-form-params").val() ) ):undefined;

            if ( field_tag === "INPUT" ){
               
                if ( field_type === "text" ){
                   
                    ( field_value !== null ) ? field.val(field_value) : field.val("");
                } else if ( field_type === "checkbox" ) {
                    if ( field_name === "multiple" ){ 
                        ( this.getMultipleValue() == "1" ) ? field.prop("checked","checked") : field.removeAttr("checked");
                    } else if(field_name === "decimal" && params !== undefined){
                        ( params.decimal !== null && params.decimal == "1") ? field.prop("checked","checked") : field.removeAttr("checked");
                    }else{
                        ( field_value !== null && field_value == "1") ? field.prop("checked","checked") : field.removeAttr("checked");
                    }
                } else if ( field_type === "number" ) { 
                    if(field_name == 'minimum' && params !== undefined){
                        ( params.minimum !== undefined ) ? field.val(params.minimum) : field.val("0");
                    }else if(field_name == 'maximum' && params !== undefined){
                        ( params.maximum !== undefined ) ? field.val(params.maximum) : field.val("0");
                    }
                    else{
                        ( field_value !== null ) ? field.val(field_value) : field.val("0");
                    }
                }else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "Type section input non géré", field );
                }

            } else if ( field_tag === "SELECT" ){

                if ( field_name === "liste" ){
                        this.setSectionListe();
                        ( this.isSectionBasic() === true ) ? this.disableEditListe() : this.enableEditListe();
                } else if ( field_name === "defaut" ){
                    ( field.attr("id") === "form-field-defaut-date" ) ? this.setSectionDateDefaut( field_value ) : this.setSectionDefaut( field_value );
                } 
                else if( field_name === "attache" ){
                    if($("#g-section-form-params").val() === undefined || $("#g-section-form-params").val() === ''){
                        var params_retour = { liste_attache: "type_attache" };
                        $("#g-section-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setSectionAttacheFile();
                }
                else if( field_name === "avis_impot" ){
                    if($("#g-section-form-params").val() === undefined || $("#g-section-form-params").val() === ''){
                        var params_retour = { liste_avis_impot: "avis_impot" };
                        $("#g-section-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }else{
                        var params_retour = JSON.parse( atob( $("#g-section-form-params").val() ) );
                        if(params_retour.liste_avis_impot === undefined || params_retour.avis_impot === ''){
                            params_retour.liste_avis_impot = "avis_impot";
                        }
                        $("#g-section-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setSectionAvisImpot();
                }
                else if( field_name === "avis_impot_condition" ){
                    if($("#g-section-form-params").val() === undefined || $("#g-section-form-params").val() === ''){
                        var params_retour = { liste_avis_impot: "avis_impot" };
                        $("#g-section-form-params").val( btoa( JSON.stringify( params_retour ) ) );
                    }
                    this.setSectionAvisImpotCondition();
                }
                else {
                    OdeLog.log( OdeLog.asAlert("Erreur"), "param section non géré", field );
                }

            } 
            else if(field_tag === "TEXTAREA"){
                ( field_value !== null ) ? field.text(field_value) : field.text("");
            }else {
                OdeLog.log( OdeLog.asAlert("Erreur"), "Tag section non géré", field );
            }

        },

        getSectionDefaut: function( id ){
            return $(`#${id} option:selected`).val();
        },

        getSectionMulti: function ( id ){
            var values = $(`#${id}`).val();
            var selected = '';
            if(values.length > 0){
                $.each(values, function(index, value){
                    if(index+1 == values.length){
                        selected += value;
                    }else{
                        selected += value+',';
                    }
                });
            }
            return selected;
        },

        setSectionListe: function(){
            var liste_options = this.getOptionsListeSection( null );
            $("#form-field-liste").empty();
            $("#form-field-liste").append($(liste_options));
        },

        setSectionAttacheFile: function(){
            var params = JSON.parse( atob( $("#g-section-form-params").val() ) );
            var liste_options = this.getOptionsListeSection( params.attache, 'attache' );
            $("#form-field-attache-file").empty();
            $("#form-field-attache-file").append($(liste_options));
        },

        setSectionAvisImpot: function(){
            var params = JSON.parse( atob( $("#g-section-form-params").val() ) );
            var liste_options = this.getOptionsListeSection( params.avis_impot, 'api_particulier' );
            liste_options = liste_options.replace('<option></option>','');
            $("#form-field-avis-impot").empty();
            $("#form-field-avis-impot").append($(liste_options));
        },

        setSectionAvisImpotCondition: function(){
            var params = JSON.parse( atob( $("#g-section-form-params").val() ) );
            var liste_options = this.getOptionsListeSection( params.avis_impot_condition, 'api_particulier' );
            $("#form-field-avis-impot-condition").empty();
            $("#form-field-avis-impot-condition").append($(liste_options));
        },
        
        setSectionDateDefaut: function( value ){
            var options = $("#form-field-defaut-date").find("option");
            options.each(function() {
                ( $(this).val() === value ) ? $(this).prop('selected', true) : $(this).removeAttr("selected");
            });
        },

        setSectionDefaut: function( value ){
            var defaut_options = this.getOptionsListeSection( value );
            $("#form-field-defaut-liste").empty();
            $("#form-field-defaut-liste").append($(defaut_options))
        },

        isSectionBasic: function(){
            return ( $("#g-section-form-description").val() === "basic" ) ? true : false;
        },

        enableEditListe: function(){
           $("#g-section-form-edit-liste-btn").css("color","#f08377");
           $("#g-section-form-edit-liste-btn").css("cursor","pointer");
           Router.setClickRoutes();
        },

        disableEditListe: function(){
           $("#g-section-form-edit-liste-btn").css("color","#959393");
           $("#g-section-form-edit-liste-btn").css("cursor","initial");
           $("#g-section-form-edit-liste-btn").off();
        },

        getOptionsListeSection: function ( value, type = null ){
            var params = this.getSectionParams(type);
            if( type == 'attache' ){
                var liste = params.liste;
            }else{
                var liste = ( params.hasOwnProperty("liste") ) ? params["liste"] : {};
            }
            
            var options = "<option></option>";
            if ( Object.getLength(liste) > 0 ) {
                liste.forEach(function(option_libelle,option_value) {
                    if ( !option_value.isEmpty() ){
                        if ( value === option_value
                            || ( value != null && value.indexOf(option_value) != -1  && (type == 'mime' || type == 'api_particulier') ) ){
                            options += `<option value="${option_value}" selected="selected" >${option_libelle}</option>`
                        } else {
                            options += `<option value="${option_value}" >${option_libelle}</option>`
                        }
                    }
                });
            }
            return options;
        },

        setListe: function(elements){
            if ( typeof elements === "object" && Object.getLength(elements) > 0 ){
                var params = this.getSectionParams();
                params.liste = elements;
                $("#g-section-form-params").val( JSON.stringify(params).utf8ToB64() )
            }
        },

        // On ajoute une condition au section
        addCondition: function ( condition ){
            var data = this.getConditions();
            OdeLog.log( OdeLog.asSuccess("data"), data );
            if ( this.isConditionValid( condition, data.conditions) ) {
                data.conditions.push(condition);
                $("#g-section-form-conditions").val(JSON.stringify(data).utf8ToB64() );
                OdeLog.log( OdeLog.asSuccess("addCondition :: conditions "), $("#g-section-form-conditions") );
                this.setListeConditions( data );
                $("#g-section-form-condition-liste").show();
                $("#g-section-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-section-form-message`) , "success",`La condition a bien été ajoutée`);
            } else {
                OdeAlertHelper.set( $(`#g-section-form-message`) , "warning",`Cette condition existe deja sur le section`);
            }
        },

        // On edit une condition
        setListeConditions: function ( conditions ){

            // On initialise la liste des conditions avec le message " Aucune condition "
            var liste_element_html = this.getEmptyListElement();
            // On ajoute les conditions à la liste 
            if ( Object.getLength(conditions.conditions ) > 0){
                liste_element_html = this.getListElement( conditions.conditions );
            }
            $("#g-section-form-condition-form-liste").empty();
            $("#g-section-form-condition-form-liste").append(liste_element_html);

            var liste_element_type_profil_html = this.getEmptyListElementTypeProfil();
            // On ajoute les types de profil à la liste 
            if(!Array.isArray(conditions.type_profil)) conditions.type_profil = [];
            if ( conditions.type_profil && Object.getLength(conditions.type_profil ) > 0){
                liste_element_type_profil_html = this.getListElementTypeProfil( conditions.type_profil );
            }
            $("#g-section-form-condition-type-profil-form-liste").empty();
            $("#g-section-form-condition-type-profil-form-liste").append(liste_element_type_profil_html);
            
            // On initilise le click sur les boutons " Supprimer une condition "
            this.setClickDeleteConditionBtn();

            // On initilise le click sur les boutons " Modifier une condition "
            this.setClickUpdateConditionBtn();
            var section_id = this.getSectionId();
            if ( !section_id.isEmpty() ) {
                nbCondition = Object.getLength(conditions.conditions) + Object.getLength(conditions.type_profil);
                this.displayIconeConditions( section_id, nbCondition );
            }
        },

        displayIconeConditions: function ( section_id, nb ){
            $(`#${section_id}`).parent().find('[role="display-conditions"]').empty();
            if ( typeof nb === "number" && nb > 0 ) {
                var icone_html = `<i style="margin-left: 8px;color: #f08377;cursor: help;" title="${nb} condition(s)" class="fas fa-filter"></i>`;
                icone_html +=`<span style="top: 1px;position: relative;margin-left: -1px;color: #f08377;font-size: 11px;font-weight: bold;">${nb}</span>`;
                $(`#${section_id}`).parent().find('[role="display-conditions"]').append( icone_html );
            }
        },

        setIconeConditions: function() {
            const self = this;
            $("[role=section-title]").each(function() {
                    if ( !$(this).attr("data-conditions").isEmpty() ) {
                        var data_conditions = JSON.parse($(this).attr("data-conditions").b64ToUtf8());  
                        if ( data_conditions.hasOwnProperty("conditions") ){
                            nbCondition = Object.getLength(data_conditions.conditions) + Object.getLength(data_conditions.type_profil);
                            self.displayIconeConditions( $(this).attr("id") , nbCondition );
                        }
                    }
            });
        },

        // On edit une condition
        updateCondition: function ( old_condition, new_condition ){

            var updated = false;
            var data = this.getConditions();
            if ( !this.isConditionValid( new_condition, data.conditions) || !this.isEgalCondition(new_condition,old_condition) ) {
                console.log("La condition est differente de celle qui existe => on modifie ")
                var new_conditions = [];
                data.conditions.forEach(function(element) {
                    if ( element.section === old_condition.champ && element.operator === old_condition.operator && element.value === old_condition.value ){
                        new_conditions.push(new_condition);
                        updated = true;
                    }else{
                        new_conditions.push(element);
                    }
                });
                data.conditions = new_conditions;
                $("#g-section-form-conditions").val( JSON.stringify(data).utf8ToB64() );

                this.setListeConditions( data );
            } else {
                updated = true;
            }

            // Redirection + message 
            if ( updated ){
                $("#g-section-form-condition-liste").show();
                $("#g-section-form-condition-formulaire").hide();
                OdeAlertHelper.set( $(`#g-section-form-message`) , "success",`La condition a bien été modifiée`);
            } else {
                OdeAlertHelper.set( $(`#g-section-form-message`) , "warning",`Erreur de modification de la condition`);
            } 

        },

        isEgalCondition:function (condition_1, condition_2){
            return ( condition_1.section === condition_2.section && condition_1.operator === condition_2.operator && condition_1.value === condition_2.value  ) ? true : false;
        },

        isConditionValid:function (condition, conditions){
            if ( Object.getLength(conditions) === 0 ) return true;
            var exist = false;
            conditions.forEach(function(_condition) {
                if ( _condition.champ === condition.champ ){
                    if ( _condition.operator === condition.operator ){
                        if ( _condition.value === condition.value ){
                            exist = true;
                        }
                    }
                }
            });
            return ( exist === false ) ? true : false;
        },

        // On supprime une condition au section
        deleteCondition: function ( condition ){
            var data = this.getConditions();
            var new_conditions = [];
            var old_conditions = [];
            data.conditions.forEach(function(element) {
                if ( element.champ === condition.champ ){
                    if ( element.operator === condition.operator ){
                        if ( element.value !== condition.value ){
                            new_conditions.push(element);
                        }
                    }else{
                        new_conditions.push(element);
                    }
                }else{
                    new_conditions.push(element);
                }
            });
            var old_conditions = data.conditions;
            data.conditions = new_conditions;
            $("#g-section-form-conditions").val( JSON.stringify(data).utf8ToB64() );
            return ( Object.getLength(old_conditions) !== Object.getLength(new_conditions) ) ? true : false;
        },

        // Retourne un array des conditions du section
        getConditions: function (){
            var conditions = { verified: "all",  visible: 1, modifiable: 1, conditions: [], type_profil: [] };
            var conditions_encoded = $("#g-section-form-conditions").val();
            if (  conditions_encoded !== undefined && !conditions_encoded.isEmpty() ){
                var conditions = JSON.parse(conditions_encoded.b64ToUtf8());  
            }
            return conditions;
        },
        
    }
})(jQuery,Champ);