
var Setting = (function($) {

    return {

        /**
         * Fonction qui 
         *
         *
         * @return {void} 
        */
        setSyncAgentUsager: function(){
            $( "#sync_agent_usager_btn" ).click(function() {
                if($('#agent').attr('data-modified') == 'true'){
                   Setting.syncVueAlert('agent');
                }else{
                    Setting.syncVueConfim('agent');
                }
            });
        },

        /**
         * Fonction qui 
         *
         *
         * @return {void} 
        */
         setSyncUsagerAgent: function(){
            $( "#sync_usager_agent_btn" ).click(function() {
                if($('#usager').attr('data-modified') == 'true'){
                   Setting.syncVueAlert('usager');
                }else{
                    Setting.syncVueConfim('usager');
                }
            });
        },

        setSyncUsagerPartenaire: function(){
            $("#sync_usager_partenaire_btn").click(function() {
                if($('#usager').attr('data-modified') == 'true'){
                   Setting.syncVueAlert('usager');
                }else{
                    Setting.syncVueConfim('partenaire');
                }
            });
        },

        /**
        * Fonction qui 
        *
        *
        * @return {void} 
        */
        syncVueConfim: function(type) {

            var confirm_template = Setting.getConfirmTemplate(type);

            $.confirm({
                title: false,
                content: confirm_template,
                closeIcon: false,
                confirmButton: false,
                columnClass: 'col-md-6 col-md-offset-3',
                buttons: {
                    oui: {
                        text: 'Oui',
                        btnClass: 'g-page-btn-back',
                        keys: ['enter', 'shift'],
                        action: function(){
                            this.buttons.oui.setText('En cours...'); 
                            this.buttons.oui.disable();
                            Setting.syncVue(type ,this);
                            return false;
                        },
                    },
                    non: {
                        text: 'Non',
                        btnClass: 'g-page-btn-back',
                        action: function(){}
                    },
                    ok: {
                        text: 'Ok',
                        isHidden: true,
                        btnClass: 'g-page-btn-back',
                        action: function(){
                            location.reload();
                        }
                    },
                },
            });

        },

        /**
        * Fonction qui 
        *
        *
        * @return {void} 
        */
        getConfirmTemplate: function( type ) {

            var confirm_title = ( type === "agent" ) ? "la vue <strong>CRM</strong> vers la vue <strong>internet</strong>" : (( type === "usager" ) ? "la vue <strong>internet</strong> vers la vue <strong>CRM</strong>" : "la vue <strong>internet</strong> vers la vue <strong>partenaire</strong>");
            var origine = ( type === "agent" ) ? "CRM" : "internet";
            var destination = ( type === "agent" ) ? "internet" : (( type === "partenaire" ) ? "partenaire" : "CRM");
      
            var confirm_content = '<div style="overflow: hidden;" >';
            confirm_content +=          '<div class="row" style="">' ;
            confirm_content +=              '<div class="col-md-12" style="" >';
            confirm_content +=                  `<h3 id="confirm-message" data-origine="${origine}" data-destination="${destination}" style="font-size: 15px;font-weight: normal;">Voulez-vous réellement synchroniser ${confirm_title} ?</h3>`;
            confirm_content +=              '</div>';
            confirm_content +=          '</div>';
            confirm_content += '</div>';
            return confirm_content;
        },

        /**
        * Fonction qui envoi initialise la modale pour la synchronisation si la vue n'est pas sauvegardé
        *
        *
        * @return {void} 
        */
        syncVueAlert: function(type) {

            var alert_template = Setting.getAlertTemplate(type);

            $.confirm({
                title: false,
                content: alert_template,
                closeIcon: false,
                confirmButton: false,
                columnClass: 'col-md-6 col-md-offset-3',
                buttons: {
                    fermer: {
                        text: 'Fermer',
                        btnClass: 'g-page-btn-back',
                        action: function(){}
                    },
                },
            });

        },

        /**
        * 
        * Fonction qui prépare le template de la modale pour la synchronisation si la vue n'est pas sauvegardé
        *
        * @return {void} 
        */
        getAlertTemplate: function( type ) {

            var origine = ( type === "agent" ) ? "CRM" : "internet";
      
            var alert_content = '<div style="overflow: hidden;" >';
            alert_content +=          '<div class="row" style="">' ;
            alert_content +=              '<div class="col-md-12" style="" >';
            alert_content +=                  `<h3 id="alert-message" style="font-size: 15px;font-weight: normal;">Veuillez sauvegarder la vue <strong>${origine}</strong> avant de continuer!</h3>`;
            alert_content +=              '</div>';
            alert_content +=          '</div>';
            alert_content += '</div>';
            return alert_content;
        },

        /**
        * Fonction qui 
        *
        *
        * @return {void} 
        */
        syncVue: function(type, confirm) {

            const vue_destination = (type === "agent") ? $(`#usager`) : ((type === "partenaire") ? $(`#partenaire`) : $(`#agent`));
            var data_source = (type === "partenaire") ? "usager" : type;

            // On récupere les onglets de la vue source 
            var data_vue_source = this.getDataVue( $(`#${data_source}`) );

            // On supprime les onglets de la vue destination ( Base de données )
            // On crée les onglets de la vue source dans la vue destination ( Base de données )
            this.replaceVue( vue_destination, data_vue_source, confirm );
           
        },

        /**
        * Fonction qui 
        *
        *
        * @return {void} 
        */
        replaceVue: function( vue_destination, vue_source_data, confirm ) {

            var query = OdeQueries.getAjaxActionQuery();
            query.setModule('OPS_generateur_vue');
            query.setAction("replace");
            query.setPostData({ id: vue_destination.attr("data-id"), data: vue_source_data });

            loading = function(){};
    
            callBack = function(){
                if ( this.statut === true ){
                    $("#confirm-message").text(`La synchronisation de la vue ${$("#confirm-message").attr("data-origine")} vers la vue ${$("#confirm-message").attr("data-destination")} a été effectué`)
                    confirm.buttons.ok.show();
                    confirm.buttons.oui.hide();
                    confirm.buttons.non.hide();
                } else {
                    confirm.buttons.oui.setText('Erreur'); 
                }
            };

            OdeAjax.getByAction( query, loading, callBack );
        },

        /**
        * Fonction qui 
        *
        *
        * @return {void} 
        */
         getDataVue: function( vue ) {
 
            var data_vue = {};
            vue.find($("[role=tabpanel]")).each(function() {
                var data_onglet = {};
                data_onglet["nom"] = $(this).attr("data-nom");
                data_onglet["libelle"] = $(this).attr("data-libelle");
                data_onglet["ordre"] = $(this).attr("data-ordre");
                data_onglet["cle"] = $(this).attr("data-cle");
                data_onglet["conditions"] = $(this).attr("data-conditions");
                data_onglet["lignes"] = [];
                $(this).find($("[role=onglet-ligne]")).each(function() {
                    if ( $(this).attr("data-layout") === "section" ) {
                        var data_ligne = {
                            type: "section",
                            title: $(this).find("input").val(),
                            conditions: $(this).find($("[role=section-title]")).attr("data-conditions")
                        };
                    } else {
                        var data_ligne = {
                            type: "ligne_double_champ",
                            champs: []
                        };
                        $(this).find($("[role=champ-container]")).each(function() {
                            if ( $(this).find($("[role=list-champ]")).length > 0 ){
                                var data_champ = {
                                    nom: $(this).find($("[role=list-champ]")).attr("data-nom"),
                                    libelle: $(this).find($("[role=list-champ]")).attr("data-libelle"),
                                    type: $(this).find($("[role=list-champ]")).attr("data-type"),
                                    obligatoire: $(this).find($("[role=list-champ]")).attr("data-obligatoire"),
                                    ineditable: $(this).find($("[role=list-champ]")).attr("data-ineditable"),
                                    aide: $(this).find($("[role=list-champ]")).attr("data-aide"),
                                    defaut: $(this).find($("[role=list-champ]")).attr("data-defaut"),
                                    description: $(this).find($("[role=list-champ]")).attr("data-description"),
                                    params: $(this).find($("[role=list-champ]")).attr("data-params"),
                                    conditions: $(this).find($("[role=list-champ]")).attr("data-conditions"),
                                    modifiable: $(this).find($("[role=list-champ]")).attr("data-modifiable")
                                };
                            }else{
                                var data_champ = {};
                            }
                            data_ligne.champs.push(data_champ);
                        });
                    }

                    data_onglet["lignes"].push(data_ligne);
                });
                data_vue[$(this).attr("data-id")] = data_onglet;
            });
            
            return data_vue;
        },

    }
    
})(jQuery);

