<?php

namespace ODE\Generateur\Factory;

class OdeFieldFactory
{
    const FIELDS_PATH = "custom/include/Ode/Generateur/Field";
    const FIELDS_NAMESPACE = 'ODE\\Generateur\\Field\\';
    private $factory;
    public $bean;
    public $editable;
    public $donnees;
    public $champs;

    function __construct($bean_dossier = null, $editable = false, $donnees = [])
    {
        $this->champs = [];
        $this->bean = $bean_dossier;
        $this->editable = $editable;
        $this->donnees = $donnees;
        $this->default_html = $this->getDefaultHtml();
        $this->factory = $this->initFieldFactory();
    }

    function initFieldFactory()
    {

        $factory = array();
        if (is_dir(OdeFieldFactory::FIELDS_PATH)) {
            $fields_folder = array_diff(scandir(OdeFieldFactory::FIELDS_PATH), array('.', '..', 'tpls','js'));
            foreach ($fields_folder as $file_name) {
                if( end( explode('.', $file_name) ) == 'php')
                {
                    $class_name = OdeFieldFactory::FIELDS_NAMESPACE . str_replace('.php', '', $file_name);
                    $factory[strtolower(str_replace('Ode', '', str_replace('.php', '', $file_name)))] = new $class_name($this->editable, $this->bean, $this->donnees);
                }
            }
        } else {
            $GLOBALS['log']->fatal(" OdeFieldFactory :: initFieldFactory => Erreur initialisation des classes types de champs");
        }

        return $factory;
    }

    /**
     * @access private
     * @name getValueChamp()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    function getHtml($champ)
    {
        $value = $this->getValueChamp($champ['name'], $champ['description']);

        if (array_key_exists($champ['name'], $this->champs)) {
            $champ['duplicate'] = $this->champs[$champ['name']];
            $this->champs[$champ['name']]++;
        } else {
            $champ['duplicate'] = 0;
            $this->champs[$champ['name']] = 0;
        }

        if (array_key_exists($champ["type"], $this->factory)) {
            $html = $this->factory[$champ["type"]]->getHtml($champ, $value);
        }
        return (isset($html) && !empty($html)) ? $html : $this->default_html;
    }

    /**
     * @access private
     * @name getValueChamp()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    function getValueChamp($champ, $description)
    {
        return ($description == "basic") ? $this->getValueChampBasic($champ) : $this->getValueChampCustom($champ);
    }

    /**
     * @access private
     * @name getValueChampBasic()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getValueChampBasic($champ)
    {
        return (isset($this->bean->$champ)) ? $this->bean->$champ : false;
    }

    /**
     * @access private
     * @name getValueChampCustom()
     * Fonction qui génere les lignes d'un onglet
     *
     *  @param array            $onglet: les informations de l'onglet sous forme de tableau
     *  @return string      $lignes: retour les lignes et les champs qu'ils contiennent sous forme html 
     */
    private function getValueChampCustom($champ)
    {
        $value = false;
        $champs_custom = (isset($this->bean->champs_custom) && !empty($this->bean->champs_custom)) ? json_decode(base64_decode($this->bean->champs_custom), true) : array();

        if (is_array($champs_custom) && count($champs_custom) > 0) {
            if (array_key_exists($champ, $champs_custom) === true) {
                if(is_array($champs_custom[$champ])){
                    $value = htmlspecialchars($champs_custom[$champ]['name'], ENT_COMPAT);
                }else{
                    $value = htmlspecialchars($champs_custom[$champ], ENT_COMPAT);
                }
            }
        }
        return $value;
    }

    private function getDefaultHtml()
    {
        return '<input type="text" value="erreur" />';
    }

    private function getConditions($champ)
    {
        return (!empty($champ["conditions"])) ? $champ["conditions"] : [];
    }

    /**
     * @access public
     * @name getChampPdfValue()
     * xxxx
     *
     *  @param array            $xxxx
     *  @return string          $xxx
     */
    public function getChampPdfValue($champ)
    {
        $value_bdd = $this->getValueChamp($champ['name'], $champ['description']);
        $type = $champ["type"];
        return (array_key_exists($type, $this->factory)) ? $this->factory[$type]->getPdfValue($champ, $value_bdd) : "";
    }

    public static function getFieldLanguage(){

        if (!is_dir(OdeFieldFactory::FIELDS_PATH)) return [];

        $folder_files = array_diff(scandir(OdeFieldFactory::FIELDS_PATH), array('.', '..', 'tpls','js'));
        if (!is_array($folder_files) || count($folder_files) === 0) return [];

        $languages = [];
        foreach ($folder_files as $file_name) {
            if( end( explode('.', $file_name) ) == 'php')
            {
                $class_name = OdeFieldFactory::FIELDS_NAMESPACE . str_replace('.php', '', $file_name);
                if ( method_exists($class_name,'getLibelle') ) {
                    $languages[strtolower(str_replace('Ode', '', str_replace('.php', '', $file_name)))] = $class_name::getLibelle();
                } else {
                    $skip_class_names = [
                        'ODE\Generateur\Field\OdeListeChoixMulti',
                        'ODE\Generateur\Field\OdeListeChoixSimple'
                    ];
                    if ( !in_array($class_name,$skip_class_names) ) {
                        $GLOBALS['log']->fatal("OdeFieldFactory::getFieldLanguage La fonction getLibelle n'existe pas dans la classe ".print_r($class_name,true)); 
                    }
                }
            }
        }

        return $languages;
    }
    public static function getFieldCreateButton(){

        if (!is_dir(OdeFieldFactory::FIELDS_PATH)) return [];

        $folder_files = array_diff(scandir(OdeFieldFactory::FIELDS_PATH), array('.', '..', 'tpls','js'));
        if (!is_array($folder_files) || count($folder_files) === 0) return [];

        $liste_buttons = [];
        foreach ($folder_files as $file_name) {
            if( end( explode('.', $file_name) ) == 'php')
            {
                $class_name = OdeFieldFactory::FIELDS_NAMESPACE . str_replace('.php', '', $file_name);
                if ( method_exists($class_name,'getCreateButton') ) {
                    $creation_button = $class_name::getCreateButton();
                    if ( $creation_button ) {
                        $liste_buttons[strtolower(str_replace('Ode', '', str_replace('.php', '', $file_name)))] = $creation_button;
                    }
                } else {
                    $skip_class_names = [
                        'ODE\Generateur\Field\OdeListeChoixMulti',
                        'ODE\Generateur\Field\OdeListeChoixSimple'
                    ];
                    if ( !in_array($class_name,$skip_class_names) ) {
                        $GLOBALS['log']->fatal("OdeFieldFactory::getFieldCreateButton La fonction getCreateButton n'existe pas dans la classe ".print_r($class_name,true)); 
                    }
                }
            }
        }
        # On trie le tableau par libellé
        uasort($liste_buttons, function($btn1, $btn2) {return strcmp($btn1->libelle, $btn2->libelle);});

        return $liste_buttons;
    }

    public function getChampValueBDD($type, $value)
    {
        return array_key_exists($type, $this->factory) ? $this->factory[$type]->getBDDValue($value) :false;
    }

    public function getChampDefautValue($champ)
    {
        if($champ['type'] == 'nombre'){
            $params = json_decode( base64_decode( $champ['params'] ) );
            $default = $this->factory[$champ['type']]->getFieldDefautValue($champ["defaut"],$params->decimal);
        }else{
            $default = $this->factory[$champ['type']]->getFieldDefautValue($champ["defaut"]);
        }
        return (!empty($default))? $default : "";
    }

    /**
     * @access public
     * @name getChampTableauValue()
     * xxxx
     *
     *  @param array            $xxxx
     *  @return array          $xxx
     */
    public function getChampTableauValue($champ)
    {
        $value_bdd = $this->getValueChamp($champ['name'], $champ['description']);
        $type = $champ["type"];
        $valeur = array();

        if(array_key_exists($type, $this->factory)){
            $valeur['params'] =  $this->factory[$type]->getFieldDefautValue($champ["params"]);
            $valeur['valeurs'] =  $this->factory[$type]->getFieldValue($value_bdd);
            return $valeur;
        }
        return '';
    }
}
