<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeDomiciliation extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/domiciliation.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {

        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/domiciliation.tpl");

        return $field_label . $field_html;

    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? html_entity_decode($value_bdd) : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        return (!empty($value_defaut)) ? html_entity_decode($value_defaut) : "";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return (!empty($value)) ? html_entity_decode($value) : "";
    }
}
