<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use BeanFactory;

class OdeFile extends OdeField
{

    private $config;
    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     *
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getFileConfig($params)
    {
        global $sugar_config;

        $fileParams = json_decode( base64_decode( $params ) );

        $accept = '';
        $max_size = 0;
        $multi_fichier = '';

        if(!empty($fileParams->attache))
        {
            $type_document_bean = BeanFactory::getBean('OPS_type_document', $fileParams->attache);
            $accept = str_replace('^', '', $type_document_bean->format);

            $mo = 5;
            if(!empty($type_document_bean->taille_limite))
            {
                $mo = intval($type_document_bean->taille_limite);
            }
            $max_size = $mo * pow(1024, 2);
            $multi_fichier = (($type_document_bean->multi_fichier) ? 'multiple' : '' );
        }


        $config = [
            "accept" => $accept,
            "max_size" => $max_size,
            "attache" => $fileParams->attache,
            "multiple" => $multi_fichier,
            "path" => $sugar_config['ops_justificatif']['chemin'],
        ];
        return $config;
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // On récupere la valeur à afficher formatée
        $custom = json_decode(base64_decode($this->bean->champs_custom));
        $config = $this->getFileConfig($champ['params']);
        $isTiers = false;

        $champ_params = json_decode(base64_decode($champ['params']));

        if(($custom->{$champ['name']} && !empty($custom->{$champ['name']}->content) && !empty($custom->{$champ['name']}->attache)) || ( !empty($this->bean->ops_personne_morale) && !empty($champ_params->attache) ) ){
            $justificatif_id = explode('/',$custom->{$champ['name']}->content);
            if($objTypeDocument->objet == 'tiers'){
                $href = 'index.php?entryPoint=download_justificatif&id='.$justificatif_id.'&type=OPS_justificatif';
            }else{
                $href = 'index.php?entryPoint=download_justificatif&id='.$justificatif_id[count($justificatif_id)-1].'&type=OPS_justificatif';
            }
        }
        $value = $this->getFieldValue($champ, $value_bdd);

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", '');
        $smarty->assign("disabled", ' disabled="disabled" ');
        $smarty->assign("value", $value);
        $smarty->assign("libelle_lien", $value);
        $smarty->assign("href", $href);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $smarty->assign("required", '');
            $smarty->assign("disabled", ' disabled="disabled" ');
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/input_text.tpl");
        }else if($value_bdd != 'undefined' &&  $value_bdd !=''){
            $smarty->assign("is_file", 'present');
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/file.tpl");
        }else{
            $smarty->assign("is_file", 'non_present');
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/file.tpl");
        }

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $db,$sugar_config, $app_list_strings;

        $custom = json_decode(base64_decode($this->bean->champs_custom));
        $isTiers = false;
        $champ_params = json_decode(base64_decode($champ['params']));


        // On récupere la valeur à afficher
        $value = $this->getFieldValue($champ,$value_bdd);
        $config = $this->getFileConfig($champ['params']);
        $required = (isset($champ['obligatoire']) && $champ['obligatoire'] == 1) ? ' required="true" ' : '';
        $disabled = ($champ['ineditable'] == 0) ? "" : " disabled ";
        $background = ($champ['ineditable'] == 0) ? 'background: #c3e7fd;' : 'background: #F8F8F8;';


        // On initialise le bloc HTML « Fichier préalablement enregistré et associé » :
        $file_block_saved = '';
        $pre_selected_related_pj_id = "";
        if(!empty($custom->{$champ['name']})){

            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $file_block_saved  = '<span data-content="'.$custom->{$champ['name']}->content.'" data-name="'.$champ['name'].'" data-file-name="'.$custom->{$champ['name']}->name.'" data-attache="'.$custom->{$champ['name']}->attache.'" data-size="'.$custom->{$champ['name']}->size.'" data-type="'.$custom->{$champ['name']}->type.'">';
                $file_block_saved .= '<span><em>Document déjà associé :</em> <i data-role="clear-related-file" class="fas fa-times" data-avia-tooltip="Retirer pour choisir un nouveau document..." style="color: var( --main_color_primary );padding: 0.25rem;height: 1.5rem;width: 1.5rem;border-radius: 2rem;cursor: pointer;background: var( --main_color_border );line-height: 1rem;text-align: center;" data-name="' . $champ["name"] . '" ></i></span>';
                $file_block_saved .= '<em>'. $custom->{$champ['name']}->name .'</em>';
                $file_block_saved .= '</span>';

                // Detection et extraction de l'id de la PJ pré-enregistrée/associée
                if( preg_match_all("/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/si", $custom->{$champ['name']}->content, $matches) )
                {

                    // Construction correcte et concrète d'un chemin de PJ ?
                    if( isset($sugar_config['ops_justificatif']) && is_array($sugar_config['ops_justificatif'])
                     && isset($sugar_config['ops_justificatif']['chemin']) && !empty($sugar_config['ops_justificatif']['chemin'])
                     && sizeof($matches[0]) == 2 /* UUID Dossier/PersonneMoraleID  & UUID DocPJ */
                     && $custom->{$champ['name']}->content == $sugar_config['ops_justificatif']['chemin']."/".$matches[0][0].'/'.$matches[0][1] )
                    {
                        // Ceci est un chemin d'un PJ existante - cas réutilisation ou pré-enregistrée
                        $pre_selected_related_pj_id = $matches[0][1];
                    }

                }

            }else{
                $file_block_saved = '<span style="margin-top: 6px;display: inline-flex;margin-left: 2px;" data-content="'.$custom->{$champ['name']}->content.'" data-name="'.$custom->{$champ['name']}->name.'" data-attache="'.$custom->{$champ['name']}->attache.'" data-size="'.$custom->{$champ['name']}->size.'" data-type="'.$custom->{$champ['name']}->type.'">'.$custom->{$champ['name']}->name.'</span>';
            }

        }else{
            
            // Only Front.
            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $file_block_saved .= '<span data-content data-name></span>';
            }

        }


        // Création du sélecteur si nécessaire
        $selectJustificatif = '';

        if($this->donnees['vue']['creation'] && (!empty($this->donnees['personne_morale']) || !empty($this->donnees['ops_personne_morale']))){
            $personneMoraleId = $this->donnees['personne_morale'];
            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $personneMoraleId = $this->donnees['ops_personne_morale'];
            }
            $typeDocumentObj = BeanFactory::getBean('OPS_type_document',$champ_params->attache);
            if($typeDocumentObj->objet == 'tiers'){

                $justificatifs = array();

                $sql = "SELECT ops_justificatif.id, ops_justificatif.document_name ,ops_justificatif.filename, ops_justificatif.file_mime_type FROM `ops_justificatif` 
                        INNER JOIN ops_personne_morale_ops_justificatif ON ops_justificatif.id = ops_personne_morale_ops_justificatif.ops_justificatif_id
                        INNER JOIN ops_type_document_ops_justificatif ON ops_justificatif.id = ops_type_document_ops_justificatif.ops_justificatif_id
                        WHERE ops_justificatif.statut IN ('etude','valide','reetude') AND ops_personne_morale_ops_justificatif.ops_personne_morale_id = '".$personneMoraleId."' AND ops_type_document_ops_justificatif.ops_type_document_id = '".$champ_params->attache."' AND ops_justificatif.deleted = 0 AND ops_personne_morale_ops_justificatif.deleted = 0 AND ops_type_document_ops_justificatif.deleted = 0";
                $result = $db->query($sql);
                while ($row = $db->fetchByAssoc($result)) {
                    $justificatifs[] = $row;
                }

                if(!empty($justificatifs)){
                    $selectJustificatif = '<select data-name="'.$champ["name"].'_select" style="width: 100%;margin-top: 5px;"> <option value=""></option>';
                    foreach ($justificatifs as $key => $justificatif) {
                        $dataJsonArray = array();
                        $chemin = $sugar_config['ops_justificatif']['chemin']."/".$personneMoraleId.'/'.$justificatif['id'];

                        // Présélectionne et identifie l'option correspond au justificatif préalablement associé.
                        $extra = '';
                        $char  = '';
                        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                            if( $pre_selected_related_pj_id == $justificatif['id'] ){
                                $extra = ' selected="selected" data-selection="1" ';
                                $char  = '✓  ';
                            }
                        }

                        $dataJsonArray['content'] = $chemin;
                        $dataJsonArray['name'] = $justificatif['filename'];
                        $dataJsonArray['size'] = filesize($chemin);
                        $dataJsonArray['type'] = $justificatif['file_mime_type'];
                        $dataJsonArray['attache'] = $champ_params->attache;

                        $dataJson = base64_encode(json_encode($dataJsonArray));

                        $selectJustificatif .= '<option value="'.$justificatif['id'].'" data-file="'.$dataJson.'" '.$extra.'>'.$char. $justificatif['document_name'].'</option>';
                    }
                    $selectJustificatif .= '</select>';
                }
            }
        }


        // On initialise le bloc HTML « Fichier préalablement enregistré et associé » :
        $file_block_selector = '';
        if( !empty($selectJustificatif) ){

            if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                $file_block_selector  = '<span data-selector="data-selector">';
                $file_block_selector .= '<span>Réutiliser un document déjà déposé : <i data-role="clear-selected-file" class="fas fa-times" data-avia-tooltip="Préférer le choix d\'un nouveau document..." style="color: var( --main_color_primary );padding: 0.25rem;height: 1.5rem;width: 1.5rem;border-radius: 2rem;cursor: pointer;background: var( --main_color_border );line-height: 1rem;text-align: center;" data-name="' . $champ["name"] . '" ></i></span>';
                $file_block_selector .= $selectJustificatif;
                $file_block_selector .= '</span>';

            }else{
                $file_block_selector = $selectJustificatif;
            }

        }


        // On initialise le bloc HTML « Fichier préalablement enregistré et associé » :
        $file_block_browse = '';
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $file_block_browse  = '<span data-browse="data-browse">';
            $file_block_browse .= '<span>Sélectionner un nouveau document :  <i data-role="clear-browsed-file" class="fas fa-times" data-avia-tooltip="Préférer un document déjà déposé ou revenir à la sélection..." style="color: var( --main_color_primary );padding: 0.25rem;height: 1.5rem;width: 1.5rem;border-radius: 2rem;cursor: pointer;background: var( --main_color_border );line-height: 1rem;text-align: center;" data-name="' . $champ["name"] . '" ></i></span>';
            $file_block_browse .= '<input data-role="champ-formulaire" data-type-field="file" data-attache="' . $config["attache"] . '" data-max-size="' . $config["max_size"] . '" data-name="' . $champ["name"] . '" data-conditions="' . $champ["conditions"] . '" type="file" ' . $config["multiple"] . ' accept="' . $config["accept"] . '"  ' . $required . $disabled . ' />';
            $file_block_browse .= '</span>';
        }else{
            $file_block_browse = '<input data-role="champ-formulaire" data-type-field="file" data-attache="' . $config["attache"] . '" data-max-size="' . $config["max_size"] . '" data-name="' . $champ["name"] . '" data-conditions="' . $champ["conditions"] . '" type="file" ' . $config["multiple"] . ' accept="' . $config["accept"] . '"  ' . $required . $disabled . ' />';
        }




        $field_html = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html .= '<div class="col-md-8">';
        }else{
            $field_html .= '<div class="col-md-7">';
        }
        $field_html .=  $file_block_saved;    // Pré enregistré et associé
        $field_html .=  $file_block_selector; // Sélecteur de fichier déjà existant
        $field_html .=  $file_block_browse;   // Champ parcourir
        $field_html .= '</div>';


        if($this->donnees["vue"]["type"] == 'agent'){
            $field_html .= '<div class="col-md-1">';
            $field_html .=      '<i data-role="clear-file" class="fas fa-times" style="color:red;" data-name="' . $champ["name"] . '" ></i>';
            $field_html .= '</div>';

            $field_html .= '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/Generateur/Field/js/OdeFile.js?='.time().'"></script>';
        }

        return $field_html;
    }

    public function getFieldValue($champ, $value_bdd)
    {
        if($value_bdd == 'undefined') $value_bdd ='';
        return (!empty($value_bdd)) ? $value_bdd : "-- pas d'élément --";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return "Fichier : " . $value;
    }

    public static function getLibelle()
    {
        return "Justificatif";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeFile::getLibelle(),
            'icon' => 'fas fa-file-alt',
            'route' => '/champs/?type=file',
            'attributes' => '',
        ];
    }
}