<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
/*
        $GLOBALS['log']->fatal(" OdeListeChoixMulti :: getEditableField() =>  " . $champ['name'] . print_r(array(
            "liste" => $liste,
            "value" => $value,
        ), true));
        */

class OdeListeChoixSimple
{

    var $editable;
    var $bean;

    /**
     * @access public
     * @name __construct de la classe OdeListeChoixSimple
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    function __construct($editable = false, $bean = null)
    {
        $this->bean = $bean;
        $this->editable = $editable;
    }

    /**
     * @access public
     * @name getHtml()
     * Fonction qui renvoie le code HTML à afficher 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getHtml($champ, $value)
    {
        return ($this->editable === false) ? $this->getIneditableField($champ, $value) : $this->getEditableField($champ, $value);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    private function getIneditableField($champ, $value_bdd)
    {

        $value = (!empty($value_bdd)) ? $value_bdd : "";
        $json_formated = base64_decode($champ['params']);
        $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);
        if ($retour_json_to_array['statut'] == "ok") {
            $params = $retour_json_to_array['data'];
            if (!empty($params['liste'])) {
                $liste = $params['liste'];
                if (is_array($liste) && count($liste) > 0) {
                    if (array_key_exists($value, $liste)) {
                        $liste_value = $liste[$value];
                    } else {
                        $liste_value = "";
                    }
                }
            }
        }
        if (!empty($champ["name"])) {
            $html = '<input class="ode_input_hidden" id="value_champ_' . $champ["name"] . '" style="display:block;" value="' . $liste_value . '" disabled/>';
        } else {
            $html = $this->getErreurField("Erreur d'initialisation");
        }
        return $html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    private function getEditableField($champ, $value_bdd)
    {
        $value = (!empty($value_bdd)) ? html_entity_decode($value_bdd) : "";
        $required = ($champ['obligatoire'] == 1) ? 'required="true"' : '';
        $value_display = (!empty($value)) ? $value : "";
        $json_formated = base64_decode($champ['params']);
        $retour_json_to_array = OdeArrayHelper::jsonToArray($json_formated);
        if ($retour_json_to_array['statut'] == "ok") {
            $params = $retour_json_to_array['data'];
            if (!empty($params['liste'])) {
                $liste = $params['liste'];
            }
        }

        if (!empty($champ["name"])) {
            if (is_array($liste) && count($liste) > 0) {
                $html  = '<select role="champ-formulaire" data-conditions="' . $champ["conditions"] . '"  data-name="' . $champ["name"] . '" class="col-md-8" ' . $required . ' id="value_champ_' . $champ['name'] . '"';
                $html .=  ($champ['ineditable'] == 0) ? '>' : ' disabled >';
                $html .= '<option value=""></option>';
                foreach ($liste as $index => $valeur) {
                    $selected = ($index == $value_display) ? " selected" : "";
                    $html .= '<option value="' . $index . '"  ' . $selected . '>' . $valeur . '</option>';
                }
                $html .= '</select>';
            }
        } else {
            $html = $this->getErreurField("Erreur d'initialisation");
        }

        return $html;
    }

    /**
     * @access private
     * @name getErreurField()
     *
     *  @param string			$message: Le message d'erreur
     *  @return string          $html: champ de type input avec le message d'erreur
     */
    private function getErreurField($message = "")
    {
        $html = '<input type="text" value="' . $message . '" style="display: block;color: #f08377;background: #f8f8f8 !important;border: 1px solid red;" class="ode_input_hidden col-md-8">';
        return $html;
    }
}
