<?php

namespace ODE\Generateur\Field;

use ODE\Helper\OdeArrayHelper;
use ODE\Model\IndividuModel;
use ODE\Model\ExerciceModel;
use ODE\Model\DossierModel;
use ODE\Model\PersonneMoraleModel;
use ODE\Model\ActivitesModel;
use ODE\Model\NiveauxModel;
use ODE\Model\EtablissementsModel;
use ODE\Model\InscriptionsModel;

use Sugar_Smarty;
use BeanFactory;

class OdeRelation extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // 4/12eme de row (label)
        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        // On récupere la valeur à afficher
        $module = $this->getModuleField($champ);

        // On récupere les valeurs du champ relation
        $values = $this->getValueField($champ["name"]);


        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $value = (count($values) === 1) ? $values[0]["name"] : "";
            $smarty = new Sugar_Smarty();
            $smarty->assign("name", $name);
            $smarty->assign("required", $required);
            $smarty->assign("disabled", ' disabled="disabled" ');
            $smarty->assign("value", $value);
            $smarty->assign("conditions", $champ['conditions']);
            $smarty->assign("type", "text");
            $smarty->assign("aria", $champ["libelle"]);
            $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
        }else{
            if($champ["name"] == 'ops_dossier_id'){

                $value = (count($values) === 1) ? $values[0]["name"] : "";

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", ' disabled="disabled" ');
                $smarty->assign("value", $value);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("type", "text");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if($champ["name"] == 'ops_contrat_id'){

                $value = (count($values) === 1) ? $values[0]["name"] : "";

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", ' disabled="disabled" ');
                $smarty->assign("value", $value);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("type", "text");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if($champ["name"] == 'ops_sous_territoire_id'){

                $value = $values[0]["name"];

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", ' disabled="disabled" ');
                $smarty->assign("value", $value);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("type", "text");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if ($module['unique'] === 'unique' || $module['unique'] === 'multi' && count($values) < 2) {

                $field_html  = $field_label;
                $module_id   = (count($values) === 1) ? $values[0]["id"] : "";
                $module_name = (count($values) === 1) ? $values[0]["name"] : "";

                $field_html .=  '<div class="col-md-8 relation-detailview-dossier" role="display-relation">';
                if ($module['lien'] === "oui") {
                    $field_html .=      '<a href="index.php?module=' . $module["module_name"] . '&action=DetailView&record=' . $module_id . '">';
                } else {
                    $field_html .=      '<a style="color: #504f53; text-decoration: none;">';
                }
                $field_html .=              '<span class="sugar_field">' . $module_name . '</span>';
                $field_html .=          '</a>';
                $field_html .=  '</div>';
                $field_html .=  '<input aria-label="' . $champ["libelle"] . '"  data-role="champ-formulaire" data-type-field="relation" data-name="' . $champ["name"] . '" id="' . $this->getUniqueId() . '" data-module-name="' . $module["module_name"] . '" data-type="' . $module["type"] . '" data-unique="' . $module["unique"] . '" type="hidden" ' . $required . ' value="' . $module_id . '" data-conditions="' . $champ["conditions"] . '">';
            } else {
                $field_html  = $field_label;

                $field_html .=  '<div class="col-md-8 relation-multi-detailview-dossier" role="display-relation">';
                foreach ($values as $value) {
                    if ($module['lien'] === "oui") {
                        $field_html .=      '<a style="display: block;" href="index.php?module=' . $module["module_name"] . '&action=DetailView&record=' . $value["id"] . '">';
                    } else {
                        $field_html .=      '<a style="color: #504f53; text-decoration: none;display: block;">';
                    }
                    $field_html .=              '<span class="sugar_field">' . $value["name"] . '</span>';
                    $field_html .=          '</a>';
                }
                $field_html .=  '</div>';
                $field_html .=  '<input aria-label="' . $champ["libelle"] . '"  data-role="champ-formulaire" data-type-field="relation" data-name="' . $champ["name"] . '" id="' . $this->getUniqueId() . '" data-module-name="' . $module["module_name"] . '" data-type="' . $module["type"] . '" data-unique="' . $module["unique"] . '" type="hidden" ' . $required . ' value="' . $module_id . '" data-conditions="' . $champ["conditions"] . '">';
            }
        }

        if($this->donnees["vue"]["type"] == 'agent'){
            $field_html .= '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/Generateur/Field/js/OdeRelation.js?='.time().'"></script>';
        }

        return $field_html;
    }


    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        $value_display = "";
        // On récupere les valeurs du champ relation
        $enregistrements = $this->getValueField($champ["name"]);
        foreach ($enregistrements as $enregistrement) {
            if($enregistrement === end($enregistrements)){
                $value_display .= $enregistrement["name"];
            }else{
                $value_display .= $enregistrement["name"]." ";
            }
        }
        return (!empty($value_display)) ? html_entity_decode($value_display) : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        // On récupere la valeur à afficher
        $module = $this->getModuleField($champ);

        // On récupere les valeurs du champ relation
        $values = $this->getValueField($champ["name"]);

        if($module['unique'] == 'multi'){
            $multiParams = array(
                'name'          => $champ["name"],
                'module_name'   => $module['module_name'],
                'type'          => $module['type'],
                'unique'        => $module['unique'],
                'condition'     => $module['condition'],
                'id'            => $this->getUniqueId(),
            );
            $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"],$multiParams);
        }else{
            $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){

            if($champ["name"] == 'ops_dossier_id'){

                $options = $this->getListDossiers($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("view", "edit");
                $smarty->assign("type", "select");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if($champ["name"] == 'ops_contrat_id'){

                $options = $this->getlistContrat($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("aria", $champ["libelle"]);

                if(count($options) == 1){
                    $smarty->assign("view", "detail");
                    $smarty->assign("type", "select");
                    $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
                }else{
                    $smarty->assign("view", "edit");
                    $smarty->assign("type", "select");
                    $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
                }
            }
            else if($champ["name"] == 'ops_sous_territoire_id'){
                $options = $this->getListSousTerritoire($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("view", "edit");
                $smarty->assign("type", "select");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else{
                $value = (count($values) === 1) ? $values[0]["name"] : "";
                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", ' disabled="disabled" ');
                $smarty->assign("value", $value);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("type", "text");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
        } else {
            if($champ["name"] == 'ops_dossier_id'){

                $options = $this->getListDossiers($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("view", "edit");
                $smarty->assign("type", "select");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if($champ["name"] == 'ops_contrat_id'){

                $options = $this->getlistContrat($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("aria", $champ["libelle"]);

                if(count($options) == 1){
                    $smarty->assign("view", "detail");
                    $smarty->assign("type", "select");
                    $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
                }else{
                    $smarty->assign("view", "edit");
                    $smarty->assign("type", "select");
                    $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
                }
            }
            else if($champ["name"] == 'ops_sous_territoire_id'){
                $options = $this->getListSousTerritoire($champ, $module);

                $smarty = new Sugar_Smarty();
                $smarty->assign("name", $name);
                $smarty->assign("required", $required);
                $smarty->assign("disabled", $disabled);
                $smarty->assign("multiple", $multiple);
                $smarty->assign("options", $options);
                $smarty->assign("conditions", $champ['conditions']);
                $smarty->assign("view", "edit");
                $smarty->assign("type", "select");
                $smarty->assign("aria", $champ["libelle"]);
                $field_html = $field_label . $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/relation.tpl");
            }
            else if ($module['unique'] === 'unique' || $module['unique'] === 'multi' && count($values) < 2) {

                $module_id = (count($values) === 1) ? $values[0]["id"] : "";
                $module_name = (count($values) === 1) ? $values[0]["name"] : "";
                $field_html = $field_label;
                $field_html .= '<div class="col-md-8">';
                $field_html .=      '<div class="col-md-8">';
                $field_html .=          '<input type="text" role="display-relation" data-id="' . $module_id . '" id="' . $this->getUniqueId() . '" disabled class="relation-editview-dossier" value="' . $module_name . '">';
                $field_html .=      '</div>';
                $field_html .=      '<div class="col-md-3">';
                $field_html .=          '<span class="id-ff multiple">';
                $field_html .=              '<button role="select-relation" type="button" id="btn_statut_initial" title="Sélectionner" class="button firstChild" value="Sélectionner">';
                $field_html .=                  '<img src="themes/SuiteP/images/id-ff-select.png?v=9PUULME3DHwNvxEgZrpwig">';
                $field_html .=              '</button>';
                $field_html .=              '<button role="delete-relation" type="button" id="btn_clr_statut_initial" title="Clear Selection" class="button lastChild" value="Supprimer la selection">';
                $field_html .=                  '<img src="themes/SuiteP/images/id-ff-clear.png?v=9PUULME3DHwNvxEgZrpwig">';
                $field_html .=              '</button>';
                $field_html .=          '</span>';
                $field_html .=     '</div>';
                $field_html .= '</div>';
                $field_html .= '<input aria-label="' . $champ["libelle"] . '" data-role="champ-formulaire" data-type-field="relation" data-name="' . $champ["name"] . '" id="' . $this->getUniqueId() . '" data-module-name="' . $module["module_name"] . '" data-type="' . $module["type"] . '" data-unique="' . $module["unique"] . '" type="hidden" ' . $required . ' value="' . $module_id . '" data-conditions="' . $champ["conditions"] . '">';
            } else {
                $field_html = $field_label;
                $module_id = '';
                $first = 1;

                foreach($values as $value){
                    $style = ($first === 0)?'style="margin: 1% 0% 1% 33.4%;"':'';
                    $field_html .= '<div class="col-md-8" '.$style.'>';
                    $field_html .=      '<div class="col-md-8">';
                    $field_html .=          '<input type="text" role="display-relation" data-id="' . $value["id"] . '" id="' . $this->getUniqueId() . '" disabled class="relation-editview-dossier" value="' . $value["name"] . '">';
                    $field_html .=      '</div>';
                    $field_html .=      '<div class="col-md-3">';
                    $field_html .=          '<span class="id-ff multiple">';
                    $field_html .=              '<button role="select-relation" type="button" id="btn_statut_initial" title="Sélectionner" class="button firstChild" value="Sélectionner">';
                    $field_html .=                  '<img src="themes/SuiteP/images/id-ff-select.png?v=9PUULME3DHwNvxEgZrpwig">';
                    $field_html .=              '</button>';
                    $field_html .=              '<button role="delete-relation" type="button" id="btn_clr_statut_initial" title="Clear Selection" class="button lastChild" value="Supprimer la selection">';
                    $field_html .=                  '<img src="themes/SuiteP/images/id-ff-clear.png?v=9PUULME3DHwNvxEgZrpwig">';
                    $field_html .=              '</button>';
                    $field_html .=          '</span>';
                    $field_html .=     '</div>';
                    $field_html .= '</div>';
                    $module_id .= '|'.$value["id"];
                    $first = 0;
                }

                $field_html .= '<input aria-label="' . $champ["libelle"] . '"  data-role="champ-formulaire" data-type-field="relation" data-name="' . $champ["name"] . '" id="' . $this->getUniqueId() . '" data-module-name="' . $module["module_name"] . '" data-type="' . $module["type"] . '" data-unique="' . $module["unique"] . '" type="hidden" ' . $required . ' value="' . $module_id . '" data-conditions="' . $champ["conditions"] . '">';
            }
        }

        if($this->donnees["vue"]["type"] == 'agent'){
            $field_html .= '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/Generateur/Field/js/OdeRelation.js?='.time().'"></script>';
        }
    
        return $field_html;
    }

    public function getListDossiers($champ, $module){
        
        global $db;

        $value = $this->getValueField($champ['name']);
        if( is_array($value)){
            $value = $value[0]['id'];
        }
        $personneMoraleId = (!empty($this->bean->ops_personne_morale ))?$this->bean->ops_personne_morale :$this->donnees['personne_morale'];

        $innerIndividu = '';
        $whereIndividu = '';
        $wherePersonneMorale = '';
        if(!empty($personneMoraleId)){
            $wherePersonneMorale = " AND ops_dossier.ops_personne_morale = '" . $personneMoraleId . "'";
        }else{
            $innerIndividu = " INNER JOIN ops_individu_ops_dossier ON ops_dossier.id = ops_individu_ops_dossier.ops_dossier_id";
            $whereIndividu = " AND ops_individu_ops_dossier.deleted = 0 AND ops_individu_ops_dossier.ops_individu_id = '".$this->donnees['demandeur']['id']."'";
        }

        $sql = "SELECT DISTINCT ops_dossier.id, ops_dossier.num_dossier FROM ops_dossier 
        INNER JOIN ops_dispositif_ops_dossier ON ops_dossier.id = ops_dispositif_ops_dossier.ops_dossier_id
        INNER JOIN ops_dispositif ON ops_dispositif_ops_dossier.ops_dispositif_id = ops_dispositif.id
        ".$innerIndividu."
        WHERE ops_dossier.id != '" . $this->bean->id . "' AND ops_dossier.name != 'TEMP' AND ops_dossier.deleted = 0 AND ops_dispositif_ops_dossier.deleted = 0 AND ops_dispositif.deleted = 0 AND ops_dossier.cloture = 0 AND (ops_dispositif.publie = 'oui' OR ops_dispositif.publie = 'oui_si') 
        AND ops_dossier.canal != 'hors-compte'".$wherePersonneMorale.$whereIndividu."
        ORDER BY ops_dossier.num_dossier DESC";
        $result = $db->query($sql);

        $options = [];
        while ($row = $db->fetchByAssoc($result)) {
            $dossierBean = BeanFactory::getBean('OPS_dossier',$row['id']);
            $name = (!empty($dossierBean->libelle_dossier))?$dossierBean->num_dossier .' - '.$dossierBean->ops_dispositif_ops_dossier_name.' - '. $dossierBean->libelle_dossier:$dossierBean->num_dossier .' - '.$dossierBean->ops_dispositif_ops_dossier_name;

            if($dossierBean->brouillon == 'oui') $name .= ' (Brouillon)';

            $selectedDossier = ($dossierBean->id == $value)?' selected="selected" ':'';
            $options[$dossierBean->id] = [
                "libelle" => $name,
                "selected" => $selectedDossier
            ];
        }

        return $options;
    }

    public function getlistContrat($champ, $module){

        $personneMorale = (!empty($this->donnees['ops_personne_morale'] ))?$this->donnees['ops_personne_morale']:$this->donnees['personne_morale'];
        
        $personneMoraleId = (!empty($this->bean->ops_personne_morale ))?$this->bean->ops_personne_morale:$personneMorale;

        $beanContrat = BeanFactory::newBean('OPS_contrat');

        $where = ' ( ops_contrat.ops_personne_morale_commune_id = "'.$personneMoraleId.'" OR ops_contrat.ops_personne_morale_ccas_id  = "'.$personneMoraleId.'" ) AND ops_contrat.cloture  = 0';

        $contratList = $beanContrat->get_full_list('name',$where);

        if( !empty($this->bean->id) ){
            $this->bean->load_relationship('ops_contrat_ops_dossier');
            $contratId = $this->bean->ops_contrat_ops_dossier->get();
        }

        $options = [];
        foreach ($contratList as $contrat) 
        {
            $selectedContrat = (!empty($contratId[0]) && $contrat->id == $contratId[0])?' selected="selected" ':'';
            $options[$contrat->id] = [
                "libelle" => $contrat->name,
                "selected" => $selectedContrat
            ];
        }

        return $options;
    }

    public function getListSousTerritoire($champ,$module){

        $options = [];

        $beanSousTerritoire = BeanFactory::newBean('OPS_sous_territoire');
        $sousTerritoireList = $beanSousTerritoire->get_full_list('name');

        if( !empty($this->bean->id) ){
            $this->bean->load_relationship('ops_sous_territoire_ops_dossier');
            $sousTerritoireId = $this->bean->ops_sous_territoire_ops_dossier->get();
        }

        foreach ($sousTerritoireList as $sousTerritoire) 
        {
            $selectedSousTerritoire = (!empty($sousTerritoireId[0]) && $sousTerritoire->id == $sousTerritoireId[0])?' selected="selected" ':'';
            $options[$sousTerritoire->id] = [
                "libelle" => $sousTerritoire->name,
                "selected" => $selectedSousTerritoire
            ];
        }

        return $options;
    }

    public function getModuleField($champ)
    {

        $module = [];
        $params_decoded = OdeArrayHelper::jsonToArray(base64_decode($champ['params']));
        if ($params_decoded['statut'] == "ok") {
            $params =  $params_decoded['data'];
            if (!empty($champ["name"]) && $champ["name"] === "demandeur") {
                if (!empty($this->donnees["demandeur"]["type"])) {
                    foreach ($params["modules"] as $_module) {
                        if ($_module["name"] === $this->donnees["demandeur"]["type"]) {
                            $module = [
                                "module_name" => $_module["name"],
                                "relation_name" => $_module["relation"],
                                "unique" => $params["unique"],
                                "lien" => $params["lien"],
                                "type" => $params["type"]
                            ];
                        }
                    }
                }
            } else {
                $module = $params;
            }
        } else {
            $GLOBALS['log']->fatal(" OdeRelation :: getModuleField() =>  Erreur decodage params " . $params_decoded['data']);
        }
        return $module;
    }

    public function getValueField($name)
    {

        $values = [];
        if ($this->bean !== null) {
            switch ($name) {
                case "demandeur":
                    $values[] = [
                        "id" => $this->DossierModel->getDemandeurId(),
                        "name" => $this->DossierModel->getDemandeurName(),
                    ];
                    break;
                case "dispositif":
                    $values[] = [
                        "id" => $this->DossierModel->getDispositifId(),
                        "name" => $this->DossierModel->getDispositifName(),
                    ];
                    break;
                case "ops_campagne_id":
                    $values[] = [
                        "id" => $this->DossierModel->getCampagneId(),
                        "name" => $this->DossierModel->getCampagneName(),
                    ];
                    break;
                case "elus":
                    $values = $this->DossierModel->getElus();
                    break;
                case "reunions":
                    $values = $this->DossierModel->getReunions();
                    break;
                case "commissions":
                    $values = $this->DossierModel->getCommissions();
                    break;
                case "assigned_user_id":
                    $values[] = [
                        "id" => $this->bean->assigned_user_id,
                        "name" => $this->bean->assigned_user_name,
                    ];
                    break;
                case "created_by":
                    $values[] = [
                        "id" => $this->bean->created_by,
                        "name" => $this->bean->created_by_name,
                    ];
                    break;
                case "modified_user_id":
                    $values[] = [
                        "id" => $this->bean->modified_user_id,
                        "name" => $this->bean->modified_by_name,
                    ];
                    break;
                case "ops_exercice_id":
                    $exerciceModel = new ExerciceModel($this->bean->ops_exercice_id);
                    $values[] = [
                        "id" => $this->bean->ops_exercice_id,
                        "name" => $exerciceModel->getName(),
                    ];
                    break;
                case "ops_personne_individu":
                    $individuModel = new IndividuModel($this->bean->ops_personne_individu);
                    $values[] = [
                        "id" => $this->bean->ops_personne_individu,
                        "name" => $individuModel->getName(),
                    ];
                    break;
                case "ops_individu3_id":
                    $individuModel = new IndividuModel($this->bean->ops_individu3_id);
                    $values[] = [
                        "id" => $this->bean->ops_individu3_id,
                        "name" => $individuModel->getName(),
                    ];
                    break;
                case "ops_individu4_id":
                    $individuModel = new IndividuModel($this->bean->ops_individu4_id);
                    $values[] = [
                        "id" => $this->bean->ops_individu4_id,
                        "name" => $individuModel->getName(),
                    ];
                    break;
                case "ops_individu5_id":
                    $individuModel = new IndividuModel($this->bean->ops_individu5_id);
                    $values[] = [
                        "id" => $this->bean->ops_individu5_id,
                        "name" => $individuModel->getName(),
                    ];
                    break;
                case "ops_individu6_id":
                    $individuModel = new IndividuModel($this->bean->ops_individu6_id);
                    $values[] = [
                        "id" => $this->bean->ops_individu6_id,
                        "name" => $individuModel->getName(),
                    ];
                    break;
                case "ops_personne_morale_id":
                    $values[] = [
                        "id" => $this->bean->ops_personne_morale_id,
                        "name" => DossierModel::getNameDemandeurByTypeAndId("OPS_personne_morale", $this->bean->ops_personne_morale_id),
                    ];
                    break;
                case "ope_enfants_id":
                    $values[] = [
                        "id" => $this->bean->ope_enfants_id,
                        "name" => DossierModel::getNameDemandeurByTypeAndId("OPE_enfants", $this->bean->ope_enfants_id),
                    ];
                    break;
                case "ope_activites_id":
                    $activitesModel = new ActivitesModel($this->bean->ope_activites_id);
                    $values[] = [
                        "id" => $this->bean->ope_activites_id,
                        "name" => $activitesModel->getName(),
                    ];
                    break;
                case "ope_niveaux_id":
                    $niveauxModel = new NiveauxModel($this->bean->ope_niveaux_id);
                    $values[] = [
                        "id" => $this->bean->ope_niveaux_id,
                        "name" => $niveauxModel->getName(),
                    ];
                    break;
                case "ope_etablissements_secteur_id":
                    $etablissementsModel = new EtablissementsModel($this->bean->ope_etablissements_secteur_id);
                    $values[] = [
                        "id" => $this->bean->ope_etablissements_secteur_id,
                        "name" => $etablissementsModel->getName(),
                    ];
                    break;
                case "ope_etablissements_affectation_id":
                    $etablissementsModel = new EtablissementsModel($this->bean->ope_etablissements_affectation_id);
                    $values[] = [
                        "id" => $this->bean->ope_etablissements_affectation_id,
                        "name" => $etablissementsModel->getName(),
                    ];
                    break;
                case "ope_etablissements_derogatoire_id":
                    $etablissementsModel = new EtablissementsModel($this->bean->ope_etablissements_derogatoire_id);
                    $values[] = [
                        "id" => $this->bean->ope_etablissements_derogatoire_id,
                        "name" => $etablissementsModel->getName(),
                    ];
                    break;
                case "ope_inscriptions_id":
                    $inscriptionsModel = new InscriptionsModel($this->bean->ope_inscriptions_id);
                    $values[] = [
                        "id" => $this->bean->ope_inscriptions_id,
                        "name" => $inscriptionsModel->getName(),
                    ];
                    break;
                    case "ops_dossier_id":
                        $values = $this->DossierModel->getDossiersLies();
                    break;
                    case "ops_contrat_id":
                        $values = $this->DossierModel->getContrats();
                    break;
                    case "ops_sous_territoire_id":
                        $values = $this->DossierModel->getSousTerritoire();
                    break;
                    case "opcl_actualite_id":
                        $actualite = BeanFactory::getBean('OPCL_actualites',$this->bean->opcl_actualite_id);
                        $values[] = [
                        "id" => $this->bean->opcl_actualite_id,
                        "name" => $actualite->name,
                    ];
                    break;
                    case "opcl_operation_id":
                        $operation = BeanFactory::getBean('OPCL_operations',$this->bean->opcl_operation_id);
                        $values[] = [
                        "id" => $this->bean->opcl_operation_id,
                        "name" => $operation->name,
                    ];
                    break;
                default:
                    break;
            }
        } else {

            if ($name === "demandeur") {
                // Dans le cadre de openenfance demandeur type === OPS_individu
                if (!empty($this->donnees["demandeur"]["type"]) && !empty($this->donnees["demandeur"]["id"])) {
                    $values[] = [
                        "id" => $this->donnees["demandeur"]["id"],
                        "name" => DossierModel::getNameDemandeurByTypeAndId($this->donnees["demandeur"]["type"], $this->donnees["demandeur"]["id"]),
                    ];
                }
            }

            if ($name === "ops_personne_morale_id") {
                // Dans le cadre de openenfance demandeur type === OPS_individu
                if (!empty($this->donnees["famille"]["id"])) {
                    $values[] = [
                        "id" => $this->donnees["famille"]["id"],
                        "name" => DossierModel::getNameDemandeurByTypeAndId("OPS_personne_morale", $this->donnees["famille"]["id"]),
                    ];
                }
            }

            if ($name === "ope_enfants_id") {
                // Dans le cadre de openenfance demandeur type === OPS_individu
                if (!empty($this->donnees["enfant"]["id"])) {
                    $values[] = [
                        "id" => $this->donnees["enfant"]["id"],
                        "name" => DossierModel::getNameDemandeurByTypeAndId("OPE_enfants", $this->donnees["enfant"]["id"]),
                    ];
                }
            }

            if ($name === "dispositif") {
                if (!empty($this->donnees["dispositif"]["id"]) && !empty($this->donnees["dispositif"]["name"])) {
                    $values[] = [
                        "id" => $this->donnees["dispositif"]["id"],
                        "name" => $this->donnees["dispositif"]["name"],
                    ];
                }
            }
        }

        return $values;
    }

    /**
     * @access private
     * @name getRelatedModuleTable()
     * Fonction qui génere l'affichage des champs de type relation
     *
     *  @param array            $champ: Champ de type "relation"
     *  @return string      $html: retourne la valeur du champ ( Format html )
     */
    private function getRelatedModuleTable($module_name, $relation_name, $unique)
    {

        $retour_enregistrements = array();
        if ($this->bean !== null) {
            $enregistrements =  $this->bean->get_linked_beans($relation_name, $module_name);
            if (is_array($enregistrements) && count($enregistrements) > 0) {
                if ($unique === true) {
                    if (!empty($enregistrements[0]->id) && !empty($enregistrements[0]->name)) {
                        $retour_enregistrements[0] = array(
                            "id" => $enregistrements[0]->id,
                            "name" => $enregistrements[0]->name,
                        );
                    }
                } else {
                    foreach ($enregistrements as $key => $enregistrement) {
                        if (!empty($enregistrements[$key]->id) && !empty($enregistrements[$key]->name)) {
                            $retour_enregistrements[$key] = array(
                                "id" => $enregistrements[$key]->id,
                                "name" => $enregistrements[$key]->name,
                            );
                        }
                    }
                }
            }
        }
        return $retour_enregistrements;
    }

    /**
     * @access private
     * @name getRelatedModuleParentID()
     * Fonction qui génere l'affichage des champs de type relation
     *
     *  @param array            $champ: Champ de type "relation"
     *  @return string      $html: retourne la valeur du champ ( Format html )
     */
    private function getRelatedModuleParentID($module_name, $enregistrement_id)
    {
        $enregistrement = array();
        if (in_array($module_name, $module_liste, TRUE)) {
            $obj_module = BeanFactory::getBean($module_name, $enregistrement_id);
            if (!empty($obj_module->id)) {
                $enregistrement[0] = array(
                    "id" => $obj_module->id,
                    "name" => $obj_module->name,
                );
            } else {
                if ($enregistrement_id == "1" || $enregistrement_id == 1) {
                    $enregistrement[0] = array(
                        "id" => "1",
                        "name" => "Administrator",
                    );
                }
            }
        } else {
            $GLOBALS['log']->fatal(" view.detail.php :: getRelatedModuleParentID() => Module $module_name non déclaré dans la liste des modules.");
        }
        return $enregistrement;
    }

    /**
     * @access private
     * @name getRelatedModule()
     * Fonction qui ... 
     *
     *  @param unknow          $_module_name: unknow
     *  @param unknow          $_relation_name: unknow
     *  @param unknow          $unique: unknow
     *  @param unknow          $type: unknow
     *  @param unknow          $condition: unknow
     *  @param unknow          $champ_value: unknow
     *  @return array       
     */
    private function getRelatedModule($_module_name, $_relation_name, $unique, $type, $condition, $champ_value)
    {

        $retour_enregistrements = array();

        if ($type == "table") {
            if (!empty($condition)) {
                if (!empty($this->bean->$condition)) {
                    foreach ($_module_name as $module) {
                        if ($module['value'] == $this->bean->$condition) {
                            $module_name = $module['name'];
                        }
                    }
                    foreach ($_relation_name as $relation) {
                        if ($relation['value'] == $this->bean->$condition) {
                            $relation_name = $relation['name'];
                        }
                    }
                    $retour_enregistrements = $this->getRelatedModuleTable($module_name, $relation_name, $unique);
                } else {
                    $GLOBALS['log']->fatal(" view.detail.php :: getRelatedModule() => champs référentiel le champ $condition du dossier est null ");
                }
            } else {
                $module_name = $_module_name;
                $relation_name = $_relation_name;
                $retour_enregistrements = $this->getRelatedModuleTable($_module_name, $_relation_name, $unique);
            }
        }

        if ($type == "parent_id" && !empty($champ_value)) {
            // Avec l'id le parent un seul enregistrement est retourné
            $module_name = $_module_name;
            $retour_enregistrements = $this->getRelatedModuleParentID($_module_name, $champ_value);
        }

        $module = array(
            "module_name" => $module_name,
            "enregistrements" => $retour_enregistrements,
            "nb_enregistrement" => ($unique === true) ? 1 : count($retour_enregistrements),
        );
        return $module;
    }

    public static function getLibelle()
    {
        return "Relation";
    }
}
