var OdeAdresseGeoloc = {};
var MAP = new Array();
var MARKER = new Array();
var ID = '';

OdeAdresseGeoloc.initialisation = function(){
    let params_string  = window.location.search;

    search_params = new URLSearchParams( params_string );

    if(search_params.has("action") === true){
        var action = search_params.get("action");
    }
    var draggable = (action == 'DetailView')?false:true;
    var option = "";
    if(action == 'DetailView'){
        option = {doubleClickZoom: false,closePopupOnClick: false,dragging: false,zoomSnap: false,zoomDelta: false,trackResize: false,touchZoom: false,scrollWheelZoom: false}
    }
                
    $("[data-type=adresse_geoloc]").each(function(i){
        var id = $(this).attr('id');
        var container = $('#'+id);
        var map_id = id+'-map';
        MAP[id] = L.map( map_id, option).setView([ $(container).attr('data-latitude'), $(container).attr('data-longitude')], $(container).attr('data-zoom'));
        var tiles = L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
            minZoom: 5,
            maxZoom: 19
        }).addTo(MAP[id]);
        MARKER[id] = L.marker([$(container).attr('data-latitude'), $(container).attr('data-longitude')],{draggable:draggable}).addTo(MAP[id]);

        if(action == 'EditView' || action == 'create'){
            $("#"+id+" [data-name=name_rue]").change(function(){
                OdeAdresseGeoloc.getAdresse(id);
            });
            $("#"+id+" [data-name=name_code_postal]").change(function(){
                OdeAdresseGeoloc.getAdresse(id);
            });
            $("#"+id+" [data-name=name_ville]").change(function(){
                OdeAdresseGeoloc.getAdresse(id);
            });
            $("#"+id+" [data-name=name_adresse_libre]").change(function(){
                OdeAdresseGeoloc.getAdresse(id);
            });

            $("#"+id+" [data-name=name_numero]").change(function(){
                if($("#"+id+"_value").val() != ''){
                    var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                    adresse.numero =  $("#"+id+" [data-name=name_numero]").val();
                    $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
                }
                OdeAdresseGeoloc.getAdresse(id);
            });

            $("#"+id+" [data-name=name_complement_batiment]").change(function(){
                if($("#"+id+"_value").val() != ''){
                    var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                    adresse.complement_batiment =  $("#"+id+" [data-name=name_complement_batiment]").val();
                    $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
                }
            });

            $("#"+id+" [data-name=name_complement_lieu]").change(function(){
                if($("#"+id+"_value").val() != ''){
                    var adresse = JSON.parse(decodeURIComponent(escape(atob( $("#"+id+"_value").val() ))));
                    adresse.complement_lieu =  $("#"+id+" [data-name=name_complement_lieu]").val();
                    $("#"+id+"_value").val( btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) ) );
                }
            });

            MARKER[id].on('dragend', function(event){
                markerDrag = event.target;
                var position = markerDrag.getLatLng();
                MARKER[id].setLatLng(new L.LatLng(position.lat, position.lng),{draggable:'true'});
                MAP[id].panTo(new L.LatLng(position.lat, position.lng));
                OdeAdresseGeoloc.getAdresseGeoloc(id,position.lng,position.lat);
            });

            $("#"+id+"-position").click(function(){
                if(navigator.geolocation){
                    ID = id;
                    navigator.geolocation.getCurrentPosition(OdeAdresseGeoloc.getPosition);
                }
            });
            // Configuration de l'observateur
            var config = { attributes: true, attributeFilter: ['style'] };
            // Callback de l'observateur
            var callback = function(mutationsList, observer) {
                mutationsList.forEach(function(mutation) {
                    if (mutation.type === 'attributes') {
                        var display = $(mutation.target).css('display');
                        if (display !== 'none') {
                            MAP[id].invalidateSize();
                        }
                    }
                });
            };
            // Créer une instance de MutationObserver avec la callback spécifiée
            var observer = new MutationObserver(callback);
            // Commencer à observer le nœud cible pour les configurations spécifiées
            observer.observe(document.getElementById(id).parentNode, config);
        }
    });
}

OdeAdresseGeoloc.isValid = function( field ){ return true;}

OdeAdresseGeoloc.getValue = function( field ){
    if( typeof $(field).val() === 'string' ) {
        value = String($(field).val()).replaceAll("\n",'&#13;')
        value = OdeDossier.escapeHTML(value);
        return value.trim();
    }
    return '';
} 

OdeAdresseGeoloc.getAdresse = function(id){


    if($('#'+id+' [data-name="name_adresse_libre"]').length > 0){
        var adresse = new Array();
        adresse['adresse_libre'] = $("#"+id+" [data-name=name_adresse_libre]").val();
        adresse['coordonnees_x'] = $("#"+id+" [data-name=name_latitude]").val();
        adresse['coordonnees_y'] = $("#"+id+" [data-name=name_longitude]").val();
        var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
        $("#"+id+"_value").val(adresse);         
    }
    else if($("#"+id+" [data-name=name_rue]").val() != '' && $("#"+id+" [data-name=name_rue]").val().length >= 4
    && (($("#"+id+" [data-name=name_code_postal]").val() != '' && $("#"+id+" [data-name=name_code_postal]").val().length >= 4)
        || $("#"+id+" [data-name=name_ville]").val() != '' && $("#"+id+" [data-name=name_ville]").val().length >= 4) ){
        var adresse = $("#"+id+" [data-name=name_numero]").val() + " " + $("#"+id+" [data-name=name_rue]").val() + " " + $("#"+id+" [data-name=name_code_postal]").val() + " " + $("#"+id+" [data-name=name_ville]").val();
        $.ajax({
            url: "https://api-adresse.data.gouv.fr/search/?q="+adresse,
            dataType:"json",
            success: function(data){
                if(data.features.length == 1){
                    var rue = (data.features[0].properties.type == 'street')?data.features[0].properties.name:data.features[0].properties.street;
                    var numero = (data.features[0].properties.housenumber != undefined)?data.features[0].properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                    $("#"+id+" [data-name=name_numero]").val(numero);
                    $("#"+id+" [data-name=name_rue]").val(rue);
                    $("#"+id+" [data-name=name_code_postal]").val(data.features[0].properties.postcode);
                    $("#"+id+" [data-name=name_ville]").val(data.features[0].properties.city);
                    $("#"+id+" [data-name=name_latitude]").val(data.features[0].geometry.coordinates[1]);
                    $("#"+id+" [data-name=name_longitude]").val(data.features[0].geometry.coordinates[0]);
                    var adresse = new Array();
                    adresse['id'] = data.features[0].properties.id;
                    adresse['numero'] = numero;
                    adresse['rue'] = rue;
                    adresse['city'] = data.features[0].properties.city;
                    adresse['postcode'] = data.features[0].properties.postcode;
                    adresse['citycode'] = data.features[0].properties.citycode;
                    adresse['coordonnees_x'] = data.features[0].geometry.coordinates[1];
                    adresse['coordonnees_y'] = data.features[0].geometry.coordinates[0];
                    adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
                    adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
                    var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
                    $("#"+id+"_value").val(adresse);
                    MARKER[id].setLatLng(new L.LatLng(data.features[0].geometry.coordinates[1], data.features[0].geometry.coordinates[0],{draggable:'true'}));
                    MAP[id].panTo(new L.LatLng(data.features[0].geometry.coordinates[1], data.features[0].geometry.coordinates[0]));
                }else if(data.features.length > 1){
                    $('#'+id+'-modal-adresse-body').empty();
                    $.each(data.features, function( index, value ) {
                        var rue = (value.properties.type == 'street')?value.properties.name:value.properties.street;
                        var numero = (value.properties.housenumber != undefined)?value.properties.housenumber:$("#"+id+" [data-name=name_numero]").val();
                        var radioBtn = $('<div onclick="OdeAdresseGeoloc.setAdresse(\''+ id + '\',\'' +value.properties.id+'\')"><input type="radio" id="'+value.properties.id+'" name="adresse_trouve" /><label for="'+value.properties.id+'">'+value.properties.label+'</label></div>');
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'housenumber" value="'+numero+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_name" value="'+rue+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_city" value="'+value.properties.city+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_postcode" value="'+value.properties.postcode+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_citycode" value="'+value.properties.citycode+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_x" value="'+value.geometry.coordinates[1]+'">'));
                        radioBtn.append($('<input type="hidden" id="'+value.properties.id+'_coordonnees_y" value="'+value.geometry.coordinates[0]+'">'));
                        radioBtn.appendTo('#'+id+'-modal-adresse-body');
                    });
                    $('#'+id+'-titre_modal_trouve').empty();
                    $('#'+id+'-titre_modal_trouve').append(data.features.length + ' adresses trouvées');
                    $('#'+id+'-modal-adresse').modal();
                }
            }
        });
    }
}

OdeAdresseGeoloc.setAdresse = function(id, id_adresse){
    $("#"+id+" [data-name=name_rue]").val($("#"+id_adresse+"_name").val());
    $("#"+id+" [data-name=name_code_postal]").val($("#"+id_adresse+"_postcode").val());
    $("#"+id+" [data-name=name_ville]").val($("#"+id_adresse+"_city").val());
    var adresse = new Array();
    adresse['id'] = id_adresse;
    adresse['numero'] = $("#"+id_adresse+"housenumber").val();
    adresse['rue'] = $("#"+id_adresse+"_name").val();
    adresse['city'] = $("#"+id_adresse+"_city").val();
    adresse['postcode'] = $("#"+id_adresse+"_postcode").val();
    adresse['citycode'] = $("#"+id_adresse+"_citycode").val();
    adresse['coordonnees_x'] = $("#"+id_adresse+"_coordonnees_x").val();
    adresse['coordonnees_y'] = $("#"+id_adresse+"_coordonnees_y").val();
    adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
    adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
    var adresse = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
    $("#"+id+"_value").val(adresse);
    $('#'+id+'-modal-adresse').modal('hide');
    MARKER[id].setLatLng(new L.LatLng($("#"+id_adresse+"_coordonnees_x").val(), $("#"+id_adresse+"_coordonnees_y").val(),{draggable:'true'}));
    MAP[id].panTo(new L.LatLng($("#"+id_adresse+"_coordonnees_x").val(), $("#"+id_adresse+"_coordonnees_y").val()));
}

OdeAdresseGeoloc.getAdresseGeoloc = function(id,lon,lat){


    if($('#'+id+' [data-name="name_adresse_libre"]').length > 0){
        $.get('https://nominatim.openstreetmap.org/reverse?format=jsonv2&lon='+lon+'&lat='+lat+'', async function(data){
            if( typeof data.display_name != 'undefined' ){

                let adresseRecup = [];
                    adresseRecup.push( data.address.road );
                    adresseRecup.push( data.address.quarter );
                    adresseRecup.push( data.address.suburb );
                    adresseRecup.push( data.address.postcode );

                $.grep( [data.address.municipality, data.address.town, data.address.city] , function(segment, index) {
                    if( index === $.inArray(segment, [data.address.municipality, data.address.town, data.address.city]) && typeof segment !== 'undefined' ){}
                    else{
                        adresseRecup.push( segment );
                    }
                });   

                adresseRecup.push( data.address.neighbourhood );
                adresseRecup.push( data.address.county );
                adresseRecup.push( data.address.state );
                adresseRecup.push( data.address.country );

                let valid_slots = [];
                adresseRecup.map((slot, _) => { 
                    if( typeof slot != 'undefined' ){ valid_slots.push(slot); }
                });

                let bloc_adresse = ( typeof data.address != 'undefined' )? valid_slots.join("|") : "";
                    bloc_adresse = String(bloc_adresse).replace(/[|]/g, "\n");

                var adresse = {};
                adresse.id = data.osm_id +'-'+ data.place_id;
                adresse.adresse_libre = bloc_adresse;
                adresse.coordonnees_x = lat;
                adresse.coordonnees_y = lon;

                var adresseEncode = '';
                try{
                    adresseEncode = btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, adresse)) ) ) );
                }
                catch(_x){
                    adresseEncode = String( JSON.stringify( adresse ) ).utf8ToB64();
                }

                $('#'+id+'_value').val(adresseEncode);
                $('#'+id+' [data-name="name_adresse_libre"]').val(adresse.adresse_libre);

                $('#'+id+' [data-name="name_latitude"]').val(lat);
                $('#'+id+' [data-name="name_longitude"]').val(lon);

            }else{
                $('#'+id+'_value').val('');
                $('#'+id+' [data-name="name_adresse_libre"]').val('');
                $('#'+id+' [data-name="name_latitude"]').val(lat);
                $('#'+id+' [data-name="name_longitude"]').val(lon);
            }
        });
    }else{
        $.ajax({
            url: "https://api-adresse.data.gouv.fr/reverse/?lon="+lon+"&lat="+lat,
            dataType:"json",
            success: function(data){
                if(data.features[0]){
                    var adresse = new Array();
                    adresse['id'] = data.features[0].properties.id;
                    adresse['numero'] = data.features[0].properties.housenumber;
                    adresse['rue'] = data.features[0].properties.street;
                    adresse['city'] = data.features[0].properties.city;
                    adresse['postcode'] = data.features[0].properties.postcode;
                    adresse['citycode'] = data.features[0].properties.citycode;
                    adresse['coordonnees_x'] = data.features[0].geometry.coordinates[1];
                    adresse['coordonnees_y'] = data.features[0].geometry.coordinates[0];
                    adresse['complement_batiment'] = $("#"+id+" [data-name=name_complement_batiment]").val();
                    adresse['complement_lieu'] = $("#"+id+" [data-name=name_complement_lieu]").val();
                    var adresse = btoa(unescape(encodeURIComponent(JSON.stringify(Object.assign({}, adresse)))));
                    $("#"+id+"_value").val(adresse);
                    $("#"+id+" [data-name=name_numero]").val(data.features[0].properties.housenumber);
                    $("#"+id+" [data-name=name_rue]").val(data.features[0].properties.street);
                    $("#"+id+" [data-name=name_code_postal]").val(data.features[0].properties.postcode);
                    $("#"+id+" [data-name=name_ville]").val(data.features[0].properties.city);
                    $("#"+id+" [data-name=name_latitude]").val(data.features[0].geometry.coordinates[1]);
                    $("#"+id+" [data-name=name_longitude]").val(data.features[0].geometry.coordinates[0]);
                }else{
                    $("#"+id+"_value").val('');
                    $("#"+id+" [data-name=name_numero]").val('');
                    $("#"+id+" [data-name=name_rue]").val('');
                    $("#"+id+" [data-name=name_code_postal]").val('');
                    $("#"+id+" [data-name=name_ville]").val('');
                    $("#"+id+" [data-name=name_latitude]").val('');
                    $("#"+id+" [data-name=name_longitude]").val('');
                }
                
            }
        });
    }
}

OdeAdresseGeoloc.getPosition = function(position){
    if(position.coords.latitude != '' && position.coords.longitude != ''){
        OdeAdresseGeoloc.getAdresseGeoloc(ID,position.coords.longitude,position.coords.latitude);
        MARKER[ID].setLatLng(new L.LatLng(position.coords.latitude, position.coords.longitude),{draggable:'true'});
        MAP[ID].panTo(new L.LatLng(position.coords.latitude, position.coords.longitude));
        ID = '';
    }
}



$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['adresse_geoloc'] = OdeAdresseGeoloc;
    }
});
