var OdeFile = {};

OdeFile.initialisation = function(){
    $('[role="clear-file"]').click(function() {
        var input_name = $(this).attr("data-name");
        $(`input[type="file"][data-name="${input_name}"]`).val("");
        $(this).hide(); 
    });

    $('[data-role="champ-formulaire"][type="file"]').each(function() {
        var clear_btn =  $(this).parent().parent().find('[role="clear-file"]');
        ( $(this).val().isEmpty() ) ? clear_btn.hide() : clear_btn.show();
        $(this).change(function() {
            ( $(this).val().isEmpty() ) ? clear_btn.hide() : clear_btn.show();
        });
    });
}

OdeFile.isValid = function( field ){ 
    var isCorrect = true;
    var check = '';
    var erreur_taille = '';
    var erreur_type = '';
    if ( field.attr('type') == 'file' && field.prop('files').length > 0) {
        if(field.prop('files')[0].size > field.attr('data-max-size') && field.prop('files').length == 1){
            check = 'taille';
            isCorrect = false;
            erreur_taille = "La taille du fichier est trop grande";
        }else if(field.prop('files').length > 1){
            var tailleTotal = 0;
            $.each(field.prop('files'), function(index, file) {
                tailleTotal += file.size;
            });
            if(tailleTotal > field.attr('data-max-size')){
                check = 'taille';
                isCorrect = false;
                erreur_taille = "La taille des fichiers dépasse la limite autorisé";
            }
        }
        if(field.attr('accept').indexOf(field.prop('files')[0].type) === -1  && field.prop('files').length == 1){
            check = 'type';
            isCorrect = false;
            erreur_type = "Le type du fichier est incorrect";
        }else if( field.prop('files').length > 1){
            var mauvaisType = 0;
            $.each(field.prop('files'), function(index, file) {
                if(field.attr('accept').indexOf(file.type) === -1){
                    mauvaisType++;
                }
            });
            if(mauvaisType > 0){
                check = 'type';
                isCorrect = false;
                erreur_type = "Le type d'un des fichiers est incorrect";
            }
        }
    }
    if ( isCorrect ){
        OdeValidator.hideErreur( field );
        return true;
    } else {
        if( check == 'taille' ){
            OdeValidator.showErreur( field , erreur_taille);
        }else if( check == 'type' ){
            OdeValidator.showErreur( field , erreur_type);
        }
        return false;
    }
}
OdeFile.getContent = async function(content,field_value){
    const reader = new FileReader();
    reader.onload = await function(event) { 
        file_data = reader.result;
        field_value.content = String( file_data ).replace( /data:([a-z\/])*;base64,/i , '' );
        return field_value;
    };
    reader.readAsDataURL(content);
}

OdeFile.getFiles = async function(field){
    $.each(field.prop('files'), async function(index, file) {
        let fileIndex = 'file_' + index;
        field_value.files[fileIndex] = {};
        field_value.files[fileIndex].name = ( field.prop('files')[index].name !== undefined ) ? field.prop('files')[index].name : "";
        field_value.files[fileIndex].type = ( field.prop('files')[index].type !== undefined ) ? field.prop('files')[index].type : "";
        field_value.files[fileIndex].size = ( field.prop('files')[index].size !== undefined ) ? field.prop('files')[index].size : 0;
        $.when( OdeFile.getContent(field.prop('files')[index],field_value.files[fileIndex]) ).done(function( file ) {
            field_value.files[fileIndex] = file;
        });
    });
    return field_value
}

OdeFile.getValue = function( field ){

    var field_type = field.attr("type");
    if ( field_type === "file" ) 
    {
        if($(field).parent().find("[data-name="+field.attr('data-name')+"_select]")[0] && $($(field).parent().find("[data-name="+field.attr('data-name')+"_select]").find('option:selected')[0]).val() != ''){
            var select = $(field).parent().find("[data-name="+field.attr('data-name')+"_select]").find('option:selected')[0];
            var dataFile = JSON.parse( atob($(select).attr("data-file")) );

            field_value = {};
            field_value.attache = dataFile.attache;
            field_value.name = dataFile.name;
            field_value.type = dataFile.type;
            field_value.size = dataFile.size;
            field_value.content = dataFile.content;

        }else if ( !field.val().isEmpty() && field.val().substring(3,11) == 'fakepath') {
            field_value = { name: "", type: "", size: 0, content: ""};
            if (  field.prop('files').length == 1 ) {
                field_value.attache = field.attr("data-attache");
                field_value.name = ( field.prop('files')[0].name !== undefined ) ? field.prop('files')[0].name : "";
                field_value.type = ( field.prop('files')[0].type !== undefined ) ? field.prop('files')[0].type : "";
                field_value.size = ( field.prop('files')[0].size !== undefined ) ? field.prop('files')[0].size : 0;
                $.when( OdeFile.getContent(field.prop('files')[0],field_value) ).done(function( file ) {
                    field_value = file;
                });
                
            }else if (  field.prop('files').length > 1 ) {
                field_value = {};
                field_value.files = {};
                field_value.attache = field.attr("data-attache");
                field_value.multiple = "multiple";

                $.when( OdeFile.getFiles(field) ).done(function( file ) {
                    field_value += file;
                });
            }
        }else if(field.prev().length != 0 && field.prev().get(0).tagName !='SELECT'){
            var field_data = field.prev();
            field_value = { 
                name: field_data.attr("data-name"), 
                type: field_data.attr("data-type"), 
                size: field_data.attr("data-size"), 
                content: field_data.attr("data-content"),
                attache: field_data.attr("data-attache")
            };
        } 
        else {
            field_value = "";
        }
        return field_value;
    }
    return '';
} 

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['file'] = OdeFile;
    }
});
