var OdeTableau = {};

OdeTableau.initialisation = function(){
    OdeTableau.initTotal();
    OdeTableau.initCalcul();
    OdeTableau.initDate();
    OdeTableau.initDecimal();
    OdeTableau.addLigne();
}

OdeTableau.isValid = function( field ){
    var isCorrect = true;
    if($(field).attr("data-type-field") == 'tableau'){
        var inputs = $(field).find('tbody tr :input[required]');
        var vide = true;
        var tableCourante = $(field).find('table');
        var tabTitreHead = {};

        inputs.each(function() {
            var value = $(this).parent().index()+1;
            var thead = tableCourante.find("th:nth-child(" + value + ")");
            
            if(String($(this).val()).trim() === '') {
                tabTitreHead[$(thead).text()] = $(thead).text();
                vide = false;
            } 
        });
        if (!vide) {
            isCorrect = false;
        }
    }
    if(isCorrect){
        OdeValidator.hideErreur(field);
        return true;
    }else{
        var erreur = '';
        var iter = 1;
        $.each(tabTitreHead, function(index, valeur) {
            if (Object.keys(tabTitreHead).length === iter) {
                erreur += valeur;
            }else{
                erreur += valeur+',';
            }
            iter++;
        });
        OdeValidator.showOngletErreur(field);
        OdeValidator.showErreur(field , 'Le tableau est obligatoire ('+erreur+')');
    }
    return false;
}

OdeTableau.getValue = function( field ){
    if($(field).attr('data-type-field') == 'tableau'){
        var tabValue = {}
        var index = 0;
        $(field).find('tbody tr').each(function(){
            var sousIndex = 0;
            tabValue[index] = {};
            $(this).find('input,select').not('.table-dossier-total-input').each(function(){
                tabValue[index][sousIndex] = $(this).val();
                sousIndex++;
            });
            index++;
        });
        return btoa( unescape( encodeURIComponent( JSON.stringify(Object.assign({}, tabValue)) ) ) );
    }
    
    return '';
}

OdeTableau.initDate = function(){
    $.datepicker.regional['fr'] = {
        clearText: 'Effacer', clearStatus: '',
        closeText: 'Fermer', closeStatus: 'Fermer sans modifier',
        prevText: '<Préc', prevStatus: 'Voir le mois précédent',
        nextText: 'Suiv>', nextStatus: 'Voir le mois suivant',
        currentText: 'Courant', currentStatus: 'Voir le mois courant',
        monthNames: ['Janvier','Février','Mars','Avril','Mai','Juin',
        'Juillet','Août','Septembre','Octobre','Novembre','Décembre'],
        monthNamesShort: ['Jan','Fév','Mar','Avr','Mai','Jun',
        'Jul','Aoû','Sep','Oct','Nov','Déc'],
        monthStatus: 'Voir un autre mois', yearStatus: 'Voir un autre année',
        weekHeader: 'Sm', weekStatus: '',
        dayNames: ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'],
        dayNamesShort: ['Dim','Lun','Mar','Mer','Jeu','Ven','Sam'],
        dayNamesMin: ['Di','Lu','Ma','Me','Je','Ve','Sa'],
        dayStatus: 'Utiliser DD comme premier jour de la semaine', dateStatus: 'Choisir le DD, MM d',
        dateFormat: 'dd/mm/yy', firstDay: 0, 
        initStatus: 'Choisir la date', isRTL: false
    };
    $.datepicker.setDefaults($.datepicker.regional['fr']);
    $("[rel=date-tableau]").each(function() {
        $(this).datepicker({
            altField: "#datepicker",
            closeText: "Fermer",
            firstDay: 1 ,
            dateFormat: "dd/mm/yy"
        });

        $(this).on( 'keydown keyup', function(e){
                            
            const field_date =  $(e.currentTarget);
            
            var ini_date = ( field_date.get(0).value == '')? new Date( '1900-01-01' ) : new Date( field_date.get(0).value );
            var min_date = new Date( field_date.attr('min') );
            var max_date = new Date( field_date.attr('max') );
            
            if( typeof e.type != 'undefined' && e.type == 'keydown' ){
                field_date.attr('data-last-date' , field_date.get(0).value ); // Store the active date before keyup triggs.
            }
            
            if( typeof e.type != 'undefined' && e.type == 'keyup' ){
                var set_date = new Date( field_date.get(0).value );
                if( String(field_date.get(0).value).length == 10 && set_date <= max_date ){
                    field_date.attr('data-last-date' , field_date.get(0).value ); // Store the active date before keyup triggs.
                }
                if( String(field_date.get(0).value).length > 10 ){
                    // Year probably exceeds 9999 - eg. 19741
                    new_char = Number.isInteger( e.key )? parseInt( e.key ) : ''; // Pick up only if digit
                    new_year = ( String( (new Date(field_date.attr('data-last-date') )).getFullYear() ) + new_char ).slice(-4);
                    new_month = String( '0'+ (parseInt( (new Date(field_date.attr('data-last-date') )).getMonth() , 10)+1) ).slice(-2);
                    new_day = String( '0'+ (parseInt( (new Date(field_date.attr('data-last-date') )).getDate() , 10)+1) ).slice(-2);
                    
                    var new_date = new_year+'-'+new_month+'-'+new_day;
                        set_date = new Date( new_date );

                    field_date.attr('data-last-date' , new_date ); // Store the active date before keyup triggs.
                    field_date.get(0).value = new_date;
                }
            }
            
        });

        $(this).on( 'blur', function(e){

            var constraint_date = $(this).val();

            var checkConstraintDate = true;
            $(this).attr('data-last-error' , false ).removeAttr( 'data-last-error' );
            
            var min_date = new Date( $(this).attr('min') );
            var max_date = new Date( $(this).attr('max') );
            var set_date = new Date( constraint_date );

            var constraint_date = constraint_date.replace(/ /gi , "");
            
            if ( ( constraint_date.length != 10 ) ) { checkConstraintDate = false; } // Is wellformed ?
            checkConstraintDate = ( set_date instanceof Date && !isNaN(set_date) )? checkConstraintDate : false; // Is really an instance of Date ?
            if( !checkConstraintDate ){
                $(this).get(0).value = ''; // Cleanup the date field
                return false; 
            }
            // Date is welleformed an properly entered, perhaps out of range (min/max bounds)...
            checkConstraintDate = ( set_date > max_date )? false : checkConstraintDate;
            checkConstraintDate = ( set_date < min_date )? false : checkConstraintDate;

            if( checkConstraintDate ){
                return true;
            }
            else{
                $(this).attr('data-last-error', "La date saisie est hors plage.");
                return false;
            }
        });
    });
}

OdeTableau.initDecimal = function(){
    var paramsUrl = (new URL(document.location)).searchParams;
    if(paramsUrl.get('action') != 'DetailView'){
        $('.table-dossier tbody tr [data-type-field="number"]').each(function(){
            if($(this).attr('data-decimal')){
                $(this).autoNumeric({
                    aSep: $(this).closest("[data-type-field='tableau']").attr('data-separateur'),
                    aDec: $(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'),
                }); 
            }else{
                $(this).autoNumeric({
                    aSep: $(this).closest("[data-type-field='tableau']").attr('data-separateur'),
                    aDec: false,
                }); 
            } 
        });
        $('.table-dossier tbody tr [data-type-field="calcul"]').each(function(){
            $(this).autoNumeric({
                aSep: $(this).closest("[data-type-field='tableau']").attr('data-separateur'),
                aDec: $(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'),
            }); 
        });
        $('.table-dossier tbody tr .resultat-calcul').each(function(){
            $(this).autoNumeric({
                aSep: $(this).closest("[data-type-field='tableau']").attr('data-separateur'),
                aDec: $(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'),
            }); 
        });
    }
}

OdeTableau.initTotal = function(){
    var paramsUrl = (new URL(document.location)).searchParams;

    $('.table-dossier').each(function(){
        var params = JSON.parse(atob($(this).find('.tableau-params').val()));
        var addLigne = false;
        var isCalcul = [];
        var table = this;
        if(paramsUrl.get('action') == 'create'){
            var firstTd = $(this).find("td:first-child");
            var isInputOrSelect = $(firstTd[0]).children("input, select").length;

            if (isInputOrSelect == 1) {
                $(this).children("thead").children("tr").prepend("<th></th>");

                $(this).find("tbody tr").each(function(index, element) {
                  $(this).prepend('<td style="border: none;"></td>');

                });
            }

            var ligne = '<tr class="ligne-calcul">';
            ligne += '<td style="border: 1px solid #ddd;width: 5%;">Total</td>';
            
            $.each(params, function(index,tab){
                ligne += '<td>';
                if(tab.calcul === true){
                    addLigne = true;
                    isCalcul.push(index);
                    ligne +=  '<input class="resultat-calcul" type="text" disabled="disabled" value="" style="text-align: right;">';
                }else{
                    ligne +=  '<input type="text" disabled="disabled" value="">';
                }
                ligne +=  '</td>';
            });
            ligne += '</tr>';
        }else {
            $.each(params, function(index,tab){
                if(tab.calcul === true){
                    isCalcul.push(index);
                }
            });
        }
        if(addLigne === true) $(this).append(ligne);

        if(Array.isArray(isCalcul) && isCalcul.length) {
            if(paramsUrl.get('action') == 'EditView' || paramsUrl.get('action') == 'DetailView'){
                var derniereTr = $(this).find("tr:last");
                var selectsDansDerniereTr = derniereTr.find("select");
                selectsDansDerniereTr.each(function() {
                    // Créez un nouvel élément <input> avec la même valeur
                    selectsDansDerniereTr.replaceWith('<input type="text" data-type="' + selectsDansDerniereTr.attr('data-type') + '">');
                });
                var firstTd = $(this).find("td:first-child");
                var isInputOrSelect = $(firstTd[0]).children("input, select").length;

                if (isInputOrSelect == 1) {
                    $(this).children("thead").children("tr").prepend("<th></th>");

                    $(this).find("tbody tr").each(function(index, element) {
                      $(this).prepend('<td style="border: none;"></td>');

                    });
                }
                var derniereLigne = $(this).find("tr:last input");
                $(derniereLigne).addClass('resultat-calcul');
                $(derniereLigne).attr("disabled","disabled");
                $(derniereLigne).css("text-align", "right");
                $($(this).find("tr:last")).addClass('ligne-calcul');
                $($(this).find("tr:last").find("td:first")).text("Total");
                $($(this).find("tr:last").find("td:first")).css("border", "1px solid #ddd");
            }
            $.each(isCalcul, function(index, value) {
                value = value+2;
                var tableCourante = $(table);
                var inputs = tableCourante.find("td:nth-child(" + value + ") input:not(.resultat-calcul)");
                OdeTableau.calculTotal(inputs,tableCourante,value);
            });
        }else if(paramsUrl.get('action') == 'EditView'){
            var firstTd = $(this).find("td:first-child");
            var isInputOrSelect = $(firstTd[0]).children("input, select").length;

            if (isInputOrSelect == 1) {
                $(this).children("thead").children("tr").prepend("<th></th>");

                $(this).find("tbody tr").each(function(index, element) {
                  $(this).prepend('<td style="border: none;"></td>');
                });
            }
        }
    });
}

OdeTableau.initCalcul = function(){
    $('.table-dossier').each(function(){
        var inputs = $(this).find('td input[data-type="calcul"]').not('.resultat-calcul');
        if (inputs.length > 0) {
            inputs.each(function(){
                var formule = $(this).attr('data-formule-calcul');
                var calculInput = $(this);
                // Utilisation d'une expression régulière pour extraire les chiffres après 'c' (minuscule ou majuscule)
                var matches = formule.match(/[cC]\d+/g);
                if (matches !== null) {
                    $.each(matches, function(index, match) {
                        var numbers = match.match(/\d+/);
                        if (numbers !== null) {
                            var inputSelectElements = calculInput.closest('tr').find('td input, select');
                            var indice = numbers[0]-1;
                            $(inputSelectElements[indice]).off('change.initCalcul');
                            $(inputSelectElements[indice]).on('change.initCalcul', function(){
                                var calculInput = $(this).closest('tr').find('input[data-formule-calcul]');
                                var regex = new RegExp('[Cc]' + numbers[0]);
                                var input = {};
                                var clef = 0;
                                calculInput.each(function() {
                                    var formuleCalcul = $(this).data('formule-calcul');
                                    if (regex.test(formuleCalcul)) {
                                        input[clef] = this;
                                        clef++;
                                    }
                                });
                                $.each(input, function(index, value) {
                                    OdeTableau.calcul(this);
                                });
                            });
                        }
                    });
                }
            });
        }
    });
}

OdeTableau.calcul = function(calculInput){
    var formule = $(calculInput).attr('data-formule-calcul');
    var matches = formule.match(/[cC]\d+/g);
    if (matches !== null) {
        var check = true
        $.each(matches, function(index, match) {
            var numbers = match.match(/\d+/);
            if (numbers !== null) {
                var inputSelectElements = $(calculInput).closest('tr').find('td input, select');
                var indice = numbers[0]-1;
                $(inputSelectElements[indice]).val();
                formule = formule.replace(match, $(inputSelectElements[indice]).val());
                if($(inputSelectElements[indice]).val() == ''){
                    check = false;
                }
            }
        });
        if(check == true){
            formule = formule.replaceAll(/ /g,"");
            formule = formule.replaceAll('x','*');
            formule = formule.replaceAll($(calculInput).closest("[data-type-field='tableau']").attr('data-separateur-decimal'),'.');
            var resultat = eval(math.evaluate(formule));
            resultat = resultat.toString().replaceAll('.' , $(calculInput).closest("[data-type-field='tableau']").attr('data-separateur-decimal'));
            $(calculInput).val(resultat);
            $(calculInput).focus();
            $(calculInput).blur();
            //Total de la colonne
            if($(calculInput).attr('role') == "calcul"){
                var tableCourante = $($(calculInput).closest("table"));
                var value = $(calculInput).parent().index()+1;
                var inputs = tableCourante.find("td:nth-child(" + value + ") input:not(.resultat-calcul)");
                OdeTableau.calculTotal(inputs,tableCourante,value,true,"calcul");
            }
        }
    }
}

OdeTableau.addLigne = function(){
    var paramsUrl = (new URL(document.location)).searchParams;

    if(paramsUrl.get('action') != 'DetailView'){
        $('.table-dossier').each(function(){
            if($(this).find('.tableau-ajout-ligne').val()){
                var tableau = this;
                var isCalcul = [];
                var boutonAjout =   '<div class="row" style="margin-bottom: 3%;">';
                boutonAjout +=          '<div class="col-md-1" style="float: right;">';
                boutonAjout +=              '<span class="ajout-tableau-ligne" style="cursor: pointer;">';
                boutonAjout +=                  '<i class="fas fa-plus-circle" style="color: #28a745;font-size: 18px;float: right;"></i>';
                boutonAjout +=              '</span>';
                boutonAjout +=          '</div>';
                boutonAjout +=      '</div>';
                $(this).after(boutonAjout);
                var boutonAjoutLigne = $(this).parent().find('.ajout-tableau-ligne');
                $(boutonAjoutLigne).off('click').click(function(){
                    if($(this).parent().parent().siblings('.table-dossier').find('.colonne-supp').length == 0){
                        $(this).parent().parent().siblings('.table-dossier').first().children('thead').children('tr').append('<th class="colonne-supp" style="background:none;"></th>');
                    }
                    var params = JSON.parse(atob($(tableau).find('.tableau-params').val()));
                    var ligne = '<tr>';

                    if($(tableau).attr('data-ligne-vide') == 'vide'){
                        ligne += '<td style="border: none;"></td>';
                    }else{
                        ligne += '<td></td>';
                    }

                    $.each(params, function(index,tab){
                        ligne += '<td>';
                        if (tab.format == 'texte'){
                            ligne += '<input type="text" value="" ';
                            if (tab.obligatoire) {
                                ligne += 'required="required"';
                            }
                            ligne += '>';
                        }
                        else if (tab.format == 'nombre' || tab.format == 'montant'){
                            if(tab.format == 'nombre'){
                                var decimal = 'data-decimal="0"';
                            }else{
                                var decimal = 'data-decimal="1"';
                            }
                            if (tab.calcul == 1){
                                if (!isCalcul.includes(index + 1)) {
                                    // L'élément n'existe pas dans le tableau
                                    isCalcul.push(index + 1);
                                }
                                ligne += '<input size="25" maxlength="25" type="text" data-type-field="number" role="calcul" min="0" max="" step="1" value="" '+decimal+' style="text-align:right;" ';
                                if (tab.obligatoire) {
                                    ligne += 'required="required"';
                                }
                                ligne += '>';
                            }
                            else{
                                ligne += '<input size="25" maxlength="25" type="text" data-type-field="number" min="0" max="" step="1" value="" '+decimal+' style="text-align:right;" ';
                                if (tab.obligatoire) {
                                    ligne += 'required="required"';
                                }
                                ligne += '>';
                            }
                        }
                        else if (tab.format == 'date'){
                            ligne += '<input size="25" maxlength="25" type="text" rel="date-tableau" data-context="constraint_date" min="1900-01-01" max="2100-12-31" value="" style="text-align:center;" ';
                            if (tab.obligatoire) {
                                ligne += 'required="required"';
                            }
                            ligne += '>';
                        }
                        else if (tab.format == 'liste_deroulante'){
                            ligne += '<select data-type="liste_deroulante" ';
                            if (tab.obligatoire) {
                                ligne += 'required="required"';
                            }
                            ligne += '>';
                            $.each(tab.format_liste_valeurs, function(clef,valeur){
                                ligne += '<option value="'+clef+'">'+valeur+'</option>';
                            });
                            ligne += '</select>';
                        }
                        else if (tab.format == 'calcul'){
                            if (tab.calcul == 1){
                                if (!isCalcul.includes(index + 1)) {
                                    // L'élément n'existe pas dans le tableau
                                    isCalcul.push(index + 1);
                                }
                                ligne += '<input readonly="readonly" size="25" maxlength="25" type="text" data-type-field="calcul" role="calcul" data-type="calcul" data-formule-calcul="'+tab.format_calcul+'" min="0" max="" step="1" value="" style="text-align:right;" ';
                                if (tab.obligatoire) {
                                    ligne += 'required="required"';
                                }
                                ligne += '>';
                            }
                            else{
                                ligne += '<input readonly="readonly" size="25" maxlength="25" type="text" data-type-field="calcul" data-type="calcul" data-formule-calcul="'+tab.format_calcul+'" min="0" max="" step="1" value="" style="text-align:right;" ';
                                if (tab.obligatoire) {
                                    ligne += 'required="required"';
                                }
                                ligne += '>';
                            }
                        }
                        ligne +=  '</td>';
                    });
                    ligne += '<td style="border: none;vertical-align: middle;width: 2%;"><i title="Supprimer la ligne" class="fas fa-times-circle supprimer-ligne" style="float: right;color: #ea0016;cursor: pointer;"></i></td>';
                    ligne += '</tr>';
                    if($(tableau).find("tr:last").attr('class') == 'ligne-calcul'){
                        $($(tableau).find("tr:last")).before(ligne);
                        OdeTableau.initDate();
                        OdeTableau.initCalcul();
                    }else{
                        $(tableau).append(ligne);
                        OdeTableau.initDate();
                        OdeTableau.initCalcul();
                    }
                    if(Array.isArray(isCalcul) && isCalcul.length) {
                        $.each(isCalcul, function(index, value) {
                            value = value+1;
                            var tableCourante = $(tableau);
                            var inputs = tableCourante.find("td:nth-child(" + value + ") input:not(.resultat-calcul)");
                            OdeTableau.calculTotal(inputs,tableCourante,value);
                        });
                    }
                    $('.supprimer-ligne').off().click(function(){
                        if($(this).closest('.table-dossier').find('.supprimer-ligne').length == 1){ 
                            $(this).closest('.table-dossier').children('thead').children('tr').children('th:last-child').remove();
                        }
                        $(this).closest('tr').remove();
                        $.each(isCalcul, function(index, value) {
                            value = value+1;
                            var tableCourante = $(tableau);
                            var inputs = tableCourante.find("td:nth-child(" + value + ") input:not(.resultat-calcul)");
                            OdeTableau.calculTotal(inputs,tableCourante,value,true);
                        });
                    });
                    OdeTableau.initDecimal();
                });
            }
        });
    }
}

OdeTableau.calculTotal = function(inputs,tableCourante,value,supp = false,calcul=""){
    inputs.off('change.calculTotal');
    inputs.on('change.calculTotal' ,function(){
        sum = 0;
        $.each(inputs, function(index, value) {
            val = ($(this).val())?$(this).val():'0';
            val = val.replaceAll(' ','');
            sum += parseFloat( val.replaceAll($(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'), '.') );
        });
        sum = sum.toString().replace('.', $(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'));
        var inputCalcul = tableCourante.find("td:nth-child(" + value + ") input.resultat-calcul");
        $(inputCalcul).val(sum);
        $(inputCalcul).focus();
        $(inputCalcul).blur();
    });
    if(supp){
        if(tableCourante.find("td:nth-child(" + value + ") input.resultat-calcul").val().trim() !== "" || calcul == "calcul"){
            sum = 0;
            $.each(inputs, function(index, value) {
                val = ($(this).val())?$(this).val():'0';
                val = val.replaceAll(' ','');
                sum += parseFloat( val.replaceAll($(this).closest("[data-type-field='tableau']").attr('data-separateur-decimal'), '.') );
            });
            sum = sum.toString().replace('.', $(tableCourante).closest("[data-type-field='tableau']").attr('data-separateur-decimal'));
            var inputCalcul = tableCourante.find("td:nth-child(" + value + ") input.resultat-calcul");
            $(inputCalcul).val(sum);
            $(inputCalcul).focus();
            $(inputCalcul).blur();
        }
    }
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['tableau'] = OdeTableau;
    }
});