<?php

namespace ODE\Modal;

use Sugar_Smarty;

/**
 * Class OdeModal
 *
 * @package Ode\Modal
 */
class OdeModal
{

    protected const MODAL_TPL   = 'custom/include/Ode/Modal/tpls/modal.tpl';
    protected const MODAL_JS    = [
        'custom/include/Ode/Modal/js/jquery.modal.min.js',
        'custom/include/Ode/Modal/js/datatables.min.js',
        'custom/include/Ode/Helper/OdeAjaxHelper.js',
        'custom/include/Ode/Helper/OdeQueriesHelper.js',
        'custom/include/Ode/Helper/OdeLoadingHelper.js',
        'custom/include/Ode/Modal/js/modal.js'
    ];
    protected const MODAL_CSS   = [
        'custom/include/libs/fontawesome/css/all.css',
        'custom/include/Ode/Modal/css/jquery.modal.min.css',
        'custom/include/Ode/Modal/css/datatables.min.css',
        'custom/include/Ode/Modal/css/modal.css'
    ];

    /** @var bool */
    public $statut = true;

    /** @var string */
    protected $modal_id = '';

    /** @var string */
    protected $modal_title = 'Titre de la modal';

    /** @var array */
    protected $js_files = [];

    /** @var array */
    protected $css_files = [];

    /** @var array */
    protected $tpl_files = [];

    /**
     * AstreService constructor
     * @param object $config
     */
    public function __construct($modal_id = '')
    {
        $this->modal_id = (!empty($modal_id) && is_string($modal_id)) ? $modal_id : '';

        foreach (OdeModal::MODAL_JS as $modal_js_file_path) {
            if (file_exists($modal_js_file_path)) {
                $this->js_files[] = $modal_js_file_path;
            }
        }

        foreach (OdeModal::MODAL_CSS as $modal_css_file_path) {
            if (file_exists($modal_css_file_path)) {
                $this->css_files[] = $modal_css_file_path;
            }
        }
    }

    /**
     * @param string $title : le titre de la modale
     * @return void
     */
    public function setTitle($title = "")
    {
        if (!empty($title) && is_string($title)) {
            $this->modal_title = $title;
        }
    }

    /**
     * @param array $data : tableau avec un titre, un sous titre et logo
     * @return void
     */
    public function setCss($data = [])
    {
        if (is_array($data) && count($data)) {
            foreach ($data as $css_file_path) {
                if (file_exists($css_file_path) && !in_array($css_file_path, $this->css_files)) {
                    $this->css_files[] = $css_file_path;
                }
            }
        }
    }

    /**
     * @param array $data : tableau avec un titre, un sous titre et logo
     * @return void
     */
    public function setJs($data = [])
    {
        if (is_array($data) && count($data)) {
            foreach ($data as $js_file_path) {
                if (file_exists($js_file_path) && !in_array($js_file_path, $this->js_files)) {
                    $this->js_files[] = $js_file_path;
                }
            }
        }
    }

    /**
     * @param array $data : tableau avec un titre, un sous titre et logo
     * @return void
     */
    public function setPages($data = [])
    {
        if (is_array($data) && count($data)) {
            foreach ($data as $tpl_file_path) {
                if (file_exists($tpl_file_path)) {
                    $this->tpl_files[] = $tpl_file_path;
                }
            }
        }
    }

    /**
     * @return string
     */
    public function getJs()
    {
        $scripts = '<script>';
        if (is_array($this->js_files) && count($this->js_files)) {
            foreach ($this->js_files as $js_file_path) {
                $scripts .= file_get_contents($js_file_path);
            }
        }
        $scripts .= '</script>';
        return $scripts;
    }

    /**
     * @return string
     */
    public function getCss()
    {
        $styles = '<style>';
        if (is_array($this->css_files) && count($this->css_files)) {
            foreach ($this->css_files as $css_file_path) {
                $styles .= file_get_contents($css_file_path);
            }
        }
        $styles .= '</style>';
        return $styles;
    }

    /**
     * @return void
     */
    public function getPages()
    {
        $pages = '';
        if (is_array($this->tpl_files) && count($this->tpl_files)) {
            foreach ($this->tpl_files as $tpl_file_path) {
                $pages .= file_get_contents($tpl_file_path);
            }
        }
        return $pages;
    }

    /**
     * @return string
     */
    public function getHtml()
    {
        $html = '';
        if (file_exists(OdeModal::MODAL_TPL)) {
            $smarty = new Sugar_Smarty();
            $smarty->assign("modal_id", $this->modal_id);
            $smarty->assign("modal_title", $this->modal_title);
            $smarty->assign("styles", $this->getCss());
            $smarty->assign("pages", $this->getPages());
            $smarty->assign("scripts", $this->getJs());
            $html = $smarty->fetch(OdeModal::MODAL_TPL);
        } else {
            $GLOBALS['log']->fatal(" OdeModal :: getHtml => le fichier déclaré dans MODAL_TPL n'existe pas sur la plateforme ");
        }
        return $html;
    }
}
