<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class AppairageModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe AppairageModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage 
     */
    public function getBean()
    {

        global $db;
        $appairages = array();

        $sql = "SELECT * FROM `ops_appairage` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $appairages[] = $row;
        }
        return (!empty($appairages) && count($appairages) === 1) ? $appairages[0] : array();
    }

    /**
     * @access public
     * @name getByObject()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public static function getByObject($parent_id, $parent_type, $logiciel, $statut)
    {

        global $db;
        $appairages = [];
        if (!empty($parent_id) && !empty($parent_type)) {
            $where = " `parent_type`='" . $parent_type . "' AND `parent_id` = '" . $parent_id . "' AND `deleted` = '0' ";
            if (!empty($logiciel)) {
                $where .= " AND `logiciel`='" . $logiciel . "'";
            }
            if (!empty($statut)) {
                $where .= " AND `statut`='" . $statut . "'";
            }
            $sql = "SELECT * FROM `ops_appairage` WHERE " . $where;
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                $appairages[] = $row;
            }
        }
        return (is_array($appairages) && count($appairages) > 0) ? $appairages : [];
    }

    /**
     * @access public
     * @name getJournal()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getJournal()
    {

        global $db;
        $journals = array();

        $sql = "SELECT * FROM `ops_journal` WHERE `parent_type` = 'OPS_appairage' AND `parent_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $journals[] = $row;
        }

        if (!empty($journals) && count($journals) === 1 && !empty($journals[0]['id'])) {
            $journals[0]['details'] = $this->getJournalDetails($journals[0]['id']);
        }

        return (!empty($journals) && count($journals) === 1) ? $journals[0] : array();
    }

    /**
     * @access private
     * @name getJournalDetail()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $appairage_name : retourne le nom de l'appairage de la personne morale
     */
    private function getJournalDetails($journal_id)
    {

        global $db;
        $details = array();

        $sql = "SELECT * FROM `ops_journal_detail` WHERE `id` IN (SELECT `ops_journal_detail_id` FROM `ops_journal_detail_ops_journal` WHERE `ops_journal_id` = '" . $journal_id . "' AND `deleted` = '0' )";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $details[] = $row;
        }

        return (!empty($details) && count($details) > 0) ? $details : array();
    }

    /**
     * @access public
     * @name getJournalId()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getJournalId()
    {
        $journal = $this->getJournal();
        return (!empty($journal) && count($journal) > 0) ? $journal['id'] : "";
    }
}
