<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class CommissionModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe CommissionModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données du commission en tableau
     *
     *  @return array               - $commission: commission
     */
    public function getBean()
    {

        global $db;
        $commissions = array();

        $sql = "SELECT * FROM `ops_commission` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $commissions[] = $row;
        }
        return (!empty($commissions) && count($commissions) === 1) ? $commissions[0] : array();
    }

    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de la commission
     *
     *  @return array               - $commission_name: le nom de la commission
     */
    public function getName()
    {
        $commission = $this->getBean();
        return ( is_array($commission) && count($commission) > 0 && !empty($commission["name"]) ) ? $commission["name"] : "";
    }

}
