<?php

namespace ODE\Model;

use DBManagerFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class JournalModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe inscriptionsModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * Fonction qui retourne les details d'un journal à partir de son id
     * @param string   $journal_id
     * 
     * @return array
     */
    static function getDetails($journal_id = '')
    {
        $db = DBManagerFactory::getInstance();
        $details = [];
        if (!empty($journal_id)) {
            $sql = "SELECT * FROM ops_journal_detail AS detail
            INNER JOIN ops_journal_detail_ops_journal AS relation ON detail.id=relation.ops_journal_detail_id 
            AND relation.deleted='0' AND relation.ops_journal_id = '" . $journal_id . "' WHERE detail.deleted='0'";
            $result = $db->query($sql);
            while ($detail = $db->fetchByAssoc($result)) {
                if (is_array($detail) && count($detail) > 0) {
                    $detail['module_type'] = 'OPS_journal_detail';
                    $details[$detail['ordre']] = (object) $detail;
                }
            }
        } else {
            $GLOBALS['log']->fatal("JournalService::getDetails() => L'id de l'journal à récupérer est vide");
        }
        ksort($details);
        return (is_array($details) && count($details) > 0) ? $details : [];
    }
}
