<?php

namespace ODE\NavButton;

/**
 * Class OdeNavButton
 *
 * @package ODE\NavButton
 */
class OdeNavButton
{

    const PATH = 'custom/include/Ode/NavButton/Button/';

    const NAMESPACE = 'ODE\\NavButton\\Button\\';

    /**
     * @access public
     * @name get()
     * Fonction qui retourne la liste des boutons à ajouter à la navbar du dossier
     *  @param array       $data : données d'initialisation des buttons
     * 
     *  @return array
     */
    public static function get( $data = [] )
    {
        # On initialise le tableau de retour
        $buttons = [];
        
        if(scandir(OdeNavButton::PATH) !== false)
        {
            # On récupére les fichiers du dossier PATH
            $files = array_diff(scandir(OdeNavButton::PATH), array('.', '..'));

            # Si le dossier est vide, on retourne un tableau vide
            if ( !is_array($files) || count($files) === 0) return [];


            # On boucle sur les fichers pour récupérer la définition de chaque bouton 
            foreach ($files as $file_name) {

                # On initialise la classe du fichier à partir du nom de fichier
                $classe_name = OdeNavButton::NAMESPACE.str_replace(".php", "", $file_name);
                $classe_obj = new $classe_name();

                # On ajoute les données du bouton au tableau de retour 
                $buttons[] = $classe_obj->get($data);
            }
        }

        return $buttons;
    }
}
