<?php

namespace ODE\Sms;

class Orange
{

    public $url_api;
    public $user_name;
    public $password;
    public $token;
    public $erreur_token;

    public function __construct($config = false)
    {
        if(!$config)
        {
            global $sugar_config;

            $this->url_api   = $sugar_config['ops_sms']['url_appel_api'];
            $this->user_name = $sugar_config['ops_sms']['user_name'];
            $this->password  = $sugar_config['ops_sms']['password'];
        }
        else
        {
            $this->url_api   = $config['url_appel_api'];
            $this->user_name = $config['user_name'];
            $this->password  = $config['password'];
        }
    }

    /**
    * Récupération du Token
    * Se connecte à l'api d'Orange à partir des parametres saisis dans la page de configuration
    * - $token  : Token durée de vie une heure
    * - $erreur : Erreur API ou cUrl
    * @return array - Tableau [ <Libellé Erreur Ou null> , <Token Ou null>]
    */
    public function get_token()
    {

        // initialisation de curl
        $curl = curl_init();

        // Problemes avec le certificat, à supprimer si useless
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

        $header = array(
            "Accept: application/json",
            "Content-Type: application/x-www-form-urlencoded",
        );

        $data = [
            'username' => $this->user_name,
            'password' => $this->password
        ];

        $url = $this->url_api . "oauth/token?" . http_build_query($data);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);


        // On décode la réponse
        $response = json_decode(curl_exec($curl), true);

        // On récupere l'erreur cUrl
        $err = curl_error($curl);
        curl_close($curl);

        // Si c'est une erreur cUrl , on renvoie [ Le libellé de l'erreur , token = null ]
        if ($err) {
            $tab_token = [$err, null];
        } else {
            // On appelle la fonction verifie_token de la classe OpsErreurSms
            if (isset($response)) {
                $tab_token = $this->erreurSms->verifie_token($response);
            } else {
                // Pas d'erreur cUrl et une reponse vide => Url incorrect
                $err = "Assurez vous que le chemin HTTP fourni est correct";
                $tab_token = [$err, null];
            }
        }
        return $tab_token;
    }

    /**
     * Se déconnecter
     * L'API ne renvoie aucune valeur, pas moyen de vérifier
     *  @param string $token - Token durée de vie une heure
     */
    public function logout($token)
    {

        // Initialisation de curl
        $curl = curl_init();

        // Problemes avec le certificat, à supprimer si useless
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);


        $header = array(
            "Authorization: Bearer " . $token
        );

        curl_setopt($curl, CURLOPT_URL, $this->url_api . "logout");

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

        // On décode la réponse et l'erreur
        $response = json_decode(curl_exec($curl), true);
        $err = curl_error($curl);
        curl_close($curl);
    }

    /**
     * Retourne les groupes
     * @param string $token - Token durée de vie une heure
     * @return array - Tableau [ <Libellé Erreur Ou null> , <Tableau groupes Ou null>]
     */
    public function get_groups($token)
    {

        // initialisation de curl
        $curl = curl_init();

        // Problemes avec le certificat, à supprimer si useless
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);

        $header = array(
            "Authorization: Bearer " . $token,
            "Content-Type: application/x-www-form-urlencoded",
        );

        curl_setopt($curl, CURLOPT_URL, $this->url_api . "groups");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

        // On décode la réponse et l'erreur
        $response = json_decode(curl_exec($curl), true);
        $err = curl_error($curl);
        curl_close($curl);

        // Si c'est une erreur cUrl
        if ($err) {

            $groups = [$err, null];
        } else {

            // On appelle la fonction verifie_groups de la classe OpsErreurSms
            $groups = $this->erreurSms->verifie_groups($response);
        }

        return $groups;
    }


    /**
     * Post le SMS
     * @param mixed $numeros : numéro format +33645124578  ou tableau de numéro [+33645124578,+33645124578]
     * @param mixed $message : Le message a envoyé
     * @return bool
     */
    public function post_sms($numeros, $message)
    {
        $tab_token = $this->get_token();

        if ($tab_token[1] != null) {
            $this->token = $tab_token[1];
            $this->erreur_token = false;
        } else {
            $this->token = false;
            $this->erreur_token = $tab_token[0];
        }

        // On vérifie que le token est bon
        if ($this->token != false) {

            // On récupere le groupe
            $groups = $this->api_sms->get_groups($this->token);

            if ($groups[0] == null) {

                // On récupere que le premier groupe
                $id_group = $groups[1][0]['id'];
                // initialisation de curl
                $curl = curl_init();

                // Problemes avec le certificat, à supprimer si useless
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);


                if (is_array($numeros)) {
                    $numero = "\"[";
                    foreach ($numeros as $key => $value) {
                        $numero .= $value;
                        if ($key != count($numeros) - 1) {
                            $numero .= ",";
                        }
                    }
                    $numero .= "]\"";
                } else {
                    $numero = "[\"" . $numeros . "\"]";
                }

                $header = array(
                    "Authorization: Bearer " . $this->token,
                    'Content-Type: application/json'
                );

                // Je remplace les char non accepté par l'api
                $message = str_replace("\n", "", $message);
                $message = str_replace("\r", "", $message);
                $message = str_replace("\t", "", $message);

                $content = '{
                    "msisdns":' . $numero . ',
                    "smsParam":{
                    "encoding" : "GSM7",
                    "body":"' . html_entity_decode($message, ENT_QUOTES) . '"
                    }
                }';

                curl_setopt($curl, CURLOPT_URL, $this->url_api . "groups/" . $id_group . "/diffusion-requests");
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
                curl_setopt($curl, CURLOPT_TIMEOUT, 30);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
                curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

                // On décode la réponse et l'erreur
                $response = json_decode(curl_exec($curl), true);

                $err = curl_error($curl);
                curl_close($curl);

                $this->logout($this->token);

                if (!empty($response['id'])) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}