<?php

namespace ODE\Traitements;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OdeConnecteurs
{

    private $time_start;
    private $connecteur_path;
    private $connecteur_namespace;

    /**
     * Constructeur de la classe OdeConnecteurs
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct()
    {
        $this->time_start = microtime(true);
        $this->connecteur_path = "custom/include/Ode/Traitements/Liste/";
        $this->connecteur_namespace = 'ODE\\Traitements\\Liste\\';
    }

    /**
     * @access public
     * @name getConnecteurs()
     * Fonction qui retourne la liste des connecteurs configurés sur le serveur 
     * 
     *  @return array       - $connecteurs
     */
    public function getConnecteurs()
    {
        $connecteurs = array();

        if(scandir($this->connecteur_path) !== false)
        {
            $files = array_diff(scandir($this->connecteur_path), array('.', '..'));
            if (is_array($files) && count($files) > 0) {
                foreach ($files as $file_name) {
                    $classe_name = $this->connecteur_namespace . ucfirst(str_replace(".php", "", $file_name));
                    $classe_obj = new $classe_name();
                    $connecteur = $classe_obj->getConnecteur();
                    $connecteurs[$connecteur['connecteur_id']] = $connecteur;
                }
            }
        }
        return $connecteurs;
    }
}
