<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;
if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();
$errors        = array();
$array_categories = array('titre', 'onglet', 'label', 'champ');
$target_dir = "themes/default/images/";
$target_file = $target_dir . "pdf_logo.png";

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {

    # Initialisation des paramètres généraux du PDF
    $configuratorObj->config['api_particulier']['url'] = $_REQUEST['url'];
    $configuratorObj->config['api_particulier']['jeton'] = $_REQUEST['jeton'];

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index');
    
}

$sugar_smarty->assign('ARRAY_CATEGORIES', $array_categories);
$sugar_smarty->assign('URL', $configuratorObj->config['api_particulier']['url']);
$sugar_smarty->assign('JETON', $configuratorObj->config['api_particulier']['jeton']);

$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);
$sugar_smarty->assign('APP_LIST', $app_list_strings);
$sugar_smarty->assign('LANGUAGES', get_languages());
$sugar_smarty->assign("JAVASCRIPT", get_set_focus_js());
$sugar_smarty->assign('config', $sugar_config);
$sugar_smarty->assign('error', $errors);

$sugar_smarty->clear_cache('custom/modules/Administration/api_particulier.tpl');
$sugar_smarty->display('custom/modules/Administration/api_particulier.tpl');