<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;

if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

use ODE\Model\DossierModel;

require_once('modules/Configurator/Configurator.php');

$configuratorObj = new Configurator();
$sugar_smarty    = new Sugar_Smarty();

$configuratorObj->loadConfig();

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') 
{
    if (isset($_REQUEST['nombre_dossier'])) 
    {
        $configuratorObj->config['generateur_donnees']['nombre_dossier'] = $_REQUEST['nombre_dossier'];
    }

    if (isset($_REQUEST['type_profil'])) 
    {
        $configuratorObj->config['generateur_donnees']['type_profil'] = $_REQUEST['type_profil'] ;
    }

    if (isset($_REQUEST['dispositif'])) 
    {
        $configuratorObj->config['generateur_donnees']['dispositif'] = $_REQUEST['dispositif'] ;
    }

    if (isset($_REQUEST['email'])) 
    {
        $configuratorObj->config['generateur_donnees']['email'] = $_REQUEST['email'] ;
    }

    if (isset($_REQUEST['sous_territoire'])) 
    {
        $configuratorObj->config['generateur_donnees']['sous_territoire'] = $_REQUEST['sous_territoire'] ;
    }

    $configuratorObj->saveConfig();


    header('Location:index.php?module=Administration&action=index#generateur_donnees'); 
}

$sugar_smarty = new Sugar_Smarty();

// Récupération des dispositifs
$dispositifs = get_bean_select_array(true, 'OPS_dispositif','name', '','name',true);

$type_profils = get_bean_select_array(true, 'OPS_type_personne','name', '','name',true);

$sous_territoires = get_bean_select_array(true, 'OPS_sous_territoire','name', '','name',true);

$SELECT_DISPOSITIF = get_select_options_with_id($dispositifs, $configuratorObj->config['generateur_donnees']['dispositif']);
$sugar_smarty->assign("DISPOSITIFS", $SELECT_DISPOSITIF);

$SELECT_TYPE_PROFIL = get_select_options_with_id($type_profils, $configuratorObj->config['generateur_donnees']['type_profil']);
$sugar_smarty->assign("TYPE_PROFILS", $SELECT_TYPE_PROFIL);

$SELECT_SOUS_TERRITOIRE = get_select_options_with_id($sous_territoires, $configuratorObj->config['generateur_donnees']['sous_territoire']);
$sugar_smarty->assign("SOUS_TERRITOIRES", $SELECT_SOUS_TERRITOIRE);

$sugar_smarty->assign("EMAIL", $configuratorObj->config['generateur_donnees']['email']);
$sugar_smarty->assign("NOMBRE_DOSSIER", $configuratorObj->config['generateur_donnees']['nombre_dossier']);

$sugar_smarty->clear_cache('custom/modules/Administration/generateur_donnees_generer.tpl');
$sugar_smarty->display('custom/modules/Administration/generateur_donnees_generer.tpl');