<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

global $current_user, $sugar_config;

if (!is_admin($current_user)) sugar_die("Unauthorized access to administration.");

use ODE\Model\DossierModel;

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') 
{
    $objIndividu = BeanFactory::newBean('OPS_individu');
    $individus = $objIndividu->get_full_list(
        'name',
        'ops_individu.last_name LIKE "UserTest%" and ops_individu.deleted = 0'
    );
    if(!empty($individus))
    {
        foreach ($individus as $individu)
        {
            $objIndividu->mark_deleted($individu->id);
            $objIndividu->save();
        }
    }
    
    $objPersonneMorale = BeanFactory::newBean('OPS_personne_morale');
    $personneMorales = $objPersonneMorale->get_full_list(
        'name',
        'ops_personne_morale.name LIKE "UserTest%" and ops_personne_morale.deleted = 0'
    );
    if(!empty($personneMorales))
    {
        foreach ($personneMorales as $personneMorale) 
        {
            $personneMorale->mark_deleted($personneMorale->id);
            $personneMorale->save();
        }
    }

    require_once('modules/Configurator/Configurator.php');

    $configuratorObj = new Configurator();

    $configuratorObj->loadConfig();

    $configuratorObj->config['generateur_donnees']['user_nombre'] = 0;

    $configuratorObj->saveConfig();

    header('Location:index.php?module=Administration&action=index#supprimer_donnees'); 
}

$sugar_smarty = new Sugar_Smarty();

$sugar_smarty->clear_cache('custom/modules/Administration/generateur_donnees_supprimer.tpl');
$sugar_smarty->display('custom/modules/Administration/generateur_donnees_supprimer.tpl');