<?php
require_once('custom/modules/Documents/Documents_editiques.php');
// Classe étendue pour définir une entête et un pied de page personnalisé

use TCPDF;

class ViewerPDF extends TCPDF {

    private $headerHtml;
    private $footerHtml;

    public function __construct($modeleId,$documentId)
    {
        if(!empty($modeleId) && !empty($documentId)){

            $objModeleDocument = BeanFactory::getBean( 'OPS_modele_document' , $modeleId );
            $objDocumentEditique = new Documents_editiques();

            $this->headerHtml = (!empty($objModeleDocument->pdfheader))?html_entity_decode($objModeleDocument->pdfheader):'';
            if(!empty($this->headerHtml)){
                $this->headerHtml = $objDocumentEditique->replace_variable_champs( $documentId, $this->headerHtml);
                $this->headerHtml = $objDocumentEditique->replace_unknow_champs( $documentId, $this->headerHtml);
            }

            $this->footerHtml = (!empty($objModeleDocument->pdffooter))?html_entity_decode($objModeleDocument->pdffooter):'';
            if(!empty($this->footerHtml)){
                $this->footerHtml = $objDocumentEditique->replace_variable_champs( $documentId, $this->footerHtml);
                $this->footerHtml = $objDocumentEditique->replace_unknow_champs( $documentId, $this->footerHtml);
            }
        }
        
        parent::__construct(PDF_PAGE_ORIENTATION, 'mm', 'A4', true, 'UTF-8', false);
    }

    //Entête de page
    public function Header() {
        if(!empty($this->headerHtml)){
            $this->SetY(5);
            $startY = $this->GetY(); // Enregistrer la position Y de départ
            $this->SetFont('', '', 12);
            $this->writeHTML($this->headerHtml);
            $endY = $this->GetY(); // Enregistrer la position Y de fin

            // Calculer la hauteur du header
            $headerHeight = $endY - $startY;
            // Définir la marge supérieure pour s'adapter à la hauteur du header
            $this->SetTopMargin($headerHeight + 10);
        }
    }

    // Pied de page
    public function Footer() {
        if(!empty($this->footerHtml)){
            $this->SetFont('', '', 12);
            
            // Réinitialisation de l'espacement avant la mesure de la hauteur du pied de page
            $this->setCellPadding(0);
            $currentAutoPageBreak = $this->AutoPageBreak;
            $this->SetAutoPageBreak(false);
            
            // Création d'une page temporaire pour mesurer la hauteur réelle du contenu
            $tempPage = $this->startTemplate();
            $startY = $this->GetY();
            $this->writeHTML($this->footerHtml, true, false, true, false, '');
            $footerHeight = $this->GetY() - $startY;
            $this->endTemplate();
            
            // Restauration du paramètre de saut de page automatique
            $this->SetAutoPageBreak($currentAutoPageBreak, 15);
            
            // Positionnement du pied de page avec la hauteur réelle du contenu et un décalage de sécurité
            $this->SetY(-($footerHeight + 5));
            
            // Écriture du contenu du pied de page
            $this->writeHTML($this->footerHtml, true, false, true, false, '');
        }
    }

    // Fonction pour calculer la hauteur du footer
    public function calculateFooterHeight() {
        $this->footerHeight = 10;
        if (!empty($this->footerHtml)) {
            $this->SetFont('', '', 12);
            $this->footerHeight = $this->getStringHeight($this->getPageWidth() - PDF_MARGIN_LEFT - PDF_MARGIN_RIGHT, $this->footerHtml) + 15;
        }
    }
}