<?php

if (!defined('sugarEntry') || !sugarEntry) {
	die('Not A Valid Entry Point');
}

global $app_list_strings;

$module_name = 'Documents';
$subpanel_layout = array(
	'top_buttons' => array(
		array('widget_class' => 'SubPanelTopCreateButton'),
		array(
			'widget_class' => 'SubPanelTopSelectButton',
			'popup_module' => $module_name,
			'field_to_name_array' => array('document_revision_id' => 'REL_ATTRIBUTE_document_revision_id')
		),
	),

	'where' => ' documents.deleted = 0 AND documents.status_id <> "brouillon" AND documents.status_id <> "" ',

	'list_fields' => array(
		'object_image' => array(
			'vname' => 'LBL_OBJECT_IMAGE',
			'widget_class' => 'SubPanelIcon',
			'width' => '2%',
			'image2' => 'attachment',
			'image2_url_field' => array(
				'id_field' => 'id',
				'filename_field' => 'filename',
			),
			'attachment_image_only' => true,
		),
		'ops_type_document_documents_name' => array(
			'name' => 'ops_type_document_documents_name',
			'vname' => 'LBL_OPS_TYPE_DOCUMENT_DOCUMENTS_FROM_OPS_TYPE_DOCUMENT_TITLE',
			'sortable' => true,
			'width' => '20%',
		),
		'filename' => array(
			'name' => 'filename',
			'vname' => 'LBL_LIST_FILENAME',
			'width' => '20%',
			'module' => $module_name,
			'sortable' => false,
			'displayParams' => array(
				'module' => $module_name,
			),
		),
		'document_revision_id' => array(
			'name' => 'document_revision_id',
			'usage' => 'query_only',
		),
		'status_id' => array(
			'name' => 'status_id',
			'vname' => 'LBL_LIST_STATUS',
			'width' => '10%',
		),
		'active_date' => array(
			'name' => 'active_date',
			'vname' => 'LBL_LIST_ACTIVE_DATE',
			'sortable' => true,
			'width' => '10%',
		),
		'get_latest' => array(
			'widget_class' => 'SubPanelGetLatestButton',
			'module' => $module_name,
			'width' => '5%',
		),
		'load_signed' => array(
			'widget_class' => 'SubPanelLoadSignedButton',
			'module' => $module_name,
			'width' => '5%',
		),


		'edit_button' => array(
			'vname' => 'LBL_EDIT_BUTTON',
			'widget_class' => 'SubPanelEditButton',
			'module' => 'Documents',
			'width' => '5%',
		),
		'remove_button' => array(
			'vname' => 'LBL_REMOVE',
			'widget_class' => 'SubPanelRemoveButton',
			'module' => 'Documents',
			'width' => '5%',
		),

		'compose_action_latest' => array(
			'vname' => 'LBL_COMPOSE_BUTTON',
			'widget_class' => 'SubPanelEditButtonMultiActionsDocuments',
			'type' => 'rowaction',
			'module' => $module_name,
			'width' => '4%',
		),

	),
);

# Surcharge module Partenaire
if (isset($app_list_strings['moduleList']['OPS_avis'])) {
	$array_partenaire = array(
		'pastille_partenaire' => array(
			'name' => 'pastille_partenaire',
			'vname' => 'Statut partenaire',
			'width' => '10%',
		),
	);

	// On rajoute la partie Partenaire après le status_id dans le sous-panel
	$index = array_search('status_id', array_keys($subpanel_layout['list_fields']));
	$subpanel_layout['list_fields'] = array_slice($subpanel_layout['list_fields'], 0, $index + 1) + $array_partenaire + $subpanel_layout['list_fields'];
}
# Fin surcharge module Partenaire
