<?php

class hook_habilitation
{
    
    /**
     * create_habilitations_dispositifs
     * Créer les habilitations des dispositifs (et des étapes) sur le profil métier 
     *
     * @param  mixed $bean
     * @param  mixed $event
     * @param  mixed $arguments
     *
     * @return void
     */
    function create_habilitations_dispositifs(&$bean, $event, $arguments = null)
    {
        global $db;

        if ($event != 'after_save' || empty($_REQUEST['habilitation_dispositifs'])) {
            return;
        } 

        $habilitation_field = [
            'visualisation',
            'assignation',
            'correction',
            'duplication',
            'execution',
            'instruction',
            'edition',
            'suppression',
        ];

        $etape_field = [
            'visualisation',
            'instruction',
            'edition',
        ];

        $obj_dispositif = new OPS_dispositif();
        $dispositifs = $obj_dispositif->get_full_list('name');

        $habilitation_dispositifs = (!empty($_REQUEST['habilitation_dispositifs'])) ? json_decode( base64_decode($_REQUEST['habilitation_dispositifs']), true) : '';

        foreach($dispositifs as $dispositif)
        {
            $query = 'SELECT ops_habilitation_dispositif.id
                      FROM ops_habilitation_dispositif
                      INNER JOIN ops_habilitation_dispositif_ops_dispositif ON ops_habilitation_dispositif.id = ops_habilitation_dispositif_ops_dispositif.ops_habilitation_dispositif_id AND ops_habilitation_dispositif_ops_dispositif.deleted = 0
                      INNER JOIN ops_dispositif ON ops_habilitation_dispositif_ops_dispositif.ops_dispositif_id = ops_dispositif.id AND ops_dispositif.deleted = 0
                      INNER JOIN ops_habilitation_dispositif_securitygroups ON ops_habilitation_dispositif.id = ops_habilitation_dispositif_securitygroups.ops_habilitation_dispositif_id AND ops_habilitation_dispositif_securitygroups.deleted = 0
                      INNER JOIN securitygroups ON securitygroups.id = ops_habilitation_dispositif_securitygroups.securitygroups_id AND securitygroups.deleted = 0
                      WHERE securitygroups.id = "' . $bean->id . '" AND ops_habilitation_dispositif.deleted = 0 AND ops_dispositif.id = "' . $dispositif->id . '"
                      ORDER BY ops_habilitation_dispositif.date_entered DESC';

            $requete = $db->query($query);

            $habilitationDispositifListe = [];
            while ($row = $db->fetchRow($requete)) 
            {
                $habilitationDispositifListe[] = $row['id'];
            }

            if(count($habilitationDispositifListe) > 1)
            {
                for ($i = 1; $i < count($habilitationDispositifListe); ++$i) 
                { 
                    $obj_habilitation_dispositif = BeanFactory::getBean('OPS_habilitation_dispositif', $habilitationDispositifListe[$i]);
                    $obj_habilitation_dispositif->mark_deleted($obj_habilitation_dispositif->id);
                }
            }

            $creation = 1;
            if(count($habilitationDispositifListe) >= 1)
            {
                $creation = 0;
                $obj_habilitation_dispositif = BeanFactory::getBean('OPS_habilitation_dispositif', $habilitationDispositifListe[0]);
            }
            else
            {
                $obj_habilitation_dispositif = BeanFactory::newBean('OPS_habilitation_dispositif');
            }

            if(is_array($habilitation_dispositifs) && array_key_exists($dispositif->id, $habilitation_dispositifs))
            {
                $habilitation_dispositif = $habilitation_dispositifs[$dispositif->id];

                foreach( $habilitation_field as $field )
                {
                    $obj_habilitation_dispositif->{$field} = $this->getValue($habilitation_dispositif[$field]);
                }

                $obj_habilitation_dispositif->name = $bean->name . ' : Habilitation - ' . $dispositif->name;
                $obj_habilitation_dispositif->ops_dispositif_id = $dispositif->id;

                $obj_habilitation_dispositif->save();

                $obj_habilitation_dispositif->load_relationship('ops_habilitation_dispositif_securitygroups');
                if(!$creation)
                {
                    $securityGroupList = $obj_habilitation_dispositif->ops_habilitation_dispositif_securitygroups->get();

                    if(count($securityGroupList) > 1)
                    {
                        for($i = 0; $i < count($securityGroupList); ++$i)
                        {
                            if($securityGroupList[$i] != $bean->id)
                            {
                                $obj_habilitation_dispositif->ops_habilitation_dispositif_securitygroups->delete($securityGroupList[$i]);
                            }
                        }
                    }
                }

                $bean->load_relationship('ops_habilitation_dispositif_securitygroups');
                $bean->ops_habilitation_dispositif_securitygroups->add($obj_habilitation_dispositif);

                $dispositif->load_relationship('ops_guide_instruction_ops_dispositif');

                $guide_instruction = BeanFactory::getBean('OPS_guide_instruction', $dispositif->ops_guide_instruction_ops_dispositif->get()[0]);
                $etapes = $guide_instruction->get_linked_beans('ops_guide_instruction_ops_etape' , 'OPS_etape');

                $obj_habilitation_dispositif->load_relationship('ops_habilitation_etape_ops_habilitation_dispositif');
                $etapes_ids = $obj_habilitation_dispositif->ops_habilitation_etape_ops_habilitation_dispositif->get();

                $etapes_data = [];
                foreach($etapes as $etape)
                {
                    $query = 'SELECT ops_habilitation_etape.id 
                              FROM ops_habilitation_etape 
                              INNER JOIN ops_habilitation_etape_ops_habilitation_dispositif ON ops_habilitation_etape.id = ops_habilitation_etape_ops_habilitation_dispositif.ops_habilitation_etape_id 
                              AND ops_habilitation_etape_ops_habilitation_dispositif.deleted=0 
                              AND ops_habilitation_etape_ops_habilitation_dispositif.ops_habilitation_dispositif_id = "' . $obj_habilitation_dispositif->id . '" 
                              INNER JOIN ops_habilitation_etape_ops_etape ON ops_habilitation_etape.id = ops_habilitation_etape_ops_etape.ops_habilitation_etape_id 
                              AND ops_habilitation_etape_ops_etape.deleted=0 
                              AND ops_habilitation_etape_ops_etape.ops_etape_id = "' . $etape->id . '"';
                            
                    $result = $db->getOne($query);

                    if (!empty($result)) 
                    {
                        $obj_habilitation_etape = BeanFactory::getBean('OPS_habilitation_etape', $result);
                    }
                    else
                    {
                        $obj_habilitation_etape = BeanFactory::newBean('OPS_habilitation_etape');
                    }
                    $obj_habilitation_etape->name = $etape->name;
                    $obj_habilitation_etape->ops_etape_id = $etape->id;

                    
                    foreach( $etape_field as $field )
                    {
                        if($habilitation_dispositif[$field] == 'all')
                        {
                            $value = 1;
                        }
                        else
                        {
                            $value = $this->getValue($habilitation_dispositif['etapes'][$etape->id][$field]);
                        }
                        $obj_habilitation_etape->{$field} = $value;
                    }
                    
                    $obj_habilitation_etape->save();

                    if(empty($result))
                    {
                        $obj_habilitation_etape->load_relationship('ops_habilitation_etape_ops_etape');
                        $obj_habilitation_etape->ops_habilitation_etape_ops_etape->add($etape);

                        $obj_habilitation_dispositif->load_relationship('ops_habilitation_etape_ops_habilitation_dispositif');
                        $obj_habilitation_dispositif->ops_habilitation_etape_ops_habilitation_dispositif->add($obj_habilitation_etape);
                    }
                }
            }
            else if(!empty($obj_habilitation_dispositif->id))
            {
                $obj_habilitation_dispositif->mark_deleted($obj_habilitation_dispositif->id);
            }
        }
    }

    private function getValue($habilitation_value)
    {
        $value = 0;

        if( $habilitation_value == 'all' || $habilitation_value == 'partielle' )
        {
            $value = 1;
        }

        return $value;
    }
}

?>