<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');

class SecurityGroupsViewDetail extends ViewDetail 
{
    public function __construct()
    {
        parent::__construct();
    }

    public function display()
    {
        global $app_strings, $app_list_strings;

        if(empty($this->bean->id)){
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $habilitation_field = [
            'visualisation',
            'assignation',
            'correction',
            'duplication',
            'execution',
            'instruction',
            'edition',
            'suppression'
        ];

        $smarty = new Sugar_Smarty();

        $smarty->assign('name', $this->bean->name);

        $obj_dispositif = new OPS_dispositif();
        $dispositifs = $obj_dispositif->get_full_list('name');

        // Récupération des dispositifs liés au profil métier 
        $this->bean->load_relationship('ops_habilitation_dispositif_securitygroups');
        $habilitation_ids = $this->bean->ops_habilitation_dispositif_securitygroups->get();
        
        $habilitation_dispositifs = array();
        if (!empty($habilitation_ids)) 
        {
            // Boucle sur les habilitations dispositifs 
            foreach ($habilitation_ids as $habiliatation_id) 
            {
                $obj_habilitation_dispositif = BeanFactory::getBean('OPS_habilitation_dispositif', $habiliatation_id);

                if( !empty($obj_habilitation_dispositif))
                {
                    // Récupération des habilitations du dispositif
                    $habilitation_dispositifs[$obj_habilitation_dispositif->ops_dispositif_id] = $obj_habilitation_dispositif->get_habilitations() ;                         
                }
            }
        }

        $habilitation_partielle = (!empty($this->bean->habilitation_partielle)) ? json_decode( base64_decode($this->bean->habilitation_partielle), true) : '';

        $dispositifs_data = [];
        foreach($dispositifs as $dispositif)
        {
            if(!is_array($habilitation_dispositifs) || !array_key_exists($dispositif->id, $habilitation_dispositifs) || $habilitation_dispositifs[$dispositif->id]['visualisation'] == 0)
            {
                continue;
            }

            $dispositif_data = [
                'id'   => $dispositif->id,
                'name' => $dispositif->name,
            ];

            $habilitation_dispositif = $habilitation_dispositifs[$dispositif->id];

            foreach($habilitation_field as $field)
            {
                $value = 'none';
                if (!empty($habilitation_partielle) && array_key_exists($dispositif->id, $habilitation_partielle) && array_key_exists($field, $habilitation_partielle[$dispositif->id]))
                {
                    $value = 'partielle';
                }
                else if (isset($habilitation_dispositif[$field]))
                {
                    $value = $this->getValue($habilitation_dispositif[$field]);
                }
                $dispositif_data[$field] = $value;
            }

            $dispositif->load_relationship('ops_guide_instruction_ops_dispositif');

            // CREATION MODAL - PARTIE "PARTIELLE" => SEULEMENT POUR LES HABILITATIONS visualisation/instruction/edition

            // Récupération des étapes du guide d'instruction du dispositif
            $guide_instruction = BeanFactory::getBean('OPS_guide_instruction', $dispositif->ops_guide_instruction_ops_dispositif->get()[0]);
            $etapes = $guide_instruction->get_linked_beans('ops_guide_instruction_ops_etape' , 'OPS_etape');

            $etapes_data = [];
            foreach($etapes as $etape)
            {
                $etapes_data[$etape->id] = [
                    'id'   => $etape->id,
                    'name' => $etape->name,
                ];
            }

            if(!empty($habilitation_dispositif) && array_key_exists('etapes', $habilitation_dispositif))
            {
                foreach($habilitation_dispositif['etapes'] as $etape_id => $habilitation_dispositif_etape)
                {
                    foreach($habilitation_dispositif_etape as $habilitation_etape => $value)
                    {
                        $etapes_data[$etape_id][$habilitation_etape] = $this->getValue($value);
                    }
                }
            }
            $dispositif_data['etapes'] = $etapes_data;

            $modal_visualisation = $modal_instruction = $modal_edition = '';

            // On créé les modals seulement si la valuer des habilitations est à "partielle"
            if(is_array($habilitation_dispositifs) && array_key_exists($dispositif->id, $habilitation_dispositifs))
            {
                if(isset($dispositif_data['visualisation']) && $dispositif_data['visualisation'] == 'partielle')
                {
                    $modal_visualisation = $this->build_modal([
                        'dispositif_data'         => $dispositif_data,
                        'habilitation_label'      => 'Accès',
                        'habilitation'            => 'visualisation',
                    ]);
                }

                if(isset($dispositif_data['instruction']) && $dispositif_data['instruction'] == 'partielle')
                {
                    $modal_instruction = $this->build_modal([
                        'dispositif_data'         => $dispositif_data,
                        'habilitation_label'      => 'Instruction',
                        'habilitation'            => 'instruction',
                    ]);
                }

                if(isset($dispositif_data['edition']) && $dispositif_data['edition'] == 'partielle')
                {
                    $modal_edition = $this->build_modal([
                        'dispositif_data'         => $dispositif_data,
                        'habilitation_label'      => 'Edition',
                        'habilitation'            => 'edition',
                    ]);
                }
            }

            $dispositif_data['modal'] = [
                'visualisation' => $modal_visualisation,
                'instruction'   => $modal_instruction,
                'edition'       => $modal_edition
            ];
            // FIN MODAL

            $dispositifs_data[$dispositif->id] = $dispositif_data;
        }

        $smarty->assign('assigned_user_name',     $this->bean->assigned_user_name);
        $smarty->assign('bridage_page_accueil_c', $this->bean->bridage_page_accueil_c);
        $smarty->assign('date_entered',           $this->bean->date_entered);
        $smarty->assign('date_modified',          $this->bean->date_modified);
        $smarty->assign('dispositif_data',        $dispositifs_data);
        $smarty->assign('noninheritable',         $this->bean->noninheritable);
        $smarty->assign('record',                 $this->bean->id);


        // Partie Individu

        $onglets_individu_list = [
            'autorisations_attestations' => [
                'id' => 'autorisations_attestations',
                'name' => 'autorisations et attestations',
                'value' => ($this->bean->autorisations_attestations == 1) ? 'checked' : '',
            ],
            'fiche_sante' =>[
                'id' => 'fiche_sante',
                'name' => 'fiche santé',
                'value' => ($this->bean->fiche_sante == 1) ? 'checked' : '',
            ],
            'regime_alimentaire' =>[
                'id' => 'regime_alimentaire',
                'name' => 'régime alimentaire',
                'value' => ($this->bean->regime_alimentaire == 1) ? 'checked' : '',
            ],
            'situation_professionnelle' =>[
                'id' => 'situation_professionnelle',
                'name' => 'situation professionnelle',
                'value' => ($this->bean->situation_professionnelle == 1) ? 'checked' : '',
            ],
        ];
        
        $smarty->assign('onglets_individu_list',  $onglets_individu_list);

        $smarty->assign('journal_modification', ($this->bean->journal_modification == 1) ? 'checked' : '');
        $smarty->assign('individu_calendrier', ($this->bean->individu_calendrier == 1) ? 'checked' : '');
        $smarty->assign('profil_calendrier', ($this->bean->profil_calendrier == 1) ? 'checked' : '');

        $current_template = "custom/modules/SecurityGroups/tpls/detail.tpl";

        $smarty->display($current_template);
    }

    private function build_modal($params = array())
    {
        if (!is_array($params)) {
            return '';
        }

        $dispositif_data         = (isset($params['dispositif_data']))         ? $params['dispositif_data']         : '';
        $habilitation            = (isset($params['habilitation']))            ? $params['habilitation']            : '';
        $habilitation_label      = (isset($params['habilitation_label']))      ? $params['habilitation_label']      : '';

        $modal =  '<div id="modal-' . $habilitation . '-' . $dispositif_data['id'] . '" class="modal" tabindex="-1" role="dialog">';
        $modal .= '  <div class="modal-dialog" style="max-width: 800px;">';
        $modal .= '     <div class="modal-content">';
        $modal .= '         <div class="modal-header">';
        $modal .= '             <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';
        $modal .= '                 <h4 class="modal-title" id="titre_modal_' . $habilitation . '">Habilitations du profil “' . $this->bean->name . '”</h4><h4> Personnalisation du dispositif “' . $dispositif_data['name'] . '”</h4>';
        $modal .= '             </button>';
        $modal .= '         </div>';
        $modal .= '         <div id="modal-' . $habilitation . '-body" class="modal-body" style="min-height: 78px;">';
        $modal .= '             <table class="table table-bordered">';
        $modal .= '                 <thead>';
        $modal .= '                     <tr>';
        $modal .= '                         <th scope="col">Étapes du guide d’instruction</th>';
        $modal .= '                         <th scope="col">' . $habilitation_label . '</th>';
        $modal .= '                     </tr>';
        $modal .= '                 </thead>';
        $modal .= '                 <tbody>';

        if(is_array($dispositif_data['etapes']))
        {
            foreach($dispositif_data['etapes'] as $etape)
            {
                if(!empty($etape['id']))
                {
                    $value = 'none';
                    if( array_key_exists($habilitation, $etape) )
                    {
                        $value = $dispositif_data['etapes'][$etape['id']][$habilitation];
                    }

                    $modal .= '                 <tr id="' . $etape['id'] . '" data-role="etape">';
                    $modal .= '                     <th scope="row">';
                    $modal .=                           $etape['name'];
                    $modal .= '                     </th>';
                    $modal .= '                     <td>';
                    $modal .= '                         <i class="far" id="' . $habilitation . '_' . $etape['id'] . '" name="' . $habilitation . '_' . $etape['id'] . '" data-role="habilitation-etape" data-name="' . $habilitation . '" data-value="' . $value . '"></i>';
                    $modal .= '                     </td>';
                    $modal .= '                 </tr>';
                }
            }
        }

        $modal .= '                 </tbody>';
        $modal .= '             </table>';
        $modal .= '         </div>';
        $modal .= '     </div>';
        $modal .= '  </div>';
        $modal .= '</div>';

        return $modal;
    }

    private function getValue($habilitation_value)
    {
        $value = 'none';

        if( $habilitation_value == 1 )
        {
            $value = 'all';
        }

        return $value;
    }
}

