<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/Tasks/Task.php');

class CustomTask extends Task
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Surcharge de la fonction formatStartAndDueDates pour assurer la compatibilité des formats de date
     * 
     * La fonction originale utilise to_display_date qui ne gère pas correctement les formats de date
     * non-américains (mm/dd/yyyy). Cette surcharge utilise fromDb et asUserDate pour :
     * - Convertir correctement la date depuis le format de la base de données
     * - Respecter les préférences de format de date de l'utilisateur
     * - Assurer la cohérence de l'affichage des dates dans l'interface
     * 
     * @param array &$task_fields Tableau des champs de la tâche à formater
     * @param string $dbtime Date/heure au format base de données
     * @param bool $override_date_for_subpanel Flag pour surcharger la date dans les sous-panneaux
     */
    public function formatStartAndDueDates(&$task_fields, $dbtime, $override_date_for_subpanel = false)
    {
        global $timedate;

        if (empty($dbtime)) {
            return;
        }

        $today = $timedate->nowDbDate();

        // Convert to DateTime object first
        $date = $timedate->fromDb($dbtime);
        if ($date) {
            $task_fields['TIME_DUE'] = $timedate->to_display_time($dbtime);
            $task_fields['DATE_DUE'] = $timedate->asUserDate($date);
        }

        $date_due = $task_fields['DATE_DUE'];

        $dd = $timedate->to_db_date($date_due, false);
        $taskClass = 'futureTask';
        if ($dd < $today) {
            if ($task_fields['STATUS'] == 'Completed' || $task_fields['STATUS'] == 'Deferred') {
                $taskClass = '';
            } else {
                $taskClass = 'overdueTask';
            }
        } else {
            if ($dd == $today) {
                $taskClass = 'todaysTask';
            }
        }

        $task_fields['DATE_DUE'] = "<font class='$taskClass'>$date_due</font>";
        if ($override_date_for_subpanel) {
            $task_fields['DATE_START'] = "<font class='$taskClass'>$date_due</font>";
        }
    }
}
