<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}


function generateFieldDefsJS2()
{
    global $app_list_strings, $beanList, $beanFiles;


    $badFields = array(
        'account_description',
        'contact_id',
        'lead_id',
        'opportunity_amount',
        'opportunity_id',
        'opportunity_name',
        'opportunity_role_id',
        'opportunity_role_fields',
        'opportunity_role',
        'campaign_id',
        // User objects
        'id',
        'user_preferences',
        'accept_status',
        'user_hash',
        'authenticate_id',
        'sugar_login',
        'reports_to_id',
        'reports_to_name',
        'is_admin',
        'receive_notifications',
        'modified_user_id',
        'modified_by_name',
        'created_by',
        'created_by_name',
        'accept_status_id',
        'accept_status_name',
        'ops_etape_id',
        'ops_statut_id',
        'champs_custom',
        'latitude',
        'longitude',
        'statut_geoloc',
        'citycode',
        'ordre_onglet',
        'ops_personne_individu',
        'personne_individu',
        'personne_morale',
        'email',
        'email_cc',
        'email_cci',
        'beneficiaire_id',
        'lien_demande_cde',
        'securitygroup_noninherit_id',
        'title',
        'phone_fax',
        'phone_work',
        'phone_other',
        'photo',
        'lawful_basis',
        'date_reviewed',
        'lawful_basis_source',
        'alt_address_street',
        'alt_address_street_2',
        'alt_address_street_3',
        'alt_address_city',
        'alt_address_state',
        'alt_address_postalcode',
        'alt_address_country',
        'assistant',
        'assistant_phone',
        'email_addresses_non_primary',
        'primary_address_street_1',
        'ops_type_personne_ops_individu_name',
        'industry',
        'annual_revenue',
        'rating',
        'ownership',
        'employees',
        'ticker_symbol',
        'shipping_address_street',
        'shipping_address_street_2',
        'shipping_address_street_3',
        'shipping_address_street_4',
        'shipping_address_city',
        'shipping_address_state',
        'shipping_address_postalcode',
        'shipping_address_country',
        'reference',
        'role',
        'ops_formule_id',
        'formule_appel_courrier',
        'ops_formule1_id',
        'formule_politesse_courrier',
        'ops_formule2_id',
        'formule_appel_email',
        'ops_formule3_id',
        'formule_politesse_email',
        'ops_individu_id',
        'ops_individu1_id',
        'intervenant_mandataire_mor',
        'billing_address_street_1',
        'ops_type_personne_ops_personne_morale_name',
        'ops_commission_ops_dossier_name',
        'usertype',
        'employee_status',
        'elus',
        'demandeur'
    );

    $loopControl = array();
    $prefixes = array();

    foreach ($app_list_strings['moduleList'] as $key => $name) {
        if (isset($beanList[$key]) && isset($beanFiles[$beanList[$key]]) && !str_begin($key, 'AOW_')) {
            require_once($beanFiles[$beanList[$key]]);
            $focus = new $beanList[$key];
            $loopControl[$key][$key] = $focus;
            $prefixes[$key] = strtolower($focus->object_name) . '_';
            if ($focus->object_name == 'Case') {
                $prefixes[$key] = 'a' . strtolower($focus->object_name) . '_';
            }
        }
    }

    $contact = BeanFactory::newBean('Contacts');
    $lead = BeanFactory::newBean('Leads');
    $prospect = BeanFactory::newBean('Prospects');

    $loopControl['Contacts'] = array(
        'Contacts' => $contact,
        'Leads' => $lead,
        'Prospects' => $prospect,
    );

    $prefixes['Users'] = 'contact_user_';


    $collection = array();
    foreach ($loopControl as $collectionKey => $beans) {
        $collection[$collectionKey] = array();

        if($collectionKey == 'Users' && !empty($app_list_strings['replace_variable_users'])){
            foreach($app_list_strings['replace_variable_users'] as $relate_name => $optionLabel){
                $optionKey = strtolower("{$prefixes[$collectionKey]}{$relate_name}");
                $collection[$collectionKey][] = array("name" => $optionKey, "value" => $optionLabel);
            }        
        }else{
            foreach ($beans as $beankey => $bean) {
                foreach ($bean->field_defs as $key => $field_def) {
                    if (    /*($field_def['type'] == 'relate' && empty($field_def['custom_type'])) ||*/
                        ($field_def['type'] == 'assigned_user_name' || $field_def['type'] == 'link') ||
                        ($field_def['type'] == 'bool') ||
                        (in_array($field_def['name'], $badFields))
                    ) {
                        continue;
                    }
                    if (!isset($field_def['vname'])) {
                        //echo $key;
                    }
                    // valid def found, process
                    $optionKey = strtolower("{$prefixes[$collectionKey]}{$key}");
                    if (isset($field_def['vname'])) {
                        $optionLabel = preg_replace('/:$/', "", translate($field_def['vname'], $beankey));
                    } else {
                        $optionLabel = preg_replace('/:$/', "", $field_def['name']);
                    }
                    $dup = 1;
                    foreach ($collection[$collectionKey] as $value) {
                        if ($value['name'] == $optionKey) {
                            $dup = 0;
                            break;
                        }
                    }
                    if ($dup) {
                        $collection[$collectionKey][] = array("name" => $optionKey, "value" => $optionLabel);
                    }
                }
            }
        }
    }

    $customModules = [
        'OPS_individu' => OPS_individu::get_field_list(false, true),
        'OPS_personne_morale' => OPS_personne_morale::get_field_list(false),
    ];

    # Surcharge module Partenaires
    if(isset($app_list_strings['moduleList']['OPS_avis'])){
        $customModules['OPS_avis'] = OPS_avis::get_field_list();
    }
    # Fin surcharge module partenaires

    foreach($customModules as $module_key => $field_list)
    {
        $selectListeDefautModule = '';
        foreach($field_list as $onglet_key => $onglet)
        {
            $selectListeDefautModule .= '<optgroup label="' . $onglet['libelle'] . '">';

            foreach ($onglet['champs'] as $champ) 
            {
                $selectListeDefautModule .= '<option value="' . $champ['name'] . '">' . $champ['libelle'] . '</option>';
            }

            $selectListeDefautModule .= '</optgroup>';
        }
        $collection[$module_key] = $selectListeDefautModule;
    }

    $customModules = [];
    if(isset($app_list_strings['moduleList']['OPS_bon'])) $customModules['OPS_bon'] = OPS_bon::get_field_list();
    
    if(!empty($customModules)){
        foreach($customModules as $module_key => $field_list)
        {
            $collection[$module_key] = [];
            foreach ($field_list as $field_key => $field) 
            {
                $key = strtolower($module_key . '_' . $field_key);
                $collection[$module_key][] = array("name" => $key, "value" => $field);
            }
        }
    }

    $json = getJSONobj();
    $ret = "var field_defs = ";
    $ret .= $json->encode($collection, false);
    $ret .= ";";
    return $ret;
}

function genDropDownJS2()
{
    global $app_list_strings, $beanList, $beanFiles;

    $lblContactAndOthers = implode('/', array(
        isset($app_list_strings['moduleListSingular']['Contacts']) ? $app_list_strings['moduleListSingular']['Contacts'] : 'Contact',
        isset($app_list_strings['moduleListSingular']['Leads']) ? $app_list_strings['moduleListSingular']['Leads'] : 'Lead',
        isset($app_list_strings['moduleListSingular']['Prospects']) ? $app_list_strings['moduleListSingular']['Prospects'] : 'Target',
    ));

    $dropdown = '';

    array_multisort($app_list_strings['moduleList'], SORT_ASC, $app_list_strings['moduleList']);

    foreach ($app_list_strings['moduleList'] as $key => $name) {
        if (isset($beanList[$key]) && isset($beanFiles[$beanList[$key]]) && !str_begin($key, 'AOW_') && !str_begin($key, 'zr2_')) {
            if ($key == 'Contacts') {
                $dropdown .= "<option value='" . $key . "'>
                        " . $lblContactAndOthers . "
                   </option>";
            } else {
                if (isset($app_list_strings['moduleListSingular'][$key])) {
                    $dropdown .= "<option value='" . $key . "'>
                        " . $app_list_strings['moduleListSingular'][$key] . "
                   </option>";
                } else {
                    $dropdown .= "<option value='" . $key . "'>
                        " . $app_list_strings['moduleList'][$key] . "
                   </option>";
                }
            }
        }
    }


    return $dropdown;
}

function genDropDownJS2Custom()
{
    global $app_list_strings, $beanList, $beanFiles;

    $dropdown = '';

    $emailModuleList = $app_list_strings['ops_EmailTemplates_modules'];

    foreach ($emailModuleList as $moduleKey => $moduleLabel ) 
    {
        if ((isset($beanList[$moduleKey]) && isset($beanFiles[$beanList[$moduleKey]]) && !str_begin($moduleKey, 'AOW_') && !str_begin($moduleKey, 'zr2_')) || $moduleKey == 'demandeur' || $moduleKey == 'beneficiaire' || $moduleKey == 'personne_individu_fonction') 
        {
            $dropdown .= "<option value='" . $moduleKey . "'>
                        " . $moduleLabel . "
                   </option>";
        }
    }

    return $dropdown;
}
