<?php

if (!defined('sugarEntry') || !sugarEntry)
	die('Not A Valid Entry Point');

global $db, $beanFiles, $log, $current_user, $sugar_config;
require_once($beanFiles["OPS_agendas"]);
require_once($beanFiles["OPS_individu"]);

$current_user = new User();
$current_user->getSystemUser();

if (isset($current_user) && !empty($current_user->id)) {

	function get_liste_individu_trouves()
	{
		$liste_individu_trouves = array();

		foreach ($_POST['array_champs'] as $key => $value) {
			switch ($key) {
				case 'telephone':
					if ($value != "") {
						if (empty($where)) {
							$where = 'REPLACE(ops_individu.phone_mobile, ".", "") = "' . str_replace('.', '', $value) . '"';
						} else {
							$where .= ' AND REPLACE(ops_individu.phone_mobile, ".", "") = "' . str_replace('.', '', $value) . '"';
						}
					}
					$exitLoop = true;
					break;
				case 'date_naissance':
					$value = implode('-', array_reverse(explode('/', $value)));
					break;
				default:
					$value = html_entity_decode($value);
					break;
			}

			if ($exitLoop === true) {
				continue;
			}

			if ($key == 'telephone') {
				$key = 'phone_mobile';
			}

			if ($value != "") {
				if (empty($where)) {
					$where = 'ops_individu.' . $key . ' LIKE "%' . $value . '%"';
				} else {
					$where .= ' AND ops_individu.' . $key . ' LIKE "%' . $value . '%" ';
				}
			}
		}

		if ($where != "") {
			$bean_individu = BeanFactory::newBean('OPS_individu');

			// On récupère les 11 premiers résultats correspondants
			$bean_list = $bean_individu->get_list(
				'name',
				$where,
				0,
				11,
				-1,
				0
			);

			foreach ($bean_list['list'] as $num => $bean) {

				// On passe l'adresse en tableau pour pouvoir supprimer les lignes vides et repasse en chaine de caractère
				$tmp = explode("\n", $bean->primary_address_street);
				$tmp = array_filter($tmp);
				$address = implode(", ", $tmp);

				// On peuple le tableau des résultats de la recherche pour affichage
				$liste_individu_trouves[$num]['id'] = $bean->id;
				$liste_individu_trouves[$num]['type_individu'] = $bean->type_individu;
				$liste_individu_trouves[$num]['salutation'] = $bean->salutation;
				$liste_individu_trouves[$num]['name'] = html_entity_decode($bean->name);
				$liste_individu_trouves[$num]['nom_usage'] = html_entity_decode($bean->nom_usage);
				$liste_individu_trouves[$num]['last_name'] = html_entity_decode($bean->last_name);
				$liste_individu_trouves[$num]['first_name'] = html_entity_decode($bean->first_name);
				$liste_individu_trouves[$num]['date_naissance'] = implode('/', array_reverse(explode('-', $bean->date_naissance)));
				$liste_individu_trouves[$num]['email'] = $bean->emailAddress->getPrimaryAddress($bean);
				$liste_individu_trouves[$num]['phone_number'] = $bean->phone_mobile;
				$liste_individu_trouves[$num]['primary_address_num'] = html_entity_decode($bean->primary_address_number);
				$liste_individu_trouves[$num]['primary_address_street'] = html_entity_decode($address);
				$liste_individu_trouves[$num]['primary_address_bat'] = html_entity_decode($bean->primary_address_complement_batiment);
				$liste_individu_trouves[$num]['primary_address_lieu'] = html_entity_decode($bean->primary_address_complement_lieu);
				$liste_individu_trouves[$num]['primary_address_postalcode'] = $bean->primary_address_postalcode;
				$liste_individu_trouves[$num]['primary_address_city'] = $bean->primary_address_city;
				$liste_individu_trouves[$num]['organisme_c'] = $bean->organisme_c;
			}
		}

		return $liste_individu_trouves;
	}

	$list = get_liste_individu_trouves();

	echo json_encode($list);
} else {
	return "";
}
