<?php
/*
Author     : LANTEAS
*/

class hook_agendas
{

	/**
	 * Hook de suppression des relations de l'agenda supprimé
	 */
	public function delete_relation_agenda(&$bean, $event, $arguments = null)
	{

		if ($event != 'before_delete') {
			return;
		}

		global $beanFiles, $current_user;
		require_once($beanFiles["OPS_agendas_motifs"]);
		require_once($beanFiles["OPS_plage_ouverture"]);
		require_once($beanFiles["OPS_exception"]);
		require_once($beanFiles["OPS_agendas_ressources"]);
		require_once($beanFiles["OPS_agendas_droits"]);
		require_once($beanFiles["Meeting"]);



		// Suppression des motifs
		$motifs = $bean->get_linked_beans('ops_agendas_motifs_ops_agendas', 'OPS_agendas_motifs');
		foreach ($motifs as $key => $un_motif) {

			$obj_motif = new OPS_agendas_motifs();
			$obj_motif->mark_deleted($un_motif->id);

		}

		// Suppression des plages ouvertures
		$plages_ouverture = $bean->get_linked_beans('ops_agendas_ops_plage_ouverture', 'OPS_plage_ouverture');
		foreach ($plages_ouverture as $key => $une_po) {

			$obj_plage_ouvert = new OPS_plage_ouverture();
			$obj_plage_ouvert->mark_deleted($une_po->id);

		}

		// Suppression des exceptions
		$exceptions = $bean->get_linked_beans('ops_agendas_ops_exception', 'OPS_exception');
		foreach ($exceptions as $key => $une_except) {

			$obj_except = new OPS_exception();
			$obj_except->mark_deleted($une_except->id);

		}

		// Suppression des ressources
		$ressources = $bean->get_linked_beans('ops_agendas_ressources_ops_agendas', 'OPS_agendas_ressources');
		foreach ($ressources as $key => $une_ressource) {

			$obj_ressources = new OPS_agendas_ressources();
			$obj_ressources->mark_deleted($une_ressource->id);

		}

		// Suppression des droits de l'agenda
		$droits = $bean->get_linked_beans('ops_agendas_droits_ops_agendas', 'OPS_agendas_droits');
		foreach ($droits as $key => $un_droit) {

			$obj_droit = new OPS_agendas_droits();
			$obj_droit->mark_deleted($un_droit->id);

		}

		// Suppression des rendez-vous liés à l'agenda
		$rendez_vous = $bean->get_linked_beans('ops_agendas_meetings', 'Meeting');
		foreach ($rendez_vous as $key => $un_rdv) {

			$obj_meeting = new Meeting();
			$obj_meeting->mark_deleted($un_rdv->id);

		}
	}

	
	/**
	 * hook de creation des exceptions liés à la récurrence
	 * A la sauvegarde de l'agenda si modification de la date de fin
	 */
	public function create_exceptions_reccurence($bean, $event, $argument = null)
	{

		if ($event != "after_save") {
			return;
		}

		global $beanFiles;
		require_once($beanFiles["OPS_plage_ouverture"]);
		require_once($beanFiles["OPS_exception"]);


		$obj_agenda = $bean;
		$bool_date_fin_change = false;


		if (!empty($_POST['jours_glissement_fin']) || !empty($_POST['date_fin'])) {

			// Récupération des dates de début de récurrence
			$date_fin_bean = DateTime::createFromFormat("Y-m-d", $bean->fetched_row['date_fin']);
			$date_fin_post = DateTime::createFromFormat("d/m/Y", $_POST['date_fin']);

			$nb_jour_bean = $bean->fetched_row['jours_glissement_fin'];
			$nb_jour_post = $_POST['jours_glissement_fin'];

			if ($date_fin_bean !== $date_fin_post || $nb_jour_bean !== $nb_jour_post) {
				$bool_date_fin_change = true;
			}
		}

		if ($bool_date_fin_change) {

			// Création uniquement si on les a activés et qu'on a mit autre chose que "toutes les semaines"
			$where = " ops_plage_ouverture.recurrence != '* * *' AND ops_plage_ouverture.recurrence_active = 1 AND ops_plage_ouverture.deleted = 0 ";
			$lst_obj_plages = $obj_agenda->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_plage_ouverture", "name", 0, -1, 0, $where);


			foreach ($lst_obj_plages as $key => $plage) {

				$plage->date_derniere_occurrence = '';
				$plage->save();

				$obj_plage = BeanFactory::getBean('OPS_plage_ouverture', $plage->id);

				if ($obj_plage->date_derniere_occurrence == '') {
					$plage->init_exceptions_recurrence();
				}
			}
		}
	}

}