var jquery = jQuery.noConflict();

jquery(document).ready(function () {

    jquery('[role=section_title]').closest('.detail-view-field').css("background-color", "rgb(0,0,0,0)");
    jquery('[role=section_title]').parent().css("width", "100%");
    jquery('[role=section_title]').show();

    //Build Json with all events
    var familyEventList = getEventDecode('event_list');
    var eventList = getEventList(familyEventList);

    jquery('#calendar').fullCalendar({
		locale: 'fr',
		defaultView: 'agendaWeek',
		slotDuration: '00:30:00',
		slotLabelInterval: "01:00",
		slotLabelFormat: 'HH:mm',
		height: 700,
		aspectRatio: 15,
		timeFormat: 'HH:mm',
		allDaySlot: false,
		weekends: true, 
		views: {
			month: {
				buttonText: "Mois",
				eventLimit: 5,
			},
			calendarWeek: {
				buttonText: "Semaine",
				eventLimit: 6,
			},
			agendaDay: {
				buttonText: "Jour",
			},
		},
        header: {
			left: 'prev,next',
			center: 'title',
			right: 'month,agendaWeek,agendaDay',
		},

        events: eventList,
    });

    function getEventDecode(inputId)
    {
        var familyEventListDecode = {};
        if ( jquery('#' + inputId).length && jquery('#' + inputId).val() != '')
        {
            familyEventListDecode = JSON.parse( atob( jquery('#' + inputId).val() ) );
        }  
        return familyEventListDecode;
    }

    function getEventList(familyEventList)
    {
        var eventList = [];
        for (family in familyEventList)
        {
            if(family != '' && jquery('input[value=' + family  + ']').length )
            {
                var familyId = jquery('input[value=' + family  + ']').attr('id');
                var familyLabel = jquery('#' + familyId.replace('_select', '') + '_name').val();
                var familyColor = jquery('#' + familyId.replace('_select', '') + '_couleur').val();

                for (eventKey in familyEventList[family])
                {
                    eventDay = familyEventList[family][eventKey];
                    eventList.push({
                        id: eventDay,
                        groupId: family,
                        title: familyLabel,
                        start: eventDay + 'T00:00',
                        end: eventDay + 'T23:59',
                        color: 'white',
                        display: 'block',
                        backgroundColor: familyColor,
                    });     
                }
            }
        }    
        return eventList;
    }

    // Get the date in this format "YYYY-MM-DD"
    function getFormattedDate(date)
    {
        var month = date.getMonth() + 1;
        var day = date.getDate();

        return date.getFullYear() + '-' + (month < 10 ? '0' : '') + month + '-' + (day < 10 ? '0' : '') + day;
    }

    var labelArea = jquery('#calendrier').closest('.detail-view-row-item').find('> .label');

    var buttonArea = '<div class="row align-items-center"><div class="col">';

    if( jquery('#famille_1').val() != '' )
    {
        var familyButton1 = '<div class="famille famille-1">';
        familyButton1 += '<label for="select_famille_1" class="famille-checked">' + jquery('#famille_1_name').val() + '</label>';
        familyButton1 += '<input type="radio" name="select_famille" id="select_famille_1" value="' + jquery('#famille_1').val() + '">';
        familyButton1 += '</div>';
        
        buttonArea += familyButton1;
    }

    if( jquery('#famille_2').val() != '' )
    {
        var familyButton2 = '<div class="famille famille-2">';
        familyButton2 += '<label for="famille_2_select" class="famille-checked">' + jquery('#famille_2_name').val() + '</label>';
        familyButton2 += '<input type="radio" name="select_famille" id="famille_2_select" value="' + jquery('#famille_2').val() + '">';
        familyButton2 += '</div>';

        buttonArea += familyButton2;
    }

    buttonArea += '</div></div>';

    labelArea.append(buttonArea);
});