var FilConversationnel = (function($) {

  return {

    self: this,
    version: '1.0.0',
    name: 'FilConversationnel',

    _bootstrap: function() {

      FilConversationnel.self = this;

      try {
        FilConversationnel.Config = {};

        if( typeof(DetailView_UIControler) != 'undefined' ){
          DetailView_UIControler.addModule( FilConversationnel );
        }
        const self = FilConversationnel.self;

      } catch (_x) {
        console.warn(_x, FilConversationnel);
      }

      void FilConversationnel.initInterface();

    },

    initInterface: () => {
      const self = FilConversationnel.self;

      void self.buildTabContent();
      void self.getFilConversationnel();

      void self.bindControls();
      new Promise( resolve => { void FilConversationnel.fetchMessages(); resolve() } );
    },


    buildTabContent: () => {
      const self = FilConversationnel.self;


      // Build tabitem and add to items bar.
      let template_f2c_content = $('template[id="ops_dossier_f2c_content"]').wrap();
      let _tpl_f2c_content = template_f2c_content.get(0).innerHTML;
      let Content_f2c = $( String( _tpl_f2c_content ).trim() );
      
      let test = $('#onglet_fil_conversationnel')
      test.append(Content_f2c);

      Content_f2c = $('#onglet_fil_conversationnel');

      // Bind Tabitem behavior
      var Tab_f2c = $('#bouton_tab_fil_conversationnel');
      Tab_f2c.off().on( 'click' , function(e){

        $('#onglet-boutons li a').removeClass("active");
        $(this).find('a').addClass("active");

        $("#onglet-content  .onglet-layout").each(function(i,layout) {
            if( $(layout).attr('rel') === 'fil_conversationnel' ){
              $(layout).fadeIn();
              window.setTimeout( function(){
                void self.markUnreadMessagesAsRead();
              }, 800 );
            }else{
              $(layout).hide();
            }
        });      

      } );

      FilConversationnel.Config.tab = Tab_f2c;
      FilConversationnel.Config.layout = Content_f2c;
      FilConversationnel.Config.parent_id = Content_f2c.attr('data-record-id');
      FilConversationnel.Config.parent_type = Content_f2c.attr('data-record-type');
      FilConversationnel.Config.conversation_statut = 'fermee'; // On a défini cet état par défaut.

    },


    setLoading: () => {
      const self = FilConversationnel.self;
      $(self.Config.layout.get()).addClass('loading');
    },

    unsetLoading: () => {
      const self = FilConversationnel.self;
      $(self.Config.layout.get()).removeClass('loading');
    },


    getFilConversationnel: async () => {
      const self = FilConversationnel.self;
      
      void self.setLoading();

      let data = {};
          data.id       = FilConversationnel.Config.parent_id;
          data.origin_module   = FilConversationnel.Config.parent_type;
      let url = '/index.php?module=OPS_conversation&action=fetchConversationState';

      jQuery.post( url, 
          data
          ).done(function(result)   {
              
              let Result = JSON.parse( String(result) );

              FilConversationnel.Config.conversation_statut = String(Result.conversation_statut);
              let btn_close_conversation = $(FilConversationnel.Config.layout.get()).find('#close_conversation');
              let badge_cercle = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle');
              let badge_cercle_picto = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle-picto');
              let text_color =  $(FilConversationnel.Config.layout.get()).find('[role="conversation-statut"] [role="statut"]');

              if( FilConversationnel.Config.conversation_statut == 'fermee'){
                btn_close_conversation.hide();
                badge_cercle_picto.css('background-color', '#dd2f2f');
                text_color.css('color', '#dd2f2f');
                badge_cercle.css('background', 'rgba(221, 47, 47, 0.1)');

              }else{
                btn_close_conversation.show(); 
                badge_cercle_picto.css('background-color', '#75bd2c');
                text_color.css('color', '#75bd2c');
                badge_cercle.css('background', 'rgba(117, 189, 44, 0.1)');
              }

              $(FilConversationnel.Config.layout.get()).find('[role="statut"]').html( String(Result.conversation_label) );


              let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');
              void FilConversationnel.changeSendButtonCaption( {evt:{target:chk_close_message.get(0)}} );

          }).fail(function(x) {
              console.log( x );
              alert("Une erreur s'est produite, veuillez contacter l'administrateur");
              return;

          }).always(function() {
              void self.unsetLoading();
          });

    },


    bindControls: () => {
      const self = FilConversationnel.self;
      
      let btn_send_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #send_message');
      btn_send_message.off().on( 'click' , self.sendMessage );

      let btn_close_conversation = $(FilConversationnel.Config.layout.get()).find('#close_conversation');
      btn_close_conversation.off().on( 'click' , function(evt){ self.setConversationState('fermee') } );

      let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');
      chk_close_message.off().on( 'change' , self.changeSendButtonCaption );
 
    },


    setConversationState: (conversation_statut) => {
      const self = FilConversationnel.self;
      
        void self.setLoading();
        let data = {};
            data.id              = FilConversationnel.Config.parent_id;
            data.origin_module   = 'OPS_dossier';
            data.conversation_statut  = conversation_statut;

        let url = '/index.php?module=OPS_conversation&action=setConversationState';

        jQuery.post( url, 
            data
            ).done(function(result)   {
                
              let Result = JSON.parse( String(result) );

              FilConversationnel.Config.conversation_statut = String(Result.conversation_statut);
              $(FilConversationnel.Config.layout.get()).find('[role="statut"]').html( String(Result.conversation_label) );

              let btn_close_conversation = $(FilConversationnel.Config.layout.get()).find('#close_conversation');
              let badge_cercle = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle');
              let badge_cercle_picto = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle-picto');
              let text_color =  $(FilConversationnel.Config.layout.get()).find('[role="conversation-statut"] [role="statut"]');
              if( FilConversationnel.Config.conversation_statut == 'fermee'){
                btn_close_conversation.hide();
                badge_cercle_picto.css('background-color', '#dd2f2f');
                text_color.css('color', '#dd2f2f');
                badge_cercle.css('background', 'rgba(221, 47, 47, 0.1)');       
              }else{
                btn_close_conversation.show(); 
                badge_cercle_picto.css('background-color', '#75bd2c');
                text_color.css('color', '#75bd2c');
                badge_cercle.css('background', 'rgba(117, 189, 44, 0.1)');
              }              

              let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');
              void FilConversationnel.changeSendButtonCaption( {evt:{target:chk_close_message.get(0)}} );

              void self.unsetLoading();

            }).fail(function(x) {
                console.log( x );
                alert("Une erreur s'est produite, veuillez contacter l'administrateur");
                return;

            }).always(function() {
                void self.unsetLoading();
            });



    },



    sendMessage: (e) => {
      const self = FilConversationnel.self;
      
      let text_message = $(FilConversationnel.Config.layout.get()).find('[role="writing-message"] #text_message');
      let dom_html = new DOMParser()
        .parseFromString( String( text_message.val() ).trim() , 'text/html');
      let message = dom_html.body.textContent || '';

      let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');

      // Check if message is not empty.
      if(String( message ).trim() != ""){

        void self.setLoading();


        let data = {};
            data.id              = FilConversationnel.Config.parent_id;
            data.origin_module   = 'OPS_dossier';

            data.b64_message = btoa( unescape( encodeURIComponent( String( message ).trim() ) ) );

            // Cas de fermeture automatique juste après envoi du mesage par l'agent (checkbox).
            statut = $(chk_close_message).is(':checked')? 'fermee' : 'ouverte';
            data.conversation_statut = statut;
            data.conversation_origin = 'agent';

        let url = '/index.php?module=OPS_conversation&action=sendMessage';

        jQuery.post( url, 
            data
            ).done(function(result)   {
                
                let Result = JSON.parse( String(result) );
                
                FilConversationnel.Config.conversation_statut = String(Result.conversation_statut);
                $(FilConversationnel.Config.layout.get()).find('[role="statut"]').html( String(Result.conversation_label) );

                // Check posting message confirmation
                if( String(Result.message_id) != "" && Result.message_id.length == 36 ){

                  // Perhaps re)open chat..
                  let btn_close_conversation = $(FilConversationnel.Config.layout.get()).find('#close_conversation');
                  let badge_cercle = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle');
                  let badge_cercle_picto = $(FilConversationnel.Config.layout.get()).find('.los-badge-cercle-picto');
                  let text_color =  $(FilConversationnel.Config.layout.get()).find('[role="conversation-statut"] [role="statut"]');
                  if( FilConversationnel.Config.conversation_statut == 'fermee'){
                    btn_close_conversation.hide();
                    badge_cercle_picto.css('background-color', '#dd2f2f');
                    text_color.css('color', '#dd2f2f');
                    badge_cercle.css('background', 'rgba(221, 47, 47, 0.1)');     
                  }else{
                    btn_close_conversation.show();
                    badge_cercle_picto.css('background-color', '#75bd2c');
                    text_color.css('color', '#75bd2c');
                    badge_cercle.css('background', 'rgba(117, 189, 44, 0.1)');                    
                  }


                  // Anyway...
                  $(FilConversationnel.Config.layout.get()).find('[role="conversation-empty"]').hide();

                  self.buildHtmlMessage( {
                    id: Result.message_id,
                    statut: Result.message_statut,
                    label: Result.message_label,
                    stamp: Result.message_stamp,
                    origin: Result.message_origin,
                    sender: Result.message_sender,
                    content: String( text_message.val() ).trim(), /*Performance, get directly from here*/
                  } );

                  void self.clearWritingZone();

                  let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');
                  void FilConversationnel.changeSendButtonCaption( {evt:{target:chk_close_message.get(0)}} );

                  void self.unsetLoading();

                }


            }).fail(function(x) {
                console.log( x );
                alert("Une erreur s'est produite, veuillez contacter l'administrateur");
                return;

            }).always(function() {
                void self.unsetLoading();
            });

      }


    },


    buildHtmlMessage: (Message) => {
      const self = FilConversationnel.self;

      // <div class="stamp"><span></span></div>
      let template_f2c_stamp = $('template[id="ops_dossier_f2c_stamp"]').wrap();
      let _tpl_f2c_stamp = template_f2c_stamp.get(0).innerHTML;
      let Stamp_f2c = $( String( _tpl_f2c_stamp ).trim() );

      let human_date = self.getMDateFromStamp(Message.stamp);

      Stamp_f2c.find('span').html( human_date ); // Format properly


      // <div class="message" rel="">
      //     <p>/p>
      // </div>
      let template_f2c_message = $('template[id="ops_dossier_f2c_message"]').wrap();
      let _tpl_f2c_message = template_f2c_message.get(0).innerHTML;
      let Message_f2c = $( String( _tpl_f2c_message ).trim() );
      
      Message_f2c.attr('rel', String(Message.origin).toLowerCase() );
      Message_f2c.attr('data-message-id', String(Message.id) );
      Message_f2c.find('p[role="message-content"]').html( self.parseMessageInHtml(Message.content) );

      Message_f2c.find('p[role="message-statut"]').html( Message.sender );
      Message_f2c.find('p[role="message-statut"]').attr( 'data-statut', Message.statut );


      let feed_messages = $(FilConversationnel.Config.layout.get()).find('[role="feed_messages"]');

      $(feed_messages).append( Stamp_f2c );
      $(feed_messages).append( Message_f2c );

    },

    parseMessageInHtml: (content) => {
      const self = FilConversationnel.self;

      content = String(content).replace(/(\r\n|\r|\n)/g, '<br>');

      return content;
    },

    getMDateFromStamp: (_stamp) => {
      const self = FilConversationnel.self;

      var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
      // JSDateStampFormat : "2011-12-21T13:48:00.000"
      let stamp_date = "";
          stamp_date+= _stamp.substring(0,4) +'-'+ _stamp.substring(4,6) +'-'+ _stamp.substring(6,8);
          stamp_date+= 'T';
          stamp_date+= _stamp.substring(8,10) +':'+ _stamp.substring(10,12) +':'+ _stamp.substring(12,14);
          stamp_date+= '.';
          stamp_date+= _stamp.substring(14,17);

      let today  = new Date( String(stamp_date) );
      let human_date = today.toLocaleDateString("fr-FR", options);

      return human_date +' à '+ _stamp.substring(8,10) +':'+ _stamp.substring(10,12);
    },

    clearWritingZone: () => {
      const self = FilConversationnel.self;

      let text_message = $(FilConversationnel.Config.layout.get()).find('[role="writing-message"] #text_message');
      let chk_close_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #close_message');

      $(text_message).val('');
      $(chk_close_message).prop('checked', false).removeAttr('checked');


    },

    changeSendButtonCaption: (evt) => {
      const self = FilConversationnel.self;

      let btn_send_message = $(FilConversationnel.Config.layout.get()).find('[role="controls"] #send_message');
      let btn_caption = 'Envoyer';
          if( FilConversationnel.Config.conversation_statut == 'fermee' ){
            btn_send_message.val( ( $(evt.target).is(':checked')? 'Envoyer et refermer la conversation' : 'Envoyer et ouvrir la conversation') );
          }else{
            btn_send_message.val( ( $(evt.target).is(':checked')? 'Envoyer et fermer la conversation' : 'Envoyer') );
          }

    },


    fetchMessages: async () => {
      const self = FilConversationnel.self;

      void self.setLoading();
      let data = {};
          data.id              = FilConversationnel.Config.parent_id;
          data.origin_module   = FilConversationnel.Config.parent_type;


      let url = '/index.php?module=OPS_conversation&action=fetchMessages';

      jQuery.post( url, 
          data
          ).done(function(result)   {

              let Result = JSON.parse( String(result) );

                if( $.isArray( Result ) ){

                  if( Result.length > 0 ){
                    $(FilConversationnel.Config.layout.get()).find('[role="conversation-empty"]').hide();
                  }

                  $.each( Result , function(i,M){

                    self.buildHtmlMessage( {
                      id: M.id,
                      statut: M.statut,
                      label: M.label,
                      stamp: M.stamp,
                      origin: M.origin,
                      sender: M.sender,
                      content: decodeURIComponent(escape(atob( String(M.message) ))),
                    } );

                    // Flag potential undread messages (usager)
                    if( M.origin == 'usager' && M.statut == 'nouveau' ){
                      void self.flagTabNotifyUnread();
                    }

                  } );


                }

              void self.unsetLoading();

          }).fail(function(x) {
              console.log( x );
              alert("Une erreur s'est produite, veuillez contacter l'administrateur");
              return;

          }).always(function() {
              void self.unsetLoading();
          });

    
    },

    
    getLastMessage: () => {
      const self = FilConversationnel.self;

      let data = {};
          data.id              = FilConversationnel.Config.parent_id;
          data.origin_module   = FilConversationnel.Config.parent_type;

      let url = '/index.php?module=OPS_conversation&action=getLastMessage';

      jQuery.post( url, 
          data
          ).done(function(result)   {

              let Result = JSON.parse( String(result) );
              return Result;

          }).fail(function(x) {
              console.log( x );
              alert("Une erreur s'est produite, veuillez contacter l'administrateur");
              return;

          }).always(function() {
              void self.unsetLoading();
          });

    },


    markUnreadMessagesAsRead: () => {
      const self = FilConversationnel.self;

      // Set message (usager) delayed one by one as read!
      let message_usager = $(FilConversationnel.Config.layout.get()).find('.message[rel="usager"] [role="message-statut"][data-statut="nouveau"]:first');
      if( message_usager.length == 1 ){
        let message_id = $(message_usager.get(0)).closest( '.message[rel]' ).attr( 'data-message-id' );

        let data = {};
            data.id              = FilConversationnel.Config.parent_id;
            data.origin_module   = FilConversationnel.Config.parent_type;
            data.message_id      = message_id;
            data.message_statut  = 'lu'; // Want to set as unread, so flag as 'lu'.


        let url = '/index.php?module=OPS_conversation&action=setMessageStatut';

        jQuery.post( url, 
            data
            ).done(function(result)   {

                let Result = JSON.parse( String(result) );

                // Sucess ?
                if( typeof Result == "object" && typeof Result['message_id'] == 'string' ){

                  let $message = $(FilConversationnel.Config.layout.get()).find('.message[rel="usager"][data-message-id="'+Result.message_id+'"]');

                  $message.find('[role="message-statut"]').attr( 'data-statut', Result.message_statut );
                  $message.effect("highlight", {color:'#c3e1c6'}, 600);

                  // Next message ...
                  window.setTimeout( function(){
                    void FilConversationnel.markUnreadMessagesAsRead();
                  } , 350 );

                }



            }).fail(function(x) {
                console.log( x );
                alert("Une erreur s'est produite, veuillez contacter l'administrateur");
                return;

            }).always(function() {
                void self.unsetLoading();
            });

      }

      // No unread message to flag, so remove tabitem notify red point.
      else{
        void self.unflagTabNotifyUnread();
      }

    },


    flagTabNotifyUnread: () => {
      const self = FilConversationnel.self;

      $(FilConversationnel.Config.tab.get()).addClass('notify');
    },

    unflagTabNotifyUnread: () => {
      const self = FilConversationnel.self;

      $(FilConversationnel.Config.tab.get()).removeClass('notify');
    },




  }; // ./Module encapsulation


})(jQuery);
// To instance the FilConversationnel, just call : FilConversationnel._bootstrap();



$(document).ready(function () {

  void FilConversationnel._bootstrap()

});
