$(document).ready(function () {
    /* On ajoute la div des filtres du module Taches dans le panel "Filtres" */
    let div_filtres = document.getElementById('filtres-container');
    let div_filtres_justificatifs = document.getElementById('filtres_justificatifs');
    div_filtres.append(div_filtres_justificatifs);

    /* On ajoute avant le champ "Description" les sélecteurs de colonnes à afficher */
    add_colonne_field('display_tabs_justificatif_div');

    /* On déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné  */
    on_objet_change_justificatif();

    /* Si l'objet est modifié, on déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné */
    $('#dashlet_objet').change(function () {
        on_objet_change_justificatif()
    });

    /* On déclenche le resize des select des colonnes affichées / masquées au déplacement d'une colonne */
    var div_tabs_justificatif = document.getElementById('display_tabs_justificatif_div');
    var chooser_display_tabs_left_arrow = $('#chooser_display_tabs_left_arrow', div_tabs_justificatif)[0];
    var chooser_display_tabs_left_to_right = $('#chooser_display_tabs_left_to_right', div_tabs_justificatif)[0];

    chooser_display_tabs_left_arrow.addEventListener("click", () => {
        $('#display_tabs_justif').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_justif', 'display_tabs_justif')
    }, false);

    chooser_display_tabs_left_to_right.addEventListener("click", () => {
        $('#display_tabs_justif').addClass("display_tabs");
        modify_css_colonnes_select('hide_tabs_justif', 'display_tabs_justif')
    }, false);

    jQuery('#filtres_justificatifs div[id^="checkboxes_"] input[type=checkbox]').each(function () {
        if (this.checked) {
            $('#' + this.id).prop("checked", true);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        } else {
            $('#' + this.id).prop("checked", false);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        }
    });
});

/**
 * Fonction vérifiant le type d'objet sélectionné pour afficher les filtres et le sélecteur de colonnes correspondants
 * 
 * @return {void}
 */
var on_objet_change_justificatif = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet == 'OPS_justificatif') {
        $('#display_tabs_justificatif').parent().show();
        $('#display_tabs_justif').prop('disabled', false);
        $('#filtres_justificatifs').show();
        $('#filtres_justificatifs *').prop('disabled', false);
        $('#li-filtres').show()
    } else {
        $('#display_tabs_justificatif').parent().hide();
        $('#display_tabs_justif').prop('disabled', true);
        $('#filtres_justificatifs').hide();
        $('#filtres_justificatifs *').prop('disabled', true);
    }
}