<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.edit.php');

/**
 * Classe appelée par le view.edit.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_justificatif"
 */
class OPS_justificatifEdit
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres = array())
    {
        global $app_list_strings;

        $liste_types_justifs = array();
        $liste_statuts = array();
        $liste_depots = array();

        // Filtre sur les type de justificatifs
        $bean_type_document = BeanFactory::newBean('OPS_type_document');
        $liste_bean_types = $bean_type_document->get_full_list('objet, name');
        foreach ($liste_bean_types as $bean_type) {
            $name_parent_type = $app_list_strings['ops_type_document_objet_list'][$bean_type->objet];
            $liste_types_justifs[$name_parent_type][$bean_type->id] = $bean_type->name;
        }
        $this->ss->assign('DASHLET_JUSTIFICATIF_FILTRES_TYPE', $liste_types_justifs);

        // Filtre sur les statuts de justificatifs
        $liste_statuts = $app_list_strings['ops_statut_j_list'];
        asort($liste_statuts);
        $this->ss->assign('DASHLET_JUSTIFICATIF_FILTRES_STATUT', $liste_statuts);

        // Filtre sur les dépôts de justificatifs
        $liste_depots = $app_list_strings['ops_depot_j_list'];
        asort($liste_depots);
        $this->ss->assign('DASHLET_JUSTIFICATIF_FILTRES_DEPOT', $liste_depots);

        $this->ss->assign('FILTRE_JUSTIFICATIF_TYPE', $filtres['ops_type_document_ops_justificatif_name']);
        $this->ss->assign('FILTRE_JUSTIFICATIF_STATUT', $filtres['statut']);
        $this->ss->assign('FILTRE_JUSTIFICATIF_DEPOT', $filtres['depot']);

        $this->ss->assign("DASHLET_CHAMPS_JUSTIFICATIF_LISTE", $app_list_strings['list_champs_justificatif']);
        $this->ss->assign("DASHLET_CHAMPS_JUSTIFICATIF_LISTE_DEFAUT", $app_list_strings['list_champs_justificatif_defaut']);
    }
}