<?php

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.edit.php');

/**
 * Classe appelée par le view.edit.php du module Dashlet permettant la récupération d'informations liés à l'objet "Rapports"
 */
class OPS_rapportEdit
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres = array())
    {
        global $app_list_strings;

        $this->ss->assign("DASHLET_CHAMPS_RAPPORT_LISTE", $app_list_strings['list_champs_rapports']);
        $this->ss->assign("DASHLET_CHAMPS_RAPPORT_LISTE_DEFAUT", $app_list_strings['list_champs_rapports_defaut']);
    }
}
