$(document).ready(function() {

	$('[role=section_title]').each(function() {
        $(this).closest('.edit-view-row-item').find('> .label').hide();
        $(this).text( $(this).closest('.edit-view-row-item').find('> .label').text().replaceAll(':', '') );
        $(this).show();
    });



	

	check_personne_morale();

	check_beneficiaire();

	check_saison();

	check_anonyme();

	check_checkbox_display_list("forme_juridique", "choix_forme_juridique", "required_forme_juridique", "Forme juridique");
	check_checkbox_display_list("effectif", "choix_effectif", "required_effectif", "Effectif");
	check_checkbox_display_list("check_thematique", "thematique", "required_thematique", "Thématique");
	check_checkbox_display_list("secteur_activite", "choix_secteur_activite", "required_secteur_activite", "Secteur d'activités");
	check_checkbox_display_list("collectivite", "choix_collectivite", "required_collectivite", "Collectivité");
	check_checkbox_display_list("nature", "choix_nature", "required_nature", "Nature");
	check_checkbox_display_list("check_externe", "url_externe", "required_url", "URL externe", "text");
	display_champs("ops_guide_instruction_ops_dispositif_name",!$("#externe").is(":checked"));
	display_champs("ops_generateur_formulaire_ops_dispositif_name", !$("#externe").is(":checked"));
	display_champs("url_externe", $("#externe").is(":checked"));


	on_submit_form();

	var chooser_display_tabs_left_arrow = $('#table_choix_colonnes #chooser_display_tabs_left_arrow')[0];
    var chooser_display_tabs_left_to_right = $('#table_choix_colonnes #chooser_display_tabs_left_to_right')[0];
	
    chooser_display_tabs_left_arrow.addEventListener("click", () => {
        $("#hide_tabs, #display_tabs").attr("style",'height:200px !important; width:250px !important;');
    }, false);

    chooser_display_tabs_left_to_right.addEventListener("click", () => {
        $("#hide_tabs, #display_tabs").attr("style",'height:200px !important; width:250px !important;');
    }, false);

	$('#personne_morale').click(function() {
		check_personne_morale();
	});


	$('#beneficiaire').click(function() {
		check_beneficiaire();
	});

	$('#saison').click(function() {
		check_saison();
	});

	$('#anonyme').click(function() {
		check_anonyme();
	});

	$('#forme_juridique').click(function() {
		check_checkbox_display_list("forme_juridique", "choix_forme_juridique", "required_forme_juridique", "Forme juridique");
	});
	$('#effectif').click(function() {
		check_checkbox_display_list("effectif", "choix_effectif", "required_effectif", "Effectif");
	});
	$('#secteur_activite').click(function() {
		check_checkbox_display_list("secteur_activite", "choix_secteur_activite", "required_secteur_activite", "Secteur d'activités");
	});
	$('#check_thematique').click(function() {
		check_checkbox_display_list("check_thematique", "thematique", "required_thematique", "Thématique");
	});
	$('#collectivite').click(function() {
		check_checkbox_display_list("collectivite", "choix_collectivite", "required_collectivite", "Collectivité");
	});
	$('#nature').click(function() {
		check_checkbox_display_list("nature", "choix_nature", "required_nature", "Nature");
	});

	$('#externe').click(function() {
		check_checkbox_display_list("externe", "url_externe", "required_url", "URL externe");
		display_champs("ops_guide_instruction_ops_dispositif_name",!$("#externe").is(":checked"));
		display_champs("ops_generateur_formulaire_ops_dispositif_name", !$("#externe").is(":checked"));
	});

	function check_personne_morale()
	{
		var view = '';

		$('form').each(function(){
			if(this.id == 'EditView'){
				view = this.id;
			}
		});

		if($('#personne_morale').is(':checked'))
		{
			$('#beneficiaire').parent().parent().show();
			$('#type_tier').parent().parent().show();
			if($('#required_type_tier').length == 0)
			{
				$('#type_tier').parent().parent().children('div').first().append('<span id="required_type_tier" class="required">*</span>');
			}
			addToValidate(view,'type_tier','enum',true,'Type profil');
		}
		else
		{
			$('#beneficiaire').prop('checked', false);
			$('#beneficiaire').parent().parent().hide();
			$('#type_beneficiaire').parent().parent().hide();
			$('#type_beneficiaire').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'type_beneficiaire');

			$('#type_tier').parent().parent().hide();
			$('#type_tier').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'type_tier');
		}
	}

	function check_beneficiaire()
	{
		var view = '';

		$('form').each(function(){
			if(this.id == 'EditView'){
				view = this.id;
			}
		});

		if($('#beneficiaire').is(':checked'))
		{
			$('#type_beneficiaire').parent().parent().show();
			if($('#required_type_beneficiaire').length == 0)
			{
				$('#type_beneficiaire').parent().parent().children('div').first().append('<span id="required_type_beneficiaire" class="required">*</span>');
			}
			addToValidate(view,'type_beneficiaire','enum',true,'Type Bénéficiaire');
		}
		else
		{
			$('#type_beneficiaire').parent().parent().hide();
			$('#type_beneficiaire').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'type_beneficiaire');
		}
	}

	function check_anonyme()
	{
		var view = '';

		$('form').each(function(){
			if(this.id == 'EditView'){
				view = this.id;
			}
		});

		if($('#anonyme').is(':checked'))
		{
			$('#ops_individu_anonyme').closest('.edit-view-row-item').show();
			$('#individu').closest('.edit-view-row-item').hide();
			$('#personne_morale').closest('.edit-view-row-item').hide();
			$('#hors_compte').closest('.edit-view-row-item').hide();
			$('#beneficiaire').closest('.edit-view-row-item').hide();
			$('#type_beneficiaire').closest('.edit-view-row-item').hide();
			$('#type_tier_multiselect').closest('.edit-view-row-item').hide();

			$('#individu').removeAttr('checked');
			$('#personne_morale').removeAttr('checked');
			$('#beneficiaire').removeAttr('checked');
			$('#hors_compte').removeAttr('checked');

			$('#type_tier option').removeAttr('selected');
			$('#type_beneficiaire option').removeAttr('selected');

			removeFromValidate(view,'type_beneficiaire');

			if($('#required_ops_individu_anonyme').length == 0)
			{
				$('#ops_individu_anonyme').parent().parent().children('div').first().append('<span id="required_ops_individu_anonyme" class="required">*</span>');
			}
			addToValidate('EditView', 'ops_individu_anonyme', 'relate', true,'Demandeur anonyme par défaut' );
		}
		else
		{
			$('#ops_individu_anonyme').closest('.edit-view-row-item').hide();
			$('#individu').closest('.edit-view-row-item').show();
			$('#personne_morale').closest('.edit-view-row-item').show();
			$('#hors_compte').closest('.edit-view-row-item').show();

			check_personne_morale();
			check_beneficiaire();

			removeFromValidate(view,'ops_individu_anonyme');
		}
	}

	function check_saison()
	{
	    if ($('#saison').is(':checked')) 
	    {
			$('#saison_affichage_date_debut').parent().parent().parent().show();
			$('#saison_affichage_date_fin').parent().parent().parent().show();
			$('#saison_date_debut').parent().parent().parent().show();
			$('#saison_date_fin').parent().parent().parent().show();
	    }
	    else
	    {
			$('#saison_affichage_date_debut').parent().parent().parent().hide();
			$('#saison_affichage_date_fin').parent().parent().parent().hide();
			$('#saison_date_debut').parent().parent().parent().hide();
			$('#saison_date_fin').parent().parent().parent().hide();
	    }
	}

	/**
	 * Fonction permettant d'afficher un champ list en fonction d'un checkbox
	 * rajoute egalement la mention required
	 * @param {string} checkbox_id : id de la checkbox 
	 * @param {string} list_id  : id du champs de liste a afficher ou non
	 * @param {string} required_id : id qu'on souhaite donné à la mention "required"
	 * @param {string} libelle : libelle du champs
	 */
	function check_checkbox_display_list(checkbox_id, list_id, required_id, libelle, type = "enum"){
		var view = '';

		$('form').each(function(){
			if(this.id == 'EditView'){
				view = this.id;
			}
		});

		if($('#' + checkbox_id).is(':checked'))
		{
			$('#' + list_id).parent().parent().show();
			if($('#'+required_id).length == 0)
			{
				$('#' + list_id).parent().parent().children('div').first().append('<span id="'+required_id+'" class="required">*</span>');
			}
			addToValidate(view,list_id,type,true,libelle);
		}
		else
		{
			$('#' + list_id).parent().parent().hide();
			$('#' + list_id).parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view, list_id);
		}
	}

	function display_champs(id, show){
		var view = '';

		$('form').each(function(){
			if(this.id == 'EditView'){
				view = this.id;
			}
		});

		const champ = $("#" + id).parent().parent();
		const type = $("#" + id).parent().attr("type");
		const libelle = champ.find("[data-label]").first().text().replaceAll(":*", "");
		if(show) {
			champ.show();
			addToValidate(view,id,type,true, libelle);

		}
		else {
			champ.hide();
			removeFromValidate(view,id);

		}

	}
	function on_submit_form() {

		// recuperation de la fonction onclick par defaut et de la fonction qu'on souhaite ajouter (beforeSubmit())
		const onClickStringFnDefaut = $("#SAVE").attr('onclick');
		const onclickStringFnCustom = beforeSubmit.toString().match(/function[^{]+\{([\s\S]*)\}$/)[1]; // recuperation uniquement du body
		const onClickFullFunction = onclickStringFnCustom+onClickStringFnDefaut;
	
		// recuperation des boutons de sauvegarde
		let saveButtons = $(document.querySelectorAll("[id='SAVE']"));

		// attribution de la fonction onclick complete
		saveButtons.each(function(){
			$(this).attr("onclick", onClickFullFunction);
		});

	}

	function beforeSubmit(){
		var list_select = [document.getElementById('display_tabs')];

		for (let i = 0; i < list_select.length; i++) {
			const select = list_select[i];
	
			if (!select.disabled) {
				var option;
	
				for (var j = 0; j < select.options.length; j++) {
					select.name = 'display_tabs[]';
					option = select.options[j];
					option.selected = true;
				}
			}
		}

		$("#colonnes_gestion_dossiers").val($("#display_tabs").val())
	}


});