<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Generateur\Factory\OdeViewFactory;
use ODE\Generateur\Factory\OdeFormFactory;
use ODE\Model\GenerateurVueModel;

class ViewCreate extends SugarView
{

    public function __construct($bean = null, $view_object_map = array())
    {
        parent::__construct($bean, $view_object_map);
    }

    public function preDisplay()
    {
        if (!$this->bean->ACLAccess('edit')) {
            ACLController::displayNoAccess();
            sugar_die('Access Denied');
        }
    }

    /**
     * @see SugarView::display()
     */
    public function display()
    {

        global $app_list_strings;

        $smarty = new Sugar_Smarty();
        $donnees = [];
        $current_template = "modules/OPS_dossier/tpls/create.tpl";

        do {

            //  On vérifie que l'id du dispositif n'est pas null 
            if (empty($_REQUEST["dispositif_id"])) {
                $current_template = "modules/OPS_dossier/tpls/choix_dispositif.tpl";
                break;
            }

            //  On vérifie que le type de demandeur n'est pas null 
            if (empty($_REQUEST["demandeur_type"])) {
                SugarApplication::redirect("index.php?module=OPS_dossier&action=choix_demandeur&dispositif_id=" . $_REQUEST["dispositif_id"]);
                $current_template = "modules/OPS_dossier/tpls/choix_demandeur.tpl";
                break;
            } else {
                $donnees["demandeur"]["type"] = $_REQUEST["demandeur_type"];
            }

            // On récupere l'id du demandeur si il existe
            if (!empty($_REQUEST["demandeur_id"])) {
                $donnees["demandeur"]["id"] = $_REQUEST["demandeur_id"];
            }

            // On récupere l'id du demandeur si il existe
            if (!empty($_REQUEST["famille_id"])) {
                $donnees["famille"]["id"] = $_REQUEST["famille_id"];
            }

            // On récupere l'id du demandeur si il existe
            if (!empty($_REQUEST["enfant_id"])) {
                $donnees["enfant"]["id"] = $_REQUEST["enfant_id"];
            }

            // On récupere l'objet dispositif
            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $_REQUEST["dispositif_id"]);
            if (empty($obj_dispositif->id)) {
                $GLOBALS['log']->fatal(" OPS_dossier :: ViewCreate => Le dispositif id = " . $_REQUEST["dispositif_id"] . " est introuvable");
                break;
            } else {
                $donnees["dispositif"] = ["id" => $obj_dispositif->id, "name" => $obj_dispositif->name];
            }

            //On récupère l'id de la personne morale s'il existe
            if( !empty($_REQUEST["personne_morale_id"]) ){
                $donnees["personne_morale"] = $_REQUEST["personne_morale_id"];
            }

            //On récupère l'id du bénéficiaire s'il existe
            if( !empty($_REQUEST["beneficiaire_id"]) ){
                $donnees["beneficiaire_id"] = $_REQUEST["beneficiaire_id"];
            }

            // On récupere la vue agent du formulaire associé au dispositif
            $liste_formulaire =  $obj_dispositif->get_linked_beans('ops_generateur_formulaire_ops_dispositif', 'OPS_generateur_formulaire');
            $obj_formulaire = (is_array($liste_formulaire) && count($liste_formulaire) > 0) ?  $liste_formulaire[0] : false;
            $agent_vue_id = ($obj_formulaire !== false &&  !empty($obj_formulaire->agent_vue_id)) ? $obj_formulaire->agent_vue_id : "";
            $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $agent_vue_id);
            if (empty($obj_vue->id)) {
                $GLOBALS['log']->fatal(" OPS_dossier :: ViewCreate => La vue agent id = " . $agent_vue_id . " est introuvable");
                break;
            } else {
                $donnees["vue"] = ["id" => $obj_vue->id, "type" => "agent", "creation" => "true"];
                $generateurVueModel = new GenerateurVueModel($obj_vue->id);
                $conditions = $generateurVueModel->getChampsConditions();
            }

            $typeProfil = '';
            if(!empty($_REQUEST['personne_morale_id'])){
                $personneMoralObj = BeanFactory::getBean('OPS_personne_morale',$_REQUEST['personne_morale_id']);
                $typeProfil = $personneMoralObj->ops_type_personne_id;
            }
 
            $params_html = '<input type="hidden" id="ops_personne_morale" name="ops_personne_morale" value="'.$_REQUEST['personne_morale_id'].'"/>
                            <input type="hidden" id="dispositif" name="dispositif" value="'.$_REQUEST['dispositif_id'].'"/>
                            <input type="hidden" id="demandeur" name="demandeur" value="'.$_REQUEST['demandeur_id'].'"/>
                            <input type="hidden" id="beneficiaire_id" name="beneficiaire_id" value="'.$_REQUEST['beneficiaire_id'].'"/>
                            <input type="hidden" id="ops_type_personne" name="ops_type_personne" value="' . $typeProfil . '"/>
                            <input type="hidden" id="conditions" name="conditions" value="'.$conditions.'"/>';


            $this->displayTMCE();

            // On récupere le html de la vue de création 
            $viewFactory = new OdeViewFactory(null, true, $donnees);
            $vue_html = $viewFactory->getHtml();
            $smarty->assign('vue_html', $vue_html);
            $smarty->assign('params_html', $params_html);
        } while (0);

        $smarty->display($current_template);
    }

    /**
     * @access private 
     * @name getDispositifs()
     * Fonction qui renvoie la liste des dispositifs de la plateforme    => OPS_dispositif
     * 
     *  @return array          $tab_dispositifs : Tableau de dispositif
     */
    private function getDispositifs()
    {

        $tab_dispositifs = array();

        $obj_dispo = new OPS_dispositif;
        $dispositifs = $obj_dispo->get_full_list_create(); // Vérifier les habilitations

        foreach ($dispositifs as $dispositif) {

            $erreurs = $this->isValidDispositif($dispositif);
            $statut = (count($erreurs) == 0) ? "ok" : "err";
            $libelle_erreurs = (count($erreurs) != 0) ? implode(", ", $erreurs) : "";

            $tab_dispositifs[$dispositif->id] = array(
                "name" =>  str_replace("&#039;", "\&#039;", $dispositif->name),
                "cle" => $dispositif->cle,
                "icon" => $dispositif->icone,
                "color" => $dispositif->couleur,
                "aide" => $dispositif->description,
                "statut" => $statut,
                "erreurs" => $libelle_erreurs
            );
        }

        return $tab_dispositifs;
    }

    /**
     * @access private
     * @name isValidDispositif()
     * Fonction qui vérifie si le dispositif est valid, elle revoie la liste des erreurs.
     * 
     *  @param bean             $dispositif: Bean module OPS_dispositif
     *  @return array           $erreurs : tableau d'erreurs
     */
    private function isValidDispositif($dispositif)
    {

        $erreurs = array();

        // On vérifie que le dispositif est liée à une unique vue 
        $liste_formulaires =  $dispositif->get_linked_beans('ops_generateur_formulaire_ops_dispositif', 'OPS_generateur_formulaire');
        $formulaire = (is_array($liste_formulaires) && count($liste_formulaires) > 0) ?  $liste_formulaires[0] : false;
        $agent_vue_id = ($formulaire !== false &&  !empty($formulaire->agent_vue_id)) ? $formulaire->agent_vue_id : false;
        $obj_vue = BeanFactory::getBean('OPS_generateur_vue', $agent_vue_id);

        if (!empty($obj_vue->id)) {
            // On vérifie que la vue a bien des onglets et champs 
            $liste_onglets = $obj_vue->get_linked_beans('ops_generateur_vue_ops_generateur_onglet', 'OPS_generateur_onglet');
            if (!is_array($liste_onglets) || count($liste_onglets) == 0) {
                $erreurs[] = "Aucun onglet n'a été configuré sur ce dispositif";
            }
        } else {
            $erreurs[] = "Aucun modèle de dossier n'est associé à ce dispositif";
        }

        // On vérifie que le dispositif est rattaché à un guide d'instruction
        $liste_guide_instruction =  $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction');
        $guide_instruction = (is_array($liste_guide_instruction) && count($liste_guide_instruction) == 1) ? $liste_guide_instruction[0] : false;
        if ($guide_instruction === false) $erreurs[] = "Aucun guide d'instruction n'est associé à ce dispositif";

        // On vérifie que le guide d'instruction dispose d'un statut initial
        if ($guide_instruction !== false) {
            if (empty($guide_instruction->ops_statut_id)) $erreurs[] = "Le statut initial n'est pas renseigné sur le guide d'instruction";
        }

        // Vérifier que dans la vue dispose des champs obligatoires 
        if (is_array($liste_onglets) && count($liste_onglets) > 0) {
            $verification_champs = false;
            foreach ($liste_onglets as $onglet) {
                $liste_champs = $onglet->get_linked_beans('ops_generateur_onglet_ops_generateur_champ', 'OPS_generateur_champ');
                if (count($liste_champs) > 0) $verification_champs = true;
            }
            if ($verification_champs === false) $erreurs[] = "Les champs obligatoires sont absents du modèle de dossier";
        }


        return $erreurs;
    }

    function displayTMCE()
    {
        require_once("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $css = <<<CSS
        
        <style type="text/css">
        
        textarea[role="champ-formulaire"][data-name][rel="wysiwyg"] ~ span[id][role="application"]{
            display: flex;width: 95%;margin-left: 12px;
        } 
        </style>

CSS;

        $js = '<script src="vendor/tinymce/tinymce/tinymce.min.js"></script>';
        $js .= <<<JS
        <script language="javascript" type="text/javascript">
        function wysiwyg(id_textarea,is_readonly){

        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            selector: id_textarea ? '#' + id_textarea : 'textarea',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            onchange_callback : "myCustomOnChangeHandler",
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
            readonly: parseInt(is_readonly),
        });
    }
        </script>

JS;
        echo $js;
        echo $css;
    }
}
