<?PHP
use TimeDate;
class OPS_exception extends Basic
{
	public $new_schema = true;
	public $module_dir = 'OPS_exception';
	public $object_name = 'OPS_exception';
	public $table_name = 'ops_exception';
	public $importable = false;
	public $disable_row_level_security = true; // to ensure that modules created and deployed under CE will continue to function under team security if the instance is upgraded to PRO
	public $id;
	public $name;
	public $date_entered;
	public $date_modified;
	public $modified_user_id;
	public $modified_by_name;
	public $created_by;
	public $created_by_name;
	public $description;
	public $deleted;
	public $created_by_link;
	public $modified_user_link;
	public $assigned_user_id;
	public $assigned_user_name;
	public $assigned_user_link;
	public $date_exception;
	public $a_partir_de;
	public $jusqu_a;
	public $nb_disponible;

	public function __construct()
	{
		parent::__construct();
	}

	public function bean_implements($interface)
	{
		switch ($interface) {
			case 'ACL':
				return true;
		}
		return false;
	}


	/**
	 * Recupération des jours contenant des exceptions dans un agenda
	 * @param mixed $agenda_id
	 * @return array
	 */
	public function recuperation_jours($agenda_id)
	{

		global $beanFiles, $current_user;

		require_once($beanFiles["OPS_agendas"]);

		$list = array();

		// Récupération de l'objet de l'agenda passé en paramètre
	   // $cur_objet = new OPS_agendas();
		//$cur_objet->retrieve($agenda_id);
		$cur_objet->BeanFactory::getBean("OPS_agendas", $agenda_id);

		// Récupération des tables liées à l'Agenda
		$exceptions = $cur_objet->get_linked_beans("ops_agendas_ops_exception", "OPS_exception");

		$date_jour = new TimeDate();
		$date_jour = $date_jour->getNow();
		$date_jour = $date_jour->format("Y/m/d");

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}
		$timeZone = TimeDate::userTimezone($current_user);

		// Essai de parsing de la date si retournée par Wordpress (format récupéré : dd/mm/yyyy)
		if (substr($cur_objet->date_debut, 4, 1) == "-") {

			$date = new DateTime($cur_objet->date_debut);
			$date->setTimezone(new DateTimeZone($timeZone));
			$agenda_date_debut = $date->format('Y-m-d');

			$dateJour = new DateTime();
			$dateJour->setTimezone(new DateTimeZone($timeZone));
			$format_date_jour = $dateJour->format('Y-m-d');

			if ($cur_objet->souhait_glissement_debut == 1 && $cur_objet->jours_glissement_debut > 0 || ($agenda_date_debut < $format_date_jour)) {

				$date = new DateTime();
				$date->setTimezone(new DateTimeZone($timeZone));
				$agenda_date_debut = $date->format('d-m-Y');

				$date_debut = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4) . " +" . $cur_objet->jours_glissement_debut . "day");

				$agenda_date_debut = date("d-m-Y", $date_debut);
			} else {
				$date = new DateTime($cur_objet->date_debut);
				$date->setTimezone(new DateTimeZone($timeZone));
				$agenda_date_debut = $date->format('d-m-Y');

				$date_debut = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4));
			}

			if ($cur_objet->souhait_glissement_fin == 1 && $cur_objet->jours_glissement_fin > 0) {

				$date = new DateTime();
				$date->setTimezone(new DateTimeZone($timeZone));
				$format_date_fin = $date->format('d-m-Y');

				$agenda_date_fin = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4) . " +" . $cur_objet->jours_glissement_fin . "day");
			} else {
				$date = new DateTime($cur_objet->date_fin);
				$date->setTimezone(new DateTimeZone($timeZone));
				$format_date_fin = $date->format('d-m-Y');

				$agenda_date_fin = strtotime(substr($format_date_fin, 0, 2) . "-" . substr($format_date_fin, 3, 2) . "-" . substr($format_date_fin, 6, 4));
			}

			// Si données récupérées via Sugar, pas de parsing nécéssaire
		} else {

			$dateJour = new DateTime();
			$dateJour->setTimezone(new DateTimeZone($timeZone));
			$format_date_jour = $dateJour->format('Y-m-d');

			$format_date_D = substr($cur_objet->date_debut, 6, 4) . "-" . substr($cur_objet->date_debut, 3, 2) . "-" . substr($cur_objet->date_debut, 0, 2);

			if ($cur_objet->souhait_glissement_debut == 1 && $cur_objet->jours_glissement_debut > 0 || ($agenda_date_debut < $format_date_jour)) {
				$date = new DateTime();
				$date->setTimezone(new DateTimeZone($timeZone));
				$agenda_date_debut = $date->format('d-m-Y');

				$date_debut = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4) . " +" . $cur_objet->jours_glissement_debut . "day");

				$agenda_date_debut = date("d-m-Y", $date_debut);
			} else {
				$agenda_date_debut = $cur_objet->date_debut;

				$date_debut = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4));
			}

            
			if ($cur_objet->souhait_glissement_fin == 1 && $cur_objet->jours_glissement_fin > 0) {
				$date = new DateTime();
				$date->setTimezone(new DateTimeZone($timeZone));
				$format_date_fin = $date->format('d-m-Y');

				$agenda_date_fin = strtotime(substr($agenda_date_debut, 0, 2) . "-" . substr($agenda_date_debut, 3, 2) . "-" . substr($agenda_date_debut, 6, 4) . " +" . $cur_objet->jours_glissement_fin . "day");
			} else {
				$format_date_fin = $cur_objet->date_fin;

				$agenda_date_fin = strtotime(substr($format_date_fin, 0, 2) . "-" . substr($format_date_fin, 3, 2) . "-" . substr($format_date_fin, 6, 4));
			}
		}

		// Si une exception existe dans OPS_exception pour l'agenda remonté dans $cur_objet
		if (isset($exceptions)) {

			// Pour chaque occurence d'exception
			foreach ($exceptions as $jour) {

				if (substr($jour->date_exception, 4, 1) == "-") {

					$date = new DateTime($jour->date_exception);
					$date->setTimezone(new DateTimeZone($timeZone));
					$date_exception = $date->format('d/m/Y'); // Récupération des variables de date
					$journee = substr($date_exception, 0, 2);
					$mois = substr($date_exception, 3, 2);
					$annee = substr($date_exception, 6, 4);
					$date_exception = $date->format('Y/m/d'); // Reformatage pour comparaison entre date

				} else {

					$date = $jour->date_exception;
					$journee = substr($date, 0, 2);
					$mois = substr($date, 3, 2);
					$annee = substr($date, 6, 4);

					$date_exception = $annee . "/" . $mois . "/" . $journee;
				}


				if ($date_jour <= $date_exception && $agenda_date_fin >= $date_exception) {

					$date_exception = $journee . "/" . $mois . "/" . $annee;

					$horraire = array();

					// Ajout de la date parsée dans le tableau $list[annee][mois][jour][date]
					$horraire["date"] = $date_exception;

					// Récupération des disponibilités
					$horraire['dispo'] = $jour->nb_disponible;

					// Récupération de la tranche horraire
					$horraire['heure_debut'] = $jour->a_partir_de;
					$horraire['heure_fin'] = $jour->jusqu_a;

					$list[$annee][$mois][$journee][] = $horraire;

					asort($list[$annee][$mois]);
				}
			} // Fin du foreach des jours exceptions
		}

		return $list;
	}



	/**
	 * Fonction de création des exceptions, avec vérification de doublons
	 * @param mixed $plage_ouverture (bean)
	 * @param mixed $agenda (bean)
	 * @param mixed $date_deb
	 * @param mixed $date_fin
	 */
	public function create_exceptions_recurrence($plage_ouverture, $agenda, $date_deb, $date_fin)
	{

		$exception_exist = $this->verif_exist_exception_recurrence($plage_ouverture, $agenda, $date_deb, $date_fin);

		// Si aucune exception n'existe pour cette date, on la créée
		if (!$exception_exist) {
			$this->name = $plage_ouverture->name;
			$this->flag_recurrence = 1;
			$this->nb_disponible = 0;
			$this->nb_disponible_bo = 0;
			$this->date_exception_deb = $date_deb;
			$this->date_exception_fin = $date_fin;

			// On lie l'exception à la plage d'ouverture ayant définie la récurrence pour pouvoir effectuer les vérifications d'existence
			$this->plage_ouverture_id = $plage_ouverture->id;
			// On rattache l'exception au lieu de la plage d'ouverture si la plage d'ouverture est liée à un lieu
			$this->save();

			if (isset($plage_ouverture->ops_lieux_id) && !empty($plage_ouverture->ops_lieux_id)) {
				$bean_lieu = BeanFactory::getBean('OPS_lieux', $plage_ouverture->ops_lieux_id);

				$this->load_relationship('ops_lieux_ops_exception');
				$this->ops_lieux_ops_exception->add($bean_lieu);
			}

			$agenda->load_relationship('ops_agendas_ops_exception');
			$agenda->ops_agendas_ops_exception->add($this);

			return $this->id;
		}
	}

    
	/**
	 * Fonction de vérification si une exception existe déjà sur les dates en paramètre et liée à la plage d'ouverture éditée
	 * @param mixed $plage_ouverture
	 * @param mixed $agenda
	 * @param mixed $date_deb
	 * @param mixed $date_fin
	 * @return string id
	 */
	public function verif_exist_exception_recurrence($plage_ouverture, $agenda, $date_deb, $date_fin)
	{
		$bean_exception = BeanFactory::newBean('OPS_exception');

		$bean_exception = $bean_exception->retrieve_by_string_fields(
			array(
				'plage_ouverture_id' => $plage_ouverture->id,
				'date_exception_deb' => $date_deb,
				'date_exception_fin' => $date_fin,
				'flag_recurrence' => 1,
				'deleted' => 0
			)
		);

		return $bean_exception->id;
	}
}