$(document).ready(function () {

    var annee = "";

    // Event choix sur le radiobtn de l'année
    $('input[name="annee_type"]').change(function(){

        if (document.getElementById("annee-courante").checked) {
            const date = new Date();
            annee = (date.getFullYear()).toString();
        } else {
            const date = new Date();
            annee = (date.getFullYear() + 1).toString();
        }
    });


    // Event click sur importer les jours fériés
    $("#importer_jf").click(function(){

        var agenda_id = document.getElementById("record").value;
        
        if(agenda_id != "" && annee != ""){
            $.ajax({
                url: "/index.php?entryPoint=agenda_creation_exception&methode=import_JF",
                type: "POST",
                dataType: "json",
                data: {
                    id_agenda: agenda_id,
                    annee: annee,
                },
                success: function (res) {
                    if(res[0].resultat== "valide"){
                        $('#modal-exception').modal('hide');
                        location.reload();
                    } else {
                        alert("Erreur à l'importation");
                    }

                },
                error:function (res){
                    console.log("Error");
                    console.log(res);
                }
            });
        } else {
            alert("Veuillez saisir les champs obligatoires");
        }

    });
});
