<?php

require_once('Zend/Http/Client.php');
require_once("modules/OPS_flux/service/journal.php");

class OPS_flux extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_flux';
    public $object_name = 'OPS_flux';
    public $table_name = 'ops_flux';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $methode;
    public $path;
    public $content_type;
    public $objet;
    public $action_lot;

   // public $params_get = array();
    public $retour_traitement = array();
    public $journal = false;
    public $ordre = 1;
    public $flux = false;
    public $donnees = false;
    public $connecteur = false;


    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }
        return false;
    }


    /**
     * @access private
     * initialisation_flux()
     * Fonction qui intilialise $this->flux
     * 
    */
    private function initialisation_flux(){
        if(!empty($this->id))$this->flux = $this;
    }

    /**
     * @access private
     * initialisation_connecteur()
     * Fonction qui vérifie si le flux est rattaché à un connecteur, si ok intilialise $this->connecteur
     * 
    */
    private function initialisation_connecteur(){
        if(!empty($this->flux->id)){
            $connecteurs = $this->flux->get_linked_beans('ops_connecteur_ops_flux','OPS_connecteur');
            if(!empty($connecteurs)){
                if(is_array($connecteurs) && count($connecteurs) > 0){
                    $this->connecteur = $connecteurs[0];
                }
            }
        }
    }
    
    /**
     * @access private
     * initialisation_journal()
     * Fonction qui initialise le journal $this->journal
     * 
    */
    private function initialisation_journal(){
        $journal = new OPS_journal();
        if(!empty($this->id)){
            $journal->name = "Initialisation journal";
            $journal->parent_type = 'OPS_flux';
            $journal->parent_id = $this->id;
            $journal->statut = 'ok';
            if($journal->save()){
                $this->journal = $journal;
            }
        }
    }

    /**
     * @access private
     * verification_flux()
     * Fonction qui vérifie le flux
     * 
    */
    private function verification_flux(){

        $description = "Vérification des champs du flux :"."\n";
        $erreur = "";
        $count_erreur = 0;

        if($this->flux != false){

            if(!empty($this->flux->id)){

                if (!empty($this->flux->methode)) {
                    $description .= "Méthode = ".$this->flux->methode."\n";
                } else {
                    $erreur = "Méthode = Null";
                    $description .= $erreur."\n";
                    $count_erreur++;
                }

                if (!empty($this->flux->objet)) {
                    $description .= "Objet = ".$this->flux->objet."\n";
                } else {
                    $erreur = "Objet = Null";
                    $description .= $erreur."\n";
                    $count_erreur++;
                }

                if (!empty($this->flux->action_lot)) {
                    $description .= "Type d'envoie en action par lot = ".$this->flux->action_lot."\n";
                } else {
                    $erreur = "Type d'envoie en action par lot = Null";
                    $description .= $erreur."\n";
                    $count_erreur++;
                }

                if (!empty($this->flux->content_type)) {
                    $description .= "Content type = ".$this->flux->content_type."\n";
                } else {
                    $description .= "Content type = Null"."\n";
                }

                if (!empty($this->flux->path)) {
                    $description .= "Path = ".$this->flux->path."\n";
                } else {
                    $description .= "Path = Null"."\n";
                }

            }else{
                $erreur = "L'id du flux est vide";
                $count_erreur++;  
            }

        }else{
            $erreur = "Echec de l'initialisation du flux";
            $count_erreur++;
        }


        if ($count_erreur == 0) {
            $reponse = "Oui";
            $statut = "ok";
        } else {
            $reponse = "Non";
            $statut = "err";
        }

        if(!empty($this->journal->id)){

            $journal_detail = new OPS_journal_detail();
            $journal_detail->name = "Vérification du flux";
            $journal_detail->tache = "Est ce que le flux est configuré correctement ?";
            $journal_detail->reponse = $reponse;
            $journal_detail->description = $description;
            $journal_detail->statut = $statut;
            $journal_detail->erreur = $erreur;
            $journal_detail->ordre = $this->ordre;
            $id = $journal_detail->save(false);

            $this->journal->load_relationship('ops_journal_detail_ops_journal');
            $this->journal->ops_journal_detail_ops_journal->add($id);
            $this->journal->statut = $statut;
            $this->journal->name = "Déclenchement du flux : ".$this->flux->name;
            $this->journal->save();

            $this->ordre++;
        }

    }

    /**
     * @access private
     * verification_connecteur()
     * Fonction qui vérifie le connecteur
     * 
    */
    private function verification_connecteur(){

        $description = "Vérification des champs du connecteur :"."\n";
        $count_erreur = 0;
        $erreur = "";

        if(!empty($this->connecteur->id)){

            if (!empty($this->connecteur->url_api)) {
                $description .= "Url = ".$this->connecteur->url_api."\n";
            } else {
                $erreur = "Url = Null";
                $description .= $erreur."\n";
                $count_erreur++;
            }

            if (!empty($this->connecteur->architecture)) {
                $description .= "Architecture = ".$this->connecteur->architecture."\n";
            } else {
                $erreur = "Architecture = Null"."\n";
                $description .= $erreur."\n";
                $count_erreur++;
            }

            if (!empty($this->connecteur->type_connexion)) {
                $description .= "Type de connection = ".$this->connecteur->type_connexion."\n";
            } else {
                $erreur = "Type de connection = Null"."\n";
                $description .= $erreur."\n";
                $count_erreur++;
            }

        }

        if ($count_erreur == 0) {
            $reponse = "Oui";
            $statut = "ok";
        } else {
            $reponse = "Non";
            $statut = "err";
        }


        if(!empty($this->journal->id)){

            $journal_detail = new OPS_journal_detail();
            $journal_detail->name = "Vérification du connecteur";
            $journal_detail->tache = "Est ce que le connecteur est configuré correctement ?";
            $journal_detail->reponse = $reponse;
            $journal_detail->description = $description;
            $journal_detail->statut = $statut;
            $journal_detail->erreur = $erreur;
            $journal_detail->ordre = $this->ordre;
            $id = $journal_detail->save(false);

            $this->journal->load_relationship('ops_journal_detail_ops_journal');
            $this->journal->ops_journal_detail_ops_journal->add($id);
            $this->journal->statut = $statut;
            $this->journal->save();

            $this->ordre++;
        }
    }

    /**
     * @access private
     * verification_donnees()
     * Fonction qui vérifie les données à envoyer
     * 
    */
    private function verification_donnees($donnees){
        if($donnees) $this->donnees = $donnees;
    }

    /**
     * @access public
     * get_donnees_bean()
     * Fonction qui vérifie les données à envoyer
     * 
     * @return Array $tableau ['statut' => 'ok' ou 'err' , 'data' => 'données ou libellé erreur']     
    */
    function get_donnees_bean($bean){

        $data = "";
        $statut = "err";
        if (!empty($this->id)) {
            if (!empty($this->methode)) {

                if ($this->methode == 'post') {
                    $data = $this->get_json_flux_elements($bean);

                } elseif ($this->methode == 'get') {
                    $data  = $this->get_flux_elements($bean);

                }else{
                    $data  = false;
                }

                if($data){
                    $statut = "ok";
                }else{
                    $data = "Erreur de récupération des valeurs du module.";
                }
                
            }
        }
        return ['statut' => $statut, 'data' => $data];
    }

    /**
     * @access private
     * verification_donnees()
     * Fonction qui vérifie les données à envoyer
     * 
    */
    private function last_log_journal(){

        $statut = 'err';
        $erreur = "";
        $description = "";

        if($this->retour_traitement['statut']){
            $statut = $this->retour_traitement['statut'];
        }

        if($statut == "err"){
            $reponse = "Non";
        }else{
            $reponse = "Oui";
        }

        $description .= "Requête envoyée :"."\n";
        if ($this->donnees) {
            $description .= $this->donnees."\n";;
        }

        $description .= "Réponse reçue :"."\n";
        if ($this->retour_traitement['data']) {
            $description .= $this->retour_traitement['data'];
        }

        if(!empty($this->journal->id)){

            $journal_detail = new OPS_journal_detail();
            $journal_detail->name = "Retour déclenchement flux";
            $journal_detail->tache = "Est ce que le flux a bien été envoyé ?";
            $journal_detail->reponse = $reponse;
            $journal_detail->description = $description;
            $journal_detail->statut = $statut;
            $journal_detail->erreur = $erreur;
            $journal_detail->ordre = $this->ordre;
            $id = $journal_detail->save(false);

            $this->journal->load_relationship('ops_journal_detail_ops_journal');
            $this->journal->ops_journal_detail_ops_journal->add($id);
            $this->journal->statut = $statut;
            $this->journal->save();
        }

    }

    /**
     * @access public
     * declencher_flux()
     * Fonction qui déclenche un flux 
     * 
     *  @param Bean   $donnees                      - Les données à envoyer 
     *  @return Array $this->retour_traitement      - Tableau avec le résultat et les erreurs rencontrées
    */
    function declencher_flux($donnees){

        // Initilisation du flux et du connecteur 
        $this->initialisation_flux();
        $this->initialisation_connecteur();

        // Initialisation journal 
        $this->initialisation_journal();

        // Vérification du flux et du connecteur
        $this->verification_flux();
        $this->verification_connecteur();

        // Si le flux et le connecteur sont ok 
        if($this->flux != false && $this->connecteur != false){

            // On vérifie les données 
            $this->verification_donnees($donnees);
            if($this->donnees != false){

                if ($this->connecteur->architecture == "rest") {

                    $this->envoyer_requete_rest();

                } else {
                    $this->retour_traitement = array(
                        'statut' => 'err',  
                        'data' => 'L\'architecture Soap n\'est pas prise en compte dans cette version du générateur de flux.', 
                    );
                }

            }else{
                $this->retour_traitement = array(
                    'statut' => 'err',  
                    'data' => 'Les données à envoyer ne sont pas au bon format, consultez le journal pour plus de détails.', 
                );
            }

        }else{
            $this->retour_traitement = array(
                'statut' => 'err',  
                'data' => 'Le flux ou le connecteur sont en erreur, consultez le journal pour plus de détails.', 
            );
        }
        
        $this->last_log_journal();
        return $this->retour_traitement;
    }

    /**
     * @access private
     * get_header()
     * Fonction qui intilialise le header
     * 
     *  @return Array $header      - Tableau avec les parametres du header ou false
    */
    private function get_header(){

        $header = false;

        if( !empty($this->flux->content_type) ){
            $header[] =  "Content-type: " . $this->flux->content_type;
        }

        if ('token' ==$this->connecteur->type_connexion) {

            $header[] = $this->connecteur->name_token .":" . $this->connecteur->token;

        } elseif( 'auth' == $this->connecteur->type_connexion ) {

            $header[] =  $this->connecteur->auth_name_1 .":" . $this->connecteur->auth_value_1;
            $header[] =  $this->connecteur->auth_name_2 .":" . $this->connecteur->auth_value_2;

        } elseif ( 'aucun' == $this->connecteur->type_connexion ) {

            $header = array(
                0 =>  "Content-type: ". $this->flux->content_type,
                1 =>  "Accept: application/json",
             ); 
        }

        return $header;
    }

    /**
     * @access private
     * get_url()
     * Fonction qui intilialise l'url
     * 
     * @return String $url      - Retourne la concaténation de l'url du connecteur et le path de la fonction du flux sinon false
    */
    private function get_url(){

        if($this->flux->methode == 'get'){
            return  $this->connecteur->url_api.''.$this->flux->path.'?'.$this->donnees;
        } elseif ($this->flux->methode == 'post') {
            return $this->connecteur->url_api.''.$this->flux->path;
        }else{
            return false;
        }

    }

  
    /**
    * envoyer_requete()
    * 
    * 
    */
    
    public function envoyer_requete_rest(){ 

        // initialisation de curl 
        $curl = curl_init();

        do {
            // Récupération du header 
            $header = $this->get_header();
            if($header == false){
                $this->retour_traitement = [ 'statut' => 'err', 'data' => 'Erreur de construction du header.' ]; 
                break;
            } 

            // Récupération de l'url
            $url = $this->get_url();
            if($url == false){
                $this->retour_traitement = [ 'statut' => 'err', 'data' => 'Erreur de construction de l\'url.' ]; 
                break;
            } 

            
            // Si on est en post on ajoute les donnes à POSTFIELDS
            if($this->flux->methode == 'post'){
                curl_setopt($curl, CURLOPT_POSTFIELDS,$this->donnees);
            }

            curl_setopt($curl, CURLOPT_URL,$url);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, strtoupper($this->flux->methode) );
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

            // On décode la réponse et l'erreur
            $response = curl_exec($curl);             
            $err = curl_error($curl);

            if (empty($err)) {
                $this->retour_traitement = [ 'statut' => 'ok', 'data' => $response ]; 
            }else{
                $this->retour_traitement = [ 'statut' => 'err', 'data' => $err ];  
            }

        } while (0);

        // On ferme le curl 
        curl_close($curl);
    }

    function get_flux_elements($bean){
       
       $reponse = false;
        if( !empty( $this->id ) ){

            $elements = $this->get_linked_beans('ops_flux_ops_flux_element','OPS_flux_element');

            if( !empty($elements) ){

                do {

                    foreach ($elements as $element) {
                        if($element->type_element == "groupe"){
                            break;
                        }
                    }

                    $json  = $this->get_json_flux_elements($bean);
                    $array = $this->json_to_array($json);

                    if ($array['statut'] == 'ok'){
            			foreach( $array['data'] as $param => $value ){
             				$data_req[] = "$param=$value" ;  
            			} 
            			$reponse = implode("&", $data_req); 
                    }

                } while(0);
          

            }

        }
        return $reponse;
    }

    /**
     * json_to_array()
     * Fonction qui prend en param un json, retourne un tableau si ok sinon l'erreur Json
     * 
     *  @param Json/String $flux        - Json
     *  @return Array  $array_return    - ['statut' => '', 'data' => '']
    */
    public function json_to_array($flux){

        $statut = false;
        $libelle_erreur = "";
        $donnees = json_decode($flux);

        switch (json_last_error()) {
            case JSON_ERROR_NONE:
                $statut = true;
                break;
            case JSON_ERROR_DEPTH:
                $libelle_erreur = ' - Profondeur maximale atteinte';
                break;
            case JSON_ERROR_STATE_MISMATCH:
                $libelle_erreur = ' - Inadéquation des modes ou underflow';
                break;
            case JSON_ERROR_CTRL_CHAR:
                $libelle_erreur = ' - Erreur lors du contrôle des caractères';
                break;
            case JSON_ERROR_SYNTAX:
                $libelle_erreur = ' - Erreur de syntaxe ; JSON malformé';
                break;
            case JSON_ERROR_UTF8:
                $libelle_erreur = ' - Caractères UTF-8 malformés, probablement une erreur d\'encodage';
                break;
            default:
                $libelle_erreur = ' - Erreur inconnue';
                break;
        }

        if($statut == true){
            $array_return = [ 'statut' => 'ok', 'data' => $donnees];
        }else{
            $array_return = [ 'statut' => 'err', 'data' => $libelle_erreur];
        }

        return $array_return;

    }

    // Faut traiter les tableaux à plusieurs dimensions
    function recursive_array_search($val,$tab) {

        foreach($tab as $key => $value) {
            if($val == $key) {
                 return array( $val => $value);
            }
        }

    }
    
    /**
    * connexion_rest_login()
    * 
    * 
    */
    function connexion_rest_login(){
        

        $ch = curl_init();
        $param  = $this->get_json_flux_elements();
        $url =  $this->connecteur->url_api.$this->path.$param;
        curl_setopt($ch, CURLOPT_URL, $url );
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper ($this->methode));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        $this->retour_traitement['response'] = json_decode($output);
        if('' !=trim($this->connecteur->valeur_retour)){
            // On récupere la session ou le token
            $array_retour = $this->recursive_array_search($this->connecteur->valeur_retour,(array)json_decode($output));
        } 
    }


    /**
     * @access public
     * get_json_flux_elements()
     * Fonction qui à partir d'un bean et d'un flux, récupere les éléments flux ainsi que leurs valeurs
     * 
     *  @param Bean   $bean                         - Objet SuiteCrm
     *  @return JSON  $flux_elements    - Tableau avec le résultat et les erreurs rencontrées
    */
    function get_json_flux_elements($bean){

        $flux_elements = false;

        if( !empty( $this->id ) ){

            $elements = $this->get_linked_beans('ops_flux_ops_flux_element','OPS_flux_element');
            $return_array              = array();
            $tab_elems              = array();

            foreach ($elements as $element) {
                if(  $element->flux_element_parent_id  == ""){
                    $return_array[$element->ordre]['id'] = $element->id;
                    $return_array[$element->ordre]['name_flux'] = $element->name_flux;
                    $return_array[$element->ordre]['type_element'] = $element->type_element;
                    $return_array[$element->ordre]['champ'] = $element->champ;
                }
            }

            ksort($return_array);
            
            foreach ($return_array as $key => $value) {
                    if('groupe' == $value['type_element']){
                        $obj_element = new OPS_flux_element();
                        $tab_elems[$value['name_flux']] = $obj_element->get_element_groupe( $value['id'],$bean);

                    }else{
                        $obj_element = new OPS_flux_element();
                        $obj_element->retrieve( $value['id'] );
                        $tab_elems[$obj_element->name_flux] = $obj_element->get_element_value($bean) ;  
                    }
            }

            $flux_elements = json_encode($tab_elems);

        } else {
            $GLOBALS['log']->fatal("OPS_flux : get_flux_elements : erreur de flux" );
        }
        return $flux_elements;

    }




    /**
    * recuperation_retour()
    * 
    * @return Array           - Tableau avec le résultat et les erreurs rencontrées
    */
    public function tester_connexion($flux){

        $this->flux = $flux;

        $connecteurs = $this->flux->get_linked_beans("ops_connecteur_ops_flux","OPS_connecteur");        
        if ( is_array($connecteurs) && count ($connecteurs) > 0){

            $this->connecteur = $connecteurs[0];
            switch ($this->connecteur->architecture){
                case 'rest':
                    $this->connexion_rest();
                    break;
                case 'soap':
                    $this->connexion_soap();
                    break;
                default :
                    $this->retour_traitement['erreur_architecture'] = 'Architecture connecteur différente de Rest/Soap';
                    break;
            }
        }else{
            $this->retour_traitement['erreur_connecteur'] = 'Aucun connecteur n\'est lié au flux';
        }


        return $this->retour_traitement;
    }
   
    /**
    * init_modal()
    * 
    * @return Array           - Tableau avec le résultat et les erreurs rencontrées
    */
    public function init_modal($flux){

        $this->flux = $flux;

        $connecteurs = $this->flux->get_linked_beans("ops_connecteur_ops_flux","OPS_connecteur");   

        if ( is_array($connecteurs) && count ($connecteurs) > 0){

            $this->connecteur = $connecteurs[0];

            $this->retour_traitement['connecteur']['name'] = $this->connecteur->name;
            $this->retour_traitement['connecteur']['url_api'] = $this->connecteur->url_api;
            $this->retour_traitement['connecteur']['architecture'] = $this->connecteur->architecture; 
            $this->retour_traitement['connecteur']['type_connexion'] = $this->connecteur->type_connexion;
            $this->retour_traitement['connecteur']['identifiant'] = $this->connecteur->identifiant;
            $this->retour_traitement['connecteur']['password'] = $this->connecteur->password;
            $this->retour_traitement['connecteur']['path_connexion'] = $this->connecteur->path_connexion;
            $this->retour_traitement['connecteur']['valeur_retour'] = $this->connecteur->valeur_retour;
            $this->retour_traitement['connecteur']['token'] = $this->connecteur->token;
            $this->retour_traitement['connecteur']['nom_token'] = $this->connecteur->nom_token;
            $this->retour_traitement['connecteur']['grant_type'] = $this->connecteur->grant_type;
            $this->retour_traitement['connecteur']['client_id'] = $this->connecteur->client_id;
            $this->retour_traitement['connecteur']['client_secret'] = $this->connecteur->client_secret;
            $this->retour_traitement['connecteur']['scope'] = $this->connecteur->scope;

            $this->retour_traitement['flux']['name'] = $this->flux->name;
            $this->retour_traitement['flux']['methode'] = $this->flux->methode;
            $this->retour_traitement['flux']['path'] = $this->flux->path;
            $this->retour_traitement['flux']['content_type'] = $this->flux->content_type;
            $this->retour_traitement['flux']['objet'] = $this->flux->objet;

        }else{
            $this->retour_traitement['erreur_connecteur'] = 'Aucun connecteur n\'est lié au flux';
        }


        return $this->retour_traitement;
    }

}
